/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SheetRidReader
extends DefaultHandler {
    private static final String TAG_NAME = "sheet";
    private static final String RID_ATTR = "r:id";
    private static final String SHEET_ID_ATTR = "sheetId";
    private static final String NAME_ATTR = "name";
    private final Map<Integer, Integer> ID_RID_MAP = new HashMap<Integer, Integer>();
    private final Map<String, Integer> NAME_RID_MAP = new HashMap<String, Integer>();

    public SheetRidReader read(XSSFReader xssfReader) {
        InputStream workbookData = null;
        try {
            workbookData = xssfReader.getWorkbookData();
            ExcelSaxUtil.readFrom(workbookData, this);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            IoUtil.close(workbookData);
        }
        return this;
    }

    public Integer getRidBySheetId(int sheetId) {
        return this.ID_RID_MAP.get(sheetId);
    }

    public Integer getRidBySheetIdBase0(int sheetId) {
        Integer rid = this.getRidBySheetId(sheetId + 1);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    public Integer getRidByName(String sheetName) {
        return this.NAME_RID_MAP.get(sheetName);
    }

    public Integer getRidByNameBase0(String sheetName) {
        Integer rid = this.getRidByName(sheetName);
        if (null != rid) {
            return rid - 1;
        }
        return null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (TAG_NAME.equalsIgnoreCase(localName)) {
            String sheetIdStr;
            String ridStr = attributes.getValue(RID_ATTR);
            if (StrUtil.isEmpty(ridStr)) {
                return;
            }
            int rid = Integer.parseInt(StrUtil.removePrefixIgnoreCase(ridStr, "rId"));
            String name = attributes.getValue(NAME_ATTR);
            if (StrUtil.isNotEmpty(name)) {
                this.NAME_RID_MAP.put(name, rid);
            }
            if (StrUtil.isNotEmpty(sheetIdStr = attributes.getValue(SHEET_ID_ATTR))) {
                this.ID_RID_MAP.put(Integer.parseInt(sheetIdStr), rid);
            }
        }
    }
}

