/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.dbmapping.DBMappingHelper;
import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.DuplicatedFieldException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalField
extends ActualField {
    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm, Field paramField) {
        block3: {
            if (value != null) break block3;
            pstmt.setNull(index, 3);
            return;
        }
        try {
            pstmt.setBigDecimal(index, (BigDecimal)value);
            return;
        }
        catch (ClassCastException | SQLException a2) {
            System.err.println(new StringBuilder().insert(0, DBMappingHelper.ALLATORIxDEMO("+Y\b\\\t\u0010\u0003Q\u0000UM_\u000b\u0010\u001dQ\u001fQ\u0000U\u0019U\u001f\nM")).append(paramField.getName()).toString());
            throw new DataAccessException(DuplicatedFieldException.ALLATORIxDEMO("T#sfc#d/j'kfs)'\u0016u#w'u#c\u0015s's#j#i2'#u4h4"), a2);
        }
    }

    @Override
    public String getName() {
        return "Decimal";
    }

    public DecimalField() {
        super(BigDecimal.class);
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return jsonValue;
        }
        if (jsonValue instanceof Long) {
            return BigDecimal.valueOf((Long)jsonValue);
        }
        if (jsonValue instanceof Integer) {
            return new BigDecimal((Integer)jsonValue);
        }
        if (jsonValue instanceof String) {
            return new BigDecimal(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Double) {
            return BigDecimal.valueOf((Double)jsonValue);
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, DBMappingHelper.ALLATORIxDEMO("Y\u0003F\f\\\u0004TMT\fD\f\u0010\u000b_\u001f]\fDW\u00106")).append(jsonValue).append("]").toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        try {
            ResultSet resultSet = rs;
            BigDecimal a2 = resultSet.getBigDecimal(index);
            if (resultSet.wasNull()) {
                return null;
            }
            int a3 = field.getFieldViewModel() == null || field.getFieldViewModel().getPrecision() == null ? 2 : field.getFieldViewModel().getPrecision();
            return a2.setScale(a3, RoundingMode.HALF_UP);
        }
        catch (SQLException a4) {
            throw new DataAccessException(DuplicatedFieldException.ALLATORIxDEMO("@#sfc#d/j'kfa4h+'\u0014b5r*s\u0015b2'#u4h4"), a4);
        }
    }
}

