/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.metadata.fieldtype;

import cn.granitech.variantorm.exception.DataAccessException;
import cn.granitech.variantorm.exception.DuplicatedEntityException;
import cn.granitech.variantorm.metadata.impl.ActualField;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.license.OfflineLicenseHelper;
import cn.granitech.variantorm.pojo.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class BigIntegerField
extends ActualField {
    public BigIntegerField() {
        super(Long.class);
    }

    @Override
    public Object fromJson(Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue instanceof BigDecimal) {
            return ((BigDecimal)jsonValue).setScale(0, RoundingMode.HALF_UP).longValue();
        }
        if (jsonValue instanceof Long) {
            return (Long)jsonValue;
        }
        if (jsonValue instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)jsonValue))) {
                return null;
            }
            return new Long(((String)jsonValue).replaceAll(",", ""));
        }
        if (jsonValue instanceof Integer) {
            return (Integer)jsonValue;
        }
        throw new IllegalArgumentException(new StringBuilder().insert(0, DuplicatedEntityException.ALLATORIxDEMO(">\b!\u0007;\u000f3F3\u0007#\u0007w\u00008\u0014:\u0007#\\w=")).append(jsonValue).append("]").toString());
    }

    @Override
    public void setParamValue(PreparedStatement pstmt, int index, Object value, PersistenceManager pm, Field paramField) {
        block3: {
            if (value != null) break block3;
            pstmt.setNull(index, -5);
            return;
        }
        try {
            pstmt.setLong(index, (Long)value);
            return;
        }
        catch (ClassCastException | SQLException a2) {
            System.err.println(new StringBuilder().insert(0, DuplicatedEntityException.ALLATORIxDEMO(" >\u0003;\u0002w\b6\u000b2F8\u0000w\u00166\u00146\u000b2\u00122\u0014mF")).append(paramField.getName()).toString());
            throw new DataAccessException(OfflineLicenseHelper.ALLATORIxDEMO(".\f\tI\u0014\u0007\t\f\u001a\f\u000fI\t\u0006]9\u000f\f\r\b\u000f\f\u0019:\t\b\t\f\u0010\f\u0013\u001d]\f\u000f\u001b\u0012\u001b"), a2);
        }
    }

    @Override
    public String getName() {
        return "BigInteger";
    }

    @Override
    public Object readDBValue(PersistenceManager pm, Field field, ResultSet rs, int index) {
        long a2;
        block3: {
            try {
                ResultSet resultSet = rs;
                a2 = resultSet.getLong(index);
                if (!resultSet.wasNull()) break block3;
                return null;
            }
            catch (SQLException a3) {
                throw new DataAccessException(OfflineLicenseHelper.ALLATORIxDEMO(":\f\tI\u0014\u0007\t\f\u001a\f\u000fI\u001b\u001b\u0012\u0004];\u0018\u001a\b\u0005\t:\u0018\u001d]\f\u000f\u001b\u0012\u001b"), a3);
            }
        }
        return a2;
    }
}

