/*
 * Decompiled with CFR 0.152.
 */
package cn.granitech.variantorm.dbmapping;

import cn.granitech.variantorm.constant.ReservedFields;
import cn.granitech.variantorm.constant.SystemEntities;
import cn.granitech.variantorm.dbmapping.DBMappingHelper;
import cn.granitech.variantorm.dbmapping.J;
import cn.granitech.variantorm.dbmapping.d;
import cn.granitech.variantorm.dbmapping.ddl.DBDDL;
import cn.granitech.variantorm.dbmapping.ddl.DBDDLHelper;
import cn.granitech.variantorm.dbmapping.i;
import cn.granitech.variantorm.exception.DuplicatedEntityException;
import cn.granitech.variantorm.exception.DuplicatedFieldException;
import cn.granitech.variantorm.exception.InvalidEntityCodeException;
import cn.granitech.variantorm.exception.LicenseException;
import cn.granitech.variantorm.metadata.MetadataManager;
import cn.granitech.variantorm.metadata.fieldtype.FieldTypes;
import cn.granitech.variantorm.persistence.PersistenceManager;
import cn.granitech.variantorm.persistence.TenantContext;
import cn.granitech.variantorm.persistence.dialect.Dialect;
import cn.granitech.variantorm.persistence.license.LicenseInfo;
import cn.granitech.variantorm.pojo.Entity;
import cn.granitech.variantorm.pojo.Field;
import cn.granitech.variantorm.util.MD5Helper;
import java.io.Serializable;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DBMappingManager {
    private final DataSource H;
    private final DBDDL C;
    private final TenantContext k;
    private final PersistenceManager f;
    private final MetadataManager ALLATORIxDEMO;

    public DBMappingManager(DataSource dataSource, MetadataManager mdm) {
        DataSource dataSource2 = dataSource;
        DBMappingManager dBMappingManager = this;
        DBMappingManager dBMappingManager2 = this;
        dBMappingManager2.H = dataSource;
        dBMappingManager2.ALLATORIxDEMO = mdm;
        dBMappingManager.f = null;
        dBMappingManager.k = null;
        this.C = DBDDLHelper.getDBDDL(dataSource2);
        DBMappingHelper.loadMetadataFromDB(dataSource2, this.ALLATORIxDEMO);
    }

    public MetadataManager getCurMDM() {
        if (this.k == null) {
            return this.ALLATORIxDEMO;
        }
        return this.k.getMetadataManager();
    }

    public DBMappingManager(TenantContext tenantContext, PersistenceManager pm) {
        DBMappingManager dBMappingManager = this;
        this.H = null;
        dBMappingManager.ALLATORIxDEMO = null;
        dBMappingManager.k = tenantContext;
        this.f = pm;
        TenantContext tenantContext2 = tenantContext;
        this.C = DBDDLHelper.getDBDDL(this.f.getSqlCompiler().getDatabaseType(), tenantContext2.getDataSource());
        DBMappingHelper.loadMetadataFromDB(tenantContext2.getDataSource(), tenantContext.getMetadataManager());
    }

    private /* synthetic */ void ALLATORIxDEMO(Entity entity, Integer startEntityCode, Integer entityCodeLimit) {
        Object a2;
        Serializable a3;
        if (this.f != null) {
            a3 = this.f.getLicenseInfo();
            if (((LicenseInfo)a3).isDeliveryLicense().booleanValue()) {
                throw new LicenseException(MD5Helper.ALLATORIxDEMO("\u5f14\u5262\u63cf\u676c\u4e7d\u4e8b\u4e9f\u63a7\u6704\uff23\u4e4a\u6500\u6346\u5234\u5ebd\u5bb1\u4f14\u302d"));
            }
            if (((LicenseInfo)a3).getEntityLimit() != null) {
                a2 = ((LicenseInfo)a3).getEntityLimit();
                Dialect a4 = this.f.getDialect();
                Object[] objectArray = new Object[2];
                objectArray[0] = a4.getQuotedTableName(MD5Helper.ALLATORIxDEMO("[\u0018B\"[&p\"A3F3V"));
                objectArray[1] = a4.getQuotedIdentifier("entityCode");
                String a5 = String.format(InvalidEntityCodeException.ALLATORIxDEMO("ET K D1'\u0006h\u0010i\u0011/O.EA7H('@tEp\rb\u0017bE\"\u0016'['T7U7E"), objectArray);
                Integer a6 = (Integer)new JdbcTemplate(this.getCurDS()).queryForObject(a5, Integer.class);
                if (a6 != null && a6 >= (Integer)a2) {
                    Object[] objectArray2 = new Object[1];
                    objectArray2[0] = a2;
                    throw new LicenseException(String.format(InvalidEntityCodeException.ALLATORIxDEMO("\u5f54\u5228\u7cfc\u7eba\u724f\u6749\u6707\u597f\u6528\u6364\"\u0001\u4e2d\u818f\u5b9d\u4e2c\u5b99\u4f36\uff0b\u5d97\u8d82\u519f\u6b63\u9635\u5231\uff64"), objectArray2));
                }
            }
        }
        if (DBMappingHelper.checkEntityExists(this.getCurDS(), this.getCurMDM(), entity.getName())) {
            throw new DuplicatedEntityException(new StringBuilder().insert(0, MD5Helper.ALLATORIxDEMO("\u5bd9\u4f7c")).append(entity.getName()).append(InvalidEntityCodeException.ALLATORIxDEMO("\u5df5\u5b3d\u572fD")).toString());
        }
        if (DBMappingHelper.checkTableExists(this.getCurDS(), this.getCurMDM(), entity.getPhysicalName())) {
            throw new IllegalStateException(new StringBuilder().insert(0, MD5Helper.ALLATORIxDEMO("\u6537\u6341\u5ed4\u8847")).append(entity.getPhysicalName()).append(InvalidEntityCodeException.ALLATORIxDEMO("\u5df5\u5b3d\u572fD")).toString());
        }
        try {
            DBMappingManager dBMappingManager = this;
            DBMappingManager dBMappingManager2 = this;
            dBMappingManager.C.createEntityTable(dBMappingManager2.f, entity);
            DBMappingHelper.insertMetaEntityRecord(dBMappingManager2.f, this.getCurMDM(), entity, startEntityCode, entityCodeLimit);
            dBMappingManager.getCurMDM().addEntity(entity);
            a3 = entity.getIdField();
            DBMappingManager dBMappingManager3 = this;
            a2 = dBMappingManager3.getCurMDM().getDialect().getRealFieldName(((Field)a3).getPhysicalName());
            ((Field)a3).setPhysicalName((String)a2);
            DBMappingManager dBMappingManager4 = this;
            DBMappingHelper.insertMetaFieldRecord(dBMappingManager3.f, dBMappingManager4.getCurMDM(), entity.getEntityCode(), (Field)a3);
            dBMappingManager4.getCurMDM().addField(entity.getName(), (Field)a3);
            DBMappingManager dBMappingManager5 = this;
            DBMappingManager dBMappingManager6 = this;
            Entity entity2 = entity;
            DBMappingManager dBMappingManager7 = this;
            dBMappingManager7.e(entity, dBMappingManager7.getCurMDM(), "createdOn", MD5Helper.ALLATORIxDEMO("\u525c\u5ed5\u65b1\u95db"), false, false, false);
            dBMappingManager6.ALLATORIxDEMO(entity2, dBMappingManager7.getCurMDM(), "createdBy", InvalidEntityCodeException.ALLATORIxDEMO("\u521c\u5e9f\u752f\u6252"), "User", false, false, false);
            dBMappingManager5.e(entity2, dBMappingManager6.getCurMDM(), "modifiedOn", MD5Helper.ALLATORIxDEMO("\u6747\u8ffe\u4fa9\u6516\u65b1\u95db"), true, false, false);
            dBMappingManager5.ALLATORIxDEMO(entity, dBMappingManager5.getCurMDM(), "modifiedBy", InvalidEntityCodeException.ALLATORIxDEMO("\u4fe9\u655c\u752f\u6252"), "User", true, false, false);
            if (entity.isAuthorizable() || entity.isAssignable()) {
                DBMappingManager dBMappingManager8 = this;
                Entity entity3 = entity;
                dBMappingManager8.ALLATORIxDEMO(entity3, this.getCurMDM(), "ownerUser", MD5Helper.ALLATORIxDEMO("\u6207\u5c71\u756f\u6218"), "User", false, false, false);
                dBMappingManager8.ALLATORIxDEMO(entity3, dBMappingManager8.getCurMDM(), "ownerDepartment", InvalidEntityCodeException.ALLATORIxDEMO("\u6247\u5c3b\u90ef\u958d"), "Department", false, false, false);
                return;
            }
        }
        catch (Exception a7) {
            a7.printStackTrace();
            try {
                System.err.println(MD5Helper.ALLATORIxDEMO("j?L\"_3F(AgN3\u000f#@\u0002A3F3V\u0004]\"N3F(Ak\u000f5@+C%N$DgK#CgN)KgB\"[&K&[&\u0001"));
                this.ALLATORIxDEMO(entity);
                return;
            }
            catch (Exception a8) {
                a8.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void ALLATORIxDEMO(Entity entity) {
        void entity2;
        DBMappingManager dBMappingManager = this;
        DBMappingManager dBMappingManager2 = this;
        dBMappingManager.C.deleteEntityTable(dBMappingManager2.f, (Entity)entity2);
        DBMappingHelper.deleteMetaEntityRecord(dBMappingManager.f, this.getCurMDM(), entity2.getName(), entity2.getEntityCode());
        dBMappingManager2.getCurMDM().removeEntity(entity2.getName());
    }

    private /* synthetic */ void e(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.DATETIME);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.f, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    public void deleteField(String entityName, String fieldName) {
        if (ReservedFields.isReservedField(entityName, fieldName)) {
            throw new IllegalStateException(InvalidEntityCodeException.ALLATORIxDEMO("\u7c9e\u7ed8\u4fb8\u755e\u5b32\u6bb2\u4e68\u53e8\u5245\u9663D"));
        }
        Field a2 = this.getCurMDM().getEntity(entityName).getField(fieldName);
        int a3 = a2.getOwner().getEntityCode();
        if (a2.getType() != FieldTypes.REFERENCELIST) {
            DBMappingManager dBMappingManager = this;
            dBMappingManager.C.deleteFieldColumn(dBMappingManager.f, a2);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.deleteMetaFieldRecord(dBMappingManager.f, this.getCurMDM(), a3, fieldName);
        dBMappingManager.getCurMDM().removeField(entityName, fieldName);
    }

    private /* synthetic */ void d(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.TEXTAREA);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.f, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    /*
     * WARNING - void declaration
     */
    public DBMappingManager(DataSource dataSource, MetadataManager metadataManager, PersistenceManager persistenceManager) {
        void pm;
        void mdm;
        void dataSource2;
        DBMappingManager dBMappingManager = this;
        this.H = dataSource2;
        dBMappingManager.ALLATORIxDEMO = mdm;
        dBMappingManager.f = pm;
        this.k = null;
        this.C = DBDDLHelper.getDBDDL(pm.getSqlCompiler().getDatabaseType(), (DataSource)dataSource2);
        DBMappingHelper.loadMetadataFromDB(dataSource, this.ALLATORIxDEMO);
    }

    /*
     * WARNING - void declaration
     */
    public void updateEntity(Entity entity) {
        void entity2;
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.updateMetaEntityRecord(this.f, dBMappingManager.getCurMDM(), (Entity)entity2);
        dBMappingManager.getCurMDM().updateEntity((Entity)entity2);
    }

    public void loadMetadata() {
        if (this.k != null) {
            if (!this.f.getLicenseInfo().getTenantSwitch().booleanValue()) {
                throw new LicenseException(MD5Helper.ALLATORIxDEMO("\u5f14\u5262\u63cf\u676c\u4e4a\u5404\u595d\u79f0\u6270\u52b0\u80ba\uff23\u8bb0\u4f50\u756f\u537a\u7998\u6218\u720f\u6703\uff4b\u6239\u8042\u807b\u7cbc\u5bb7\u65fe\u5b8d\u674a\u302d"));
            }
            DBMappingHelper.loadMetadataFromDB(this.k.getDataSource(), this.k.getMetadataManager());
        }
    }

    public void createEntity(Entity entity) {
        this.ALLATORIxDEMO(entity, null, null);
    }

    public DataSource getCurDS() {
        if (this.k == null) {
            return this.H;
        }
        return this.k.getDataSource();
    }

    /*
     * WARNING - void declaration
     */
    public void createApprovalSystemFields(Entity entity) {
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        int a7 = entity.getEntityCode();
        Field field = new Field();
        void v0 = a6;
        void v1 = a6;
        void v2 = a6;
        a6.setName("approvalConfigId");
        v2.setLabel(MD5Helper.ALLATORIxDEMO("\u5be6\u6256\u6d06\u7a24"));
        v2.setPhysicalName("approvalConfigId");
        v2.setType(FieldTypes.REFERENCE);
        a6.setReferTo(new i(this));
        v1.setNullable(true);
        v1.setCreatable(false);
        v0.setUpdatable(false);
        v0.setOwner(entity);
        DBMappingManager dBMappingManager = this;
        this.createField(a7, (Field)a6);
        Field field2 = new Field();
        void v4 = a5;
        void v5 = a5;
        void v6 = a5;
        a5.setName("approvalStatus");
        v6.setLabel(InvalidEntityCodeException.ALLATORIxDEMO("\u5ba6\u621c\u72b1\u6064"));
        v6.setPhysicalName("approvalStatus");
        v6.setType(FieldTypes.STATUS);
        v5.setNullable(true);
        v5.setCreatable(false);
        v4.setUpdatable(false);
        v4.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a5);
        Field field3 = new Field();
        void v7 = a4;
        void v8 = a4;
        void v9 = a4;
        void v10 = a4;
        a4.setName("lastApprovedBy");
        v10.setLabel(MD5Helper.ALLATORIxDEMO("\u672f\u8f96\u5b8e\u623e\u4e95"));
        v9.setPhysicalName("lastApprovedBy");
        v10.setType(FieldTypes.REFERENCE);
        v9.setReferTo(new J(this));
        v8.setNullable(true);
        v8.setCreatable(false);
        v7.setUpdatable(false);
        v7.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a4);
        Field field4 = new Field();
        void v11 = a3;
        void v12 = a3;
        void v13 = a3;
        a3.setName("lastApprovedOn");
        v13.setLabel(InvalidEntityCodeException.ALLATORIxDEMO("\u6707\u8fb4\u5ba6\u621c\u65f1\u9591"));
        v13.setPhysicalName("lastApprovedOn");
        v13.setType(FieldTypes.DATETIME);
        v12.setNullable(true);
        v12.setCreatable(false);
        v11.setUpdatable(false);
        v11.setOwner(entity);
        this.createField(a7, (Field)a3);
        Field field5 = new Field();
        void v14 = a2;
        void v15 = a2;
        void v16 = a2;
        a2.setName("lastApprovalRemark");
        v16.setLabel(MD5Helper.ALLATORIxDEMO("\u6747\u8ffe\u5be6\u6256\u623e\u6cc7"));
        v16.setPhysicalName("lastApprovalRemark");
        v16.setType(FieldTypes.TEXTAREA);
        v15.setNullable(true);
        v15.setCreatable(false);
        v14.setUpdatable(false);
        v14.setOwner(entity);
        dBMappingManager.createField(a7, (Field)a2);
    }

    public DBDDL getDBDDL() {
        return this.C;
    }

    private /* synthetic */ void ALLATORIxDEMO(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.INTEGER);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.f, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    public void createAppEntity(Entity entity, Integer startEntityCode, Integer entityCodeLimit) {
        this.ALLATORIxDEMO(entity, startEntityCode, entityCodeLimit);
    }

    public void createField(int entityCode, Field field) {
        if (DBMappingHelper.checkFieldExists(this.getCurDS(), this.getCurMDM(), field.getOwner().getEntityCode(), field.getName())) {
            throw new DuplicatedFieldException(new StringBuilder().insert(0, MD5Helper.ALLATORIxDEMO("\u5b10\u6b9a")).append(field.getName()).append(InvalidEntityCodeException.ALLATORIxDEMO("\u5d97\u5b5f\u574d")).toString());
        }
        String a2 = this.getCurMDM().getDialect().getRealFieldName(field.getPhysicalName());
        Field field2 = field;
        field2.setPhysicalName(a2);
        if (field2.getType() != FieldTypes.REFERENCELIST) {
            DBMappingManager dBMappingManager = this;
            dBMappingManager.C.createFieldColumn(dBMappingManager.f, field);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.insertMetaFieldRecord(dBMappingManager.f, this.getCurMDM(), entityCode, field);
        dBMappingManager.getCurMDM().addField(field.getOwner().getName(), field);
    }

    /*
     * WARNING - void declaration
     */
    public DBMappingManager(TenantContext tenantContext, DataSource dataSource, MetadataManager metadataManager, PersistenceManager persistenceManager) {
        void dataSource2;
        void pm;
        void tenantContext2;
        DBMappingManager dBMappingManager = this;
        DBMappingManager dBMappingManager2 = this;
        this.H = null;
        dBMappingManager2.ALLATORIxDEMO = null;
        dBMappingManager2.k = tenantContext2;
        dBMappingManager.f = pm;
        dBMappingManager.C = DBDDLHelper.getDBDDL(pm.getSqlCompiler().getDatabaseType(), (DataSource)dataSource2);
        DBMappingHelper.loadMetadataFromDB(dataSource, metadataManager);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteEntity(String entityName) {
        void a2;
        if (SystemEntities.isInternalEntity(entityName) || SystemEntities.isSystemEntity(entityName)) {
            throw new IllegalStateException(InvalidEntityCodeException.ALLATORIxDEMO("\u7cfc\u7eba\u5b99\u4f36\u3006\u51e0\u90ef\u5bfb\u4f54\u4e68\u53e8\u5245\u9663D"));
        }
        DBMappingManager dBMappingManager = this;
        Entity entity = dBMappingManager.getCurMDM().getEntity(entityName);
        DBMappingManager dBMappingManager2 = this;
        dBMappingManager.C.deleteEntityTable(dBMappingManager2.f, (Entity)a2);
        DBMappingHelper.deleteMetaEntityRecord(dBMappingManager2.f, this.getCurMDM(), entityName, a2.getEntityCode());
        dBMappingManager.getCurMDM().removeEntity(entityName);
    }

    public void reloadMetadata() {
        if (this.k != null) {
            if (!this.f.getLicenseInfo().getTenantSwitch().booleanValue()) {
                throw new LicenseException(InvalidEntityCodeException.ALLATORIxDEMO("\u5f54\u5228\u638f\u6726\u4e0a\u544e\u591d\u79ba\u6230\u52fa\u80fa\uff69\u8bf0\u4f1a\u752f\u5330\u79d8\u6252\u724f\u6749\uff0b\u6273\u8002\u8031\u7cfc\u5bfd\u65be\u5bc7\u670a\u3067"));
            }
            MetadataManager a2 = this.k.getMetadataManager();
            if (a2 != null) {
                a2.reloadCache(this.k.getDataSource());
            }
        }
    }

    private /* synthetic */ void ALLATORIxDEMO(Entity entity, MetadataManager mdm, String fieldName, String fieldLabel, String refToEntityName, Boolean nullable, Boolean creatable, Boolean updatable) {
        Field a2;
        Field field = a2 = new Field();
        a2.setName(fieldName);
        field.setLabel(fieldLabel);
        a2.setPhysicalName(mdm.getDialect().getRealFieldName(fieldName));
        field.setType(FieldTypes.REFERENCE);
        a2.setNullable(nullable);
        a2.setCreatable(creatable);
        a2.setUpdatable(updatable);
        Entity a3 = mdm.getEntity(refToEntityName);
        Field field2 = a2;
        a2.setReferTo(new d(this, a3));
        a2.setOwner(entity);
        MetadataManager metadataManager = mdm;
        DBMappingHelper.insertMetaFieldRecord(this.f, metadataManager, entity.getEntityCode(), a2);
        metadataManager.addField(entity.getName(), a2);
    }

    public void updateField(int entityCode, Field field) {
        if (entityCode != field.getEntityCode()) {
            throw new IllegalArgumentException(MD5Helper.ALLATORIxDEMO("J)[.[>\u000f$@#JgB.\\*N3L/J#\u000e"));
        }
        Entity a2 = this.getCurMDM().getEntity(entityCode);
        Field a3 = a2.getField(field.getName());
        Field field2 = field;
        Field field3 = a3;
        Field field4 = field;
        field4.setName(a3.getName());
        field4.setPhysicalName(a3.getPhysicalName());
        field.setType(field3.getType());
        field2.setIdFieldFlag(field3.isIdFieldFlag());
        field2.setMainDetailFieldFlag(a3.isMainDetailFieldFlag());
        if (field2.getType() == FieldTypes.REFERENCE) {
            field.setReferTo(a3.getReferTo());
        }
        if (field.getType() != FieldTypes.REFERENCELIST) {
            DBMappingManager dBMappingManager = this;
            dBMappingManager.C.alterFieldColumn(dBMappingManager.f, field);
        }
        DBMappingManager dBMappingManager = this;
        DBMappingHelper.updateMetaFieldRecord(dBMappingManager.f, this.getCurMDM(), entityCode, field);
        dBMappingManager.getCurMDM().updateField(a2.getName(), field.getName(), field);
    }
}

