/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.KBProperty;
import com.kingbase8.core.KBStream;
import com.kingbase8.core.SocketFactoryFactory;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.ssl.KBjdbcHostnameVerifier;
import com.kingbase8.ssl.LibKCIFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class MakeSSL
extends ObjectFactory {
    public static void convert(KBStream stream, Properties propInfo) throws KSQLException, IOException {
        SSLSocket newSSLSocketT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINE, "converting regular socket connection to ssl", new Object[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SSLSocketFactory sslSocketFactoryT = SocketFactoryFactory.getSslSocketFactory(propInfo);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT = (SSLSocket)sslSocketFactoryT.createSocket(stream.getSocket(), stream.getHostSpec().getHost(), stream.getHostSpec().getPort(), true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT.setUseClientMode(true);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newSSLSocketT.startHandshake();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        catch (IOException ex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String e1 = "SSL error: {0}";
            throw new KSQLException(GT.tr(e1, ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (sslSocketFactoryT instanceof LibKCIFactory) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ((LibKCIFactory)sslSocketFactoryT).throwKeyManagerException();
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SslMode sslModeT = SslMode.of(propInfo);
        if (sslModeT.verifyPeerName()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            MakeSSL.verifyPeerName(stream, propInfo, newSSLSocketT);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        stream.changeSocket(newSSLSocketT);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    private static void verifyPeerName(KBStream stream, Properties info, SSLSocket newConn) throws KSQLException {
        HostnameVerifier hvn;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String sslhostnameverifier = KBProperty.SSL_HOSTNAME_VERIFIER.get(info);
        if (sslhostnameverifier == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hvn = KBjdbcHostnameVerifier.INSTANCE;
            sslhostnameverifier = "KbjdbcHostnameVerifier";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                hvn = MakeSSL.instantiate(HostnameVerifier.class, sslhostnameverifier, info, false, null);
            }
            catch (Exception e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String e1 = "The HostnameVerifier class provided {0} could not be instantiated.";
                throw new KSQLException(GT.tr(e1, sslhostnameverifier), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (hvn.verify(stream.getHostSpec().getHost(), newConn.getSession())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String e1 = "The hostname {0} could not be verified by hostnameverifier {1}.";
        throw new KSQLException(GT.tr(e1, stream.getHostSpec().getHost(), sslhostnameverifier), KSQLState.CONNECTION_FAILURE);
    }
}

