/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.SQLServerFormatEmulation;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class Kingbase8SqlserverDialect
extends PostgreSQLDialect {
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 8: {
                return "float";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case 93: {
                return "datetime2($p)";
            }
            case 2004: {
                return "varbinary(max)";
            }
            case 2005: {
                return "varchar(max)";
            }
            case 2011: {
                return "nvarchar(max)";
            }
            case 2013: 
            case 2014: {
                return "datetimeoffset($p)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("concat", "concat(?1,?2...)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.impliedOrInvariant((TypeConfiguration)functionContributions.getTypeConfiguration(), (FunctionParameterType)FunctionParameterType.STRING)).setArgumentListSignature("(STRING string0[, STRING string1[, ...]])").register();
        functionContributions.getFunctionRegistry().register("count", (SqmFunctionDescriptor)new CountFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count", "+", "varchar(max)", false));
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.log_log();
        functionFactory.round_round();
        functionFactory.everyAny_minMaxIif();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        functionFactory.locate_charindex();
        functionFactory.stddevPopSamp_stdevp();
        functionFactory.varPopSamp_varp();
        functionContributions.getFunctionRegistry().register("format", (SqmFunctionDescriptor)new SQLServerFormatEmulation(functionContributions.getTypeConfiguration()));
        functionFactory.translate();
        functionFactory.median_percentileCont(true);
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datefromparts").setInvariantType(dateType).setExactArgumentCount(3).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timefromparts").setInvariantType(timeType).setExactArgumentCount(5).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("smalldatetimefromparts").setInvariantType(timestampType).setExactArgumentCount(5).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimefromparts").setInvariantType(timestampType).setExactArgumentCount(7).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetime2fromparts").setInvariantType(timestampType).setExactArgumentCount(8).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimeoffsetfromparts").setInvariantType(timestampType).setExactArgumentCount(10).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionFactory.windowFunctions();
        functionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.listagg_stringAggWithinGroup("varchar(max)");
        functionFactory.leastGreatest();
        functionFactory.dateTrunc_datetrunc();
        functionFactory.trunc_round_datetrunc();
    }

    public String getSelectGUIDString() {
        return "select sys_guid_name()";
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }
}

