/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.spi.TypeConfiguration;

public class Kingbase8MysqlDialect
extends PostgreSQLDialect {
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 2: {
                return this.columnType(3);
            }
            case -6: {
                return "tinyint";
            }
            case 16: {
                return "bit";
            }
            case 93: {
                return "datetime($p)";
            }
            case 2004: {
                return "longblob";
            }
            case 2005: 
            case 2011: {
                return "longtext";
            }
            case 2013: {
                return "time($p)";
            }
            case 2014: {
                return "timestamp($p)";
            }
            case -3: {
                return "varbinary($l)";
            }
            case -2: {
                return "binary($l)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionContributions.getFunctionRegistry().patternDescriptorBuilder("concat", "concat(?1,?2...)").setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).setMinArgumentCount(1).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.impliedOrInvariant((TypeConfiguration)functionContributions.getTypeConfiguration(), (FunctionParameterType)FunctionParameterType.STRING)).setArgumentListSignature("(STRING string0[, STRING string1[, ...]])").register();
        functionFactory.soundex();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.cot();
        functionFactory.log();
        functionFactory.log2();
        functionFactory.log10();
        functionFactory.trim2();
        functionFactory.octetLength();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.pad_space();
        functionFactory.md5();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.date();
        functionFactory.timestamp();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("time").setExactArgumentCount(1).setInvariantType(functionContributions.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.STRING)).register();
        functionFactory.utcDateTimeTimestamp();
        functionFactory.rand();
        functionFactory.crc32();
        functionFactory.sha1();
        functionFactory.sha2();
        functionFactory.sha();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.nowCurdateCurtime();
        functionFactory.trunc_truncate();
        functionFactory.insert();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.datediff();
        functionFactory.adddateSubdateAddtimeSubtime();
        functionFactory.format_dateFormat();
        functionFactory.makedateMaketime();
        functionFactory.localtimeLocaltimestamp();
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functionRegistry.noArgsBuilder("localtime").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP)).setUseParenthesesWhenNoArgs(false).register();
        functionRegistry.patternDescriptorBuilder("pi", "cast(pi() as decimal(53,15))").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE)).setExactArgumentCount(0).setArgumentListSignature("").register();
        functionRegistry.patternDescriptorBuilder("chr", "char(?1 using ascii)").setInvariantType(basicTypeRegistry.resolve(StandardBasicTypes.CHARACTER)).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.INTEGER}).register();
        functionRegistry.registerAlternateKey("char", "chr");
        functionFactory.sysdateExplicitMicros();
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        functionFactory.listagg_groupConcat();
    }

    public String getSelectGUIDString() {
        return "select sys_guid_name()";
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                if (temporalAccessor instanceof ZonedDateTime) {
                    temporalAccessor = ((ZonedDateTime)temporalAccessor).toOffsetDateTime();
                }
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone, (boolean)false);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Date)date);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMicros((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date '");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIME: {
                appender.appendSql("time '");
                DateTimeUtils.appendAsLocalTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql('\'');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("timestamp '");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql('\'');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement){

                    public void visitLikePredicate(LikePredicate likePredicate) {
                        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
                        if (likePredicate.isNegated()) {
                            this.appendSql(" not");
                        }
                        if (likePredicate.isCaseSensitive()) {
                            this.appendSql(" like ");
                        } else {
                            this.appendSql(' ');
                            this.appendSql(this.getDialect().getCaseInsensitiveLike());
                            this.appendSql(' ');
                        }
                        likePredicate.getPattern().accept((SqlAstWalker)this);
                        if (likePredicate.getEscapeCharacter() != null) {
                            this.appendSql(" escape ");
                            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
                        }
                    }
                };
            }
        };
    }

    public char closeQuote() {
        return '`';
    }

    public char openQuote() {
        return '`';
    }
}

