/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.PostgreSQLSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.ModeStatsModeEmulation;
import org.hibernate.dialect.function.OracleTruncFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class Kingbase8Dialect
extends PostgreSQLDialect {
    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 16: {
                return "bool";
            }
            case -7: {
                return "bit";
            }
            case 2004: {
                return "blob";
            }
            case 2005: {
                return "clob";
            }
            case 2011: {
                return "nclob";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.cosh();
        functionFactory.sinh();
        functionFactory.tanh();
        functionFactory.log();
        functionFactory.log10_log();
        functionFactory.soundex();
        functionFactory.trim2();
        functionFactory.initcap();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.leftRight_substr();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.lastDay();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.ceiling_ceil();
        functionFactory.concat_pipeOperator();
        functionFactory.rownumRowid();
        functionFactory.sysdate();
        functionFactory.systimestamp();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.everyAny_minMaxCase();
        functionFactory.radians_acos();
        functionFactory.degrees_acos();
        functionFactory.median();
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.characterLength_length("dbms_lob.getlength(?1)");
        functionFactory.octetLength_pattern("lengthb(?1)", "dbms_lob.getlength(?1)*2");
        functionFactory.bitLength_pattern("lengthb(?1)*8", "dbms_lob.getlength(?1)*16");
        functionFactory.coalesce();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER), "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, typeConfiguration).setArgumentListSignature("(pattern, string[, start])");
        functionFactory.windowFunctions();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionContributions.getFunctionRegistry().register("mode", (SqmFunctionDescriptor)new ModeStatsModeEmulation(typeConfiguration));
        functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new OracleTruncFunction(functionContributions.getTypeConfiguration()));
        functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
    }

    public String getSelectGUIDString() {
        return "select sys_guid_name()";
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new PostgreSQLSqlAstTranslator(sessionFactory, statement){

                    public void visitLikePredicate(LikePredicate likePredicate) {
                        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
                        if (likePredicate.isNegated()) {
                            this.appendSql(" not");
                        }
                        if (likePredicate.isCaseSensitive()) {
                            this.appendSql(" like ");
                        } else {
                            this.appendSql(' ');
                            this.appendSql(this.getDialect().getCaseInsensitiveLike());
                            this.appendSql(' ');
                        }
                        likePredicate.getPattern().accept((SqlAstWalker)this);
                        if (likePredicate.getEscapeCharacter() != null) {
                            this.appendSql(" escape ");
                            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
                        }
                    }
                };
            }
        };
    }
}

