/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.model.processor;

import ch.qos.logback.access.model.ConfigurationModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final String DEBUG_SYSTEM_PROPERTY_KEY = "logback-access.debug";

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, InterpretationContext ic) {
        return new ConfigurationModelHandler(context);
    }

    protected Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {
        ConfigurationModel configurationModel = (ConfigurationModel)model;
        String debug = System.getProperty(DEBUG_SYSTEM_PROPERTY_KEY);
        if (debug == null) {
            debug = configurationModel.getDebug();
        }
        if (OptionHelper.isNullOrEmpty((String)debug) || debug.equals("false") || debug.equals("null")) {
            this.addInfo("debug attribute not set");
        } else {
            StatusListenerConfigHelper.addOnConsoleListenerInstance((Context)this.context, (OnConsoleStatusListener)new OnConsoleStatusListener());
        }
    }
}

