/*
 * Decompiled with CFR 0.152.
 */
package ca.vanzyl.maven.plugins.provisio;

import ca.vanzyl.maven.plugins.provisio.BaseMojo;
import ca.vanzyl.provisio.MavenProvisioner;
import ca.vanzyl.provisio.model.ProvisioArtifact;
import ca.vanzyl.provisio.model.ProvisioningRequest;
import ca.vanzyl.provisio.model.Runtime;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="generateDependencies", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GeneratorMojo
extends BaseMojo {
    @Parameter(property="dependencyExtendedPomLocation", defaultValue="${project.build.directory}/generated/provisio/dependency-extended-pom.xml")
    private File dependencyExtendedPomLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenProvisioner provisioner = new MavenProvisioner(this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories());
        ArrayList<ProvisioArtifact> artifacts = new ArrayList<ProvisioArtifact>();
        for (Runtime runtime : this.provisio.findDescriptors(this.descriptorDirectory, this.project)) {
            runtime.addArtifactSetReference("runtime.classpath", this.getRuntimeClasspathAsArtifactSet());
            ProvisioningRequest request = this.getRequest(runtime);
            try {
                artifacts.addAll(provisioner.getArtifacts(request));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error resolving artifacts.", e);
            }
        }
        if (artifacts.isEmpty()) {
            return;
        }
        this.checkDuplicates(artifacts);
        Model model = this.project.getOriginalModel().clone();
        List<Dependency> dependencies = this.getDependencies(artifacts);
        this.mergeDependencies(model, dependencies);
        this.writeModel(model);
        this.project.setPomFile(this.dependencyExtendedPomLocation);
    }

    private void writeModel(Model model) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Dependency-extended POM written at: " + this.dependencyExtendedPomLocation.getAbsolutePath()));
        try {
            Files.createDirectories(this.dependencyExtendedPomLocation.toPath().getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating parent directories for the POM file: " + e.getMessage(), (Exception)e);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)this.dependencyExtendedPomLocation);){
                new MavenXpp3Writer().write((Writer)writer, model);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing POM file: " + e.getMessage(), (Exception)e);
        }
    }
}

