/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.paddlepaddle.engine.PpNDArray;
import ai.djl.paddlepaddle.jni.JniUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PpNDManager
extends BaseNDManager {
    private static final PpNDManager SYSTEM_MANAGER = new SystemManager();

    private PpNDManager(NDManager parent, Device device) {
        super(parent, device);
    }

    static PpNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public PpNDManager newSubManager() {
        return this.newSubManager(this.device);
    }

    public PpNDManager newSubManager(Device device) {
        PpNDManager manager = new PpNDManager((NDManager)this, device);
        this.attachInternal(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public Engine getEngine() {
        return Engine.getEngine((String)"PaddlePaddle");
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public PpNDArray from(NDArray array) {
        if (array == null || array instanceof PpNDArray) {
            return (PpNDArray)array;
        }
        PpNDArray result = this.create(array.toByteBuffer(), array.getShape(), array.getDataType());
        result.setName(array.getName());
        return result;
    }

    public PpNDArray createInternal(ByteBuffer data, long handle) {
        return new PpNDArray((NDManager)this, this.alternativeManager, data, handle);
    }

    public PpNDArray create(Buffer data, Shape shape, DataType dataType) {
        int size = Math.toIntExact(shape.size());
        BaseNDManager.validateBuffer((Buffer)data, (DataType)dataType, (int)size);
        if (data.isDirect() && data instanceof ByteBuffer) {
            return JniUtils.createNdArray(this, (ByteBuffer)data, shape, dataType);
        }
        ByteBuffer buf = this.allocateDirect(size * dataType.getNumOfBytes());
        PpNDManager.copyBuffer((Buffer)data, (ByteBuffer)buf);
        return JniUtils.createNdArray(this, buf, shape, dataType);
    }

    public void close() {
        super.close();
        if (this.alternativeManager != null) {
            this.alternativeManager.close();
            this.alternativeManager = null;
        }
    }

    private static final class SystemManager
    extends PpNDManager
    implements NDManager.SystemNDManager {
        SystemManager() {
            super(null, null);
        }

        @Override
        public void close() {
        }
    }
}

