/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.util;

public class NumberConverter {
    public static String toLowerRoman(int number) {
        String[] romanNumerals = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (number >= values[i]) {
                number -= values[i];
                roman.append(romanNumerals[i]);
            }
        }
        return roman.toString();
    }

    public static String toLowerChinese(int number) {
        String[] chineseNumerals = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
        String[] units = new String[]{"", "\u5341", "\u767e", "\u5343"};
        StringBuilder chinese = new StringBuilder();
        String numStr = String.valueOf(number);
        int length = numStr.length();
        for (int i = 0; i < length; ++i) {
            int digit = numStr.charAt(i) - 48;
            chinese.append(chineseNumerals[digit]);
            if (digit == 0) continue;
            chinese.append(units[length - i - 1]);
        }
        return chinese.toString().replaceAll("\u96f6[\u5341\u767e\u5343]", "\u96f6").replaceAll("\u96f6+", "\u96f6").replaceAll("\u96f6$", "");
    }

    public static String toLowerLetter(int number) {
        StringBuilder result = new StringBuilder();
        if (number > 0) {
            while (number > 0) {
                result.insert(0, (char)(97 + --number % 26));
                number /= 26;
            }
        }
        return result.toString();
    }

    public static String convertNumber(int number, String format) {
        switch (format) {
            case "lowerRoman": {
                return NumberConverter.toLowerRoman(number);
            }
            case "japaneseCounting": 
            case "chineseCounting": 
            case "decimalEnclosedCircleChinese": 
            case "chineseCountingThousand": {
                return NumberConverter.toLowerChinese(number);
            }
            case "lowerLetter": {
                return NumberConverter.toLowerLetter(number);
            }
            case "decimal": {
                return String.valueOf(number);
            }
        }
        return format + "-" + number;
    }

    public static void main(String[] args) {
        int number = 12;
        System.out.println("\u5c0f\u5199\u7f57\u9a6c\u6570\u5b57: " + NumberConverter.convertNumber(number, "roman"));
        System.out.println("\u5c0f\u5199\u6c49\u5b57: " + NumberConverter.convertNumber(number, "chinese"));
        System.out.println("\u5c0f\u5199\u5b57\u6bcd: " + NumberConverter.convertNumber(11, "letter"));
        System.out.println("\u5c0f\u5199\u5b57\u6bcd: " + NumberConverter.convertNumber(13, "letter"));
    }
}

