/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.strategy.dao.IQADocSplittingStrategyMapper;
import com.jxdinfo.hussar.strategy.docParsing.ParsingModel;
import com.jxdinfo.hussar.strategy.dto.SplittingStrategyDto;
import com.jxdinfo.hussar.strategy.dto.SplittingStrategyQueryDto;
import com.jxdinfo.hussar.strategy.model.QADocSplittingStrategy;
import com.jxdinfo.hussar.strategy.model.QAStrategyRegular;
import com.jxdinfo.hussar.strategy.service.IQADocSplittingStrategyService;
import com.jxdinfo.hussar.strategy.service.IQAStrategyRegularService;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import com.jxdinfo.hussar.strategy.vo.SplittingStrategyListVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QADocSplittingStrategyServiceImpl
extends ServiceImpl<IQADocSplittingStrategyMapper, QADocSplittingStrategy>
implements IQADocSplittingStrategyService {
    @Autowired
    private IQADocSplittingStrategyMapper splittingStrategyMapper;
    @Autowired
    private IQAStrategyRegularService strategyRegularService;
    @Resource
    private Map<String, ParsingModel> parsingStrategyMap;

    @Override
    public Page<SplittingStrategyListVo> list(Page<SplittingStrategyListVo> page, SplittingStrategyQueryDto strategyQueryDto) {
        return this.splittingStrategyMapper.list(page, strategyQueryDto);
    }

    @Override
    public SplittingStrategyDto selectById(String strategyId) {
        QADocSplittingStrategy splittingStrategy = (QADocSplittingStrategy)((Object)this.splittingStrategyMapper.selectById(Long.valueOf(strategyId)));
        SplittingStrategyDto strategyDto = new SplittingStrategyDto();
        strategyDto.setStrategyId(strategyId);
        if (splittingStrategy.getMinTitleSplit() != null) {
            strategyDto.setMinTitleSplit(String.valueOf(splittingStrategy.getMinTitleSplit()));
        } else {
            strategyDto.setMinTitleSplit("");
        }
        strategyDto.setPreprocesses(SplittingStrategyUtil.getList(splittingStrategy.getPreprocess()));
        strategyDto.setStrategyName(splittingStrategy.getStrategyName());
        strategyDto.setPreRegulars(SplittingStrategyUtil.getList(splittingStrategy.getPreRegular()));
        strategyDto.setSplitIdentification(SplittingStrategyUtil.getList(splittingStrategy.getSplitIdentification()));
        strategyDto.setType(splittingStrategy.getType());
        strategyDto.setTitleAnalysisRegulars(SplittingStrategyUtil.getListRegular(splittingStrategy.getTitleAnalysisRegular()));
        strategyDto.setParagraphLength(String.valueOf(splittingStrategy.getParagraphLength()));
        strategyDto.setTitleAnalysis(SplittingStrategyUtil.getList(splittingStrategy.getTitleAnalysis()));
        return strategyDto;
    }

    @Override
    public QADocSplittingStrategy selectModelById(Long strategyId) {
        return (QADocSplittingStrategy)((Object)this.splittingStrategyMapper.selectById(strategyId));
    }

    @Override
    @HussarTransactional
    public String saveOrUpdate(SplittingStrategyDto strategyDto) {
        QADocSplittingStrategy splittingStrategy = new QADocSplittingStrategy();
        QAStrategyRegular strategyRegular1 = new QAStrategyRegular();
        QAStrategyRegular strategyRegular2 = new QAStrategyRegular();
        String strategyId = strategyDto.getStrategyId();
        if (strategyId != null && !Objects.equals(strategyId, "")) {
            splittingStrategy.setStrategyId(Long.valueOf(strategyId));
        }
        if (strategyDto.getMinTitleSplit() != null && !Objects.equals(strategyDto.getMinTitleSplit(), "")) {
            splittingStrategy.setMinTitleSplit(Integer.valueOf(strategyDto.getMinTitleSplit()));
        }
        splittingStrategy.setSplitIdentification(SplittingStrategyUtil.getStr(strategyDto.getSplitIdentification()));
        splittingStrategy.setStrategyName(strategyDto.getStrategyName());
        String preprocess = SplittingStrategyUtil.getStr(strategyDto.getPreprocesses());
        splittingStrategy.setPreprocess(preprocess);
        splittingStrategy.setType(strategyDto.getType());
        if (strategyDto.getParagraphLength() != null && !Objects.equals(strategyDto.getParagraphLength(), "")) {
            splittingStrategy.setParagraphLength(Integer.valueOf(strategyDto.getParagraphLength()));
        }
        splittingStrategy.setPreRegular(SplittingStrategyUtil.getStr(strategyDto.getPreRegulars()));
        splittingStrategy.setTitleAnalysis(SplittingStrategyUtil.getStr(strategyDto.getTitleAnalysis()));
        String titleAnalysisRegular = SplittingStrategyUtil.getStr(strategyDto.getTitleAnalysisRegulars());
        splittingStrategy.setTitleAnalysisRegular(titleAnalysisRegular);
        this.saveOrUpdate((Object)splittingStrategy);
        strategyRegular1.setStrategyId(splittingStrategy.getStrategyId());
        strategyRegular2.setStrategyId(splittingStrategy.getStrategyId());
        if (preprocess != null) {
            strategyRegular1.setContent(preprocess);
            strategyRegular1.setType("0");
            this.strategyRegularService.saveOrUpdateByStrategyId(strategyRegular1);
        }
        if (titleAnalysisRegular != null) {
            strategyRegular2.setContent(titleAnalysisRegular);
            strategyRegular2.setType("1");
            this.strategyRegularService.saveOrUpdateByStrategyId(strategyRegular2);
        }
        return String.valueOf(splittingStrategy.getStrategyId());
    }

    @Override
    @HussarTransactional
    public void del(List<String> ids) {
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (int i = 0; i < ids.size(); ++i) {
            String s = ids.get(i);
            idsList.add(Long.valueOf(s));
        }
        this.splittingStrategyMapper.deleteBatchIds(idsList);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(HussarUtils.isNotEmpty(idsList), QAStrategyRegular::getStrategyId, idsList);
        this.strategyRegularService.remove((Wrapper)wrapper);
    }

    @Override
    public List<Map<String, String>> selectAll() {
        return this.splittingStrategyMapper.selectAll();
    }

    @Override
    public HashMap<String, HashMap<String, LinkedHashMap<String, String>>> docSplitting(List<File> files, Long splittingStrategyId) {
        HashMap<String, HashMap<String, LinkedHashMap<String, String>>> result = new HashMap<String, HashMap<String, LinkedHashMap<String, String>>>();
        QADocSplittingStrategy splittingStrategy = (QADocSplittingStrategy)((Object)this.splittingStrategyMapper.selectById(splittingStrategyId));
        HussarException.throwByNull((Object)((Object)splittingStrategy), (String)"\u5207\u5206\u7b56\u7565\u4e0d\u5b58\u5728");
        String type = splittingStrategy.getType();
        if (HussarUtils.isNotEmpty(files)) {
            ParsingModel parsingDocx = "3".equals(type) || "4".equals(type) ? this.parsingStrategyMap.get("localParsing") : this.parsingStrategyMap.get("remoteParsing");
            result = parsingDocx.fileToMap(files, splittingStrategy);
        }
        return result;
    }
}

