/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.UnicodeUtil;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.dto.TitleRegular;
import com.jxdinfo.hussar.strategy.dto.TitleRegularList;
import com.jxdinfo.hussar.strategy.util.CommonUtil;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import com.jxdinfo.hussar.strategy.util.TableConvertUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForPdf")
public class LocalParsingForPdf
implements ParsingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LocalParsingForPdf.class);

    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String ocrUrl = (String)params.get("ocrUrl");
        ArrayList<String> texts = new ArrayList<String>();
        HashMap<String, LinkedHashMap<String, String>> map = new HashMap<String, LinkedHashMap<String, String>>();
        String fileName = file.getName();
        String titleAnalysisRegular = (String)params.get("TitleAnalysisRegular");
        Integer minTitleSplit = (Integer)params.get("MinTitleSplit");
        LinkedHashMap<Object, Object> patterMap = new LinkedHashMap();
        if (HussarUtils.isNotEmpty((Object)titleAnalysisRegular)) {
            TitleRegularList listRegular = SplittingStrategyUtil.getListRegular(titleAnalysisRegular);
            for (TitleRegular titleRegular : listRegular.getTitleRegulars()) {
                patterMap.put(titleRegular.getRegular(), titleRegular.getSeq());
            }
        } else {
            patterMap = CommonUtil.getDefaultPatternMap();
        }
        if (HussarUtils.isNotEmpty((Object)ocrUrl)) {
            JSONObject jsonObject;
            String result;
            try {
                result = IqaHttpClientUtil.httpAIFilePost((String)ocrUrl, (File)file, new HashMap(), new HashMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (HussarUtils.isNotEmpty((Object)result) && "200".equals((jsonObject = JSONObject.parseObject((String)(result = UnicodeUtil.toString((String)result)))).getString("code"))) {
                JSONArray jsonArray = jsonObject.getJSONArray("data");
                if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                    for (Object object : jsonArray) {
                        JSONObject dataJson = (JSONObject)object;
                        String text = dataJson.getString("text");
                        if (!HussarUtils.isNotEmpty((Object)text)) continue;
                        String[] split = text.split("\\n");
                        texts.addAll(Arrays.asList(split));
                    }
                }
                List<String> list = this.replaceTableLable(texts, fileName);
                int id = 0;
                TreeNode root = new TreeNode(new Element(id, fileName, "-1", 0));
                CommonUtil.assembleTree(root, 0, list, patterMap);
                String prefix = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e";
                LinkedHashMap<List<Element>, List<List<Element>>> contentsMap = new LinkedHashMap<List<Element>, List<List<Element>>>();
                root.printTree(root.getRoot(), "", true);
                root.findLeafNodePathsByType(root.getRoot(), new ArrayList<Element>(), Math.min(minTitleSplit, root.maxDepth(root)), new ArrayList<List<Element>>(), contentsMap);
                HashMap<String, LinkedHashMap<String, String>> resultMap = CommonUtil.treeToMap(fileName, Math.min(minTitleSplit, root.maxDepth(root)), contentsMap, prefix);
                JSONArray imgArray = jsonObject.getJSONArray("images");
                LinkedHashMap<String, String> picTreeMap = new LinkedHashMap<String, String>();
                if (HussarUtils.isNotEmpty((Object)imgArray)) {
                    for (Object object : imgArray) {
                        JSONObject imgJson = (JSONObject)object;
                        picTreeMap.put(imgJson.getString("img_name"), imgJson.getString("img_base64"));
                    }
                }
                resultMap.put("3", picTreeMap);
                return resultMap;
            }
        }
        return map;
    }

    private List<String> replaceTableLable(List<String> texts, String fileName) {
        ArrayList<String> contents = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(texts)) {
            for (String text : texts) {
                if (text.contains("<table>")) {
                    String convertContent = TableConvertUtil.convert(text, fileName);
                    contents.add(convertContent);
                    continue;
                }
                contents.add(text);
            }
        }
        return contents;
    }

    public static void main(String[] args) throws IOException {
        String ocrUrl = "http://192.168.2.24:8099/pdf_parse";
        File file = new File("D:\\chrome\u4e0b\u8f7d\u6587\u4ef6\u5939\\\u8868\u683c\u5e26\u56fe\u7247.pdf");
        LocalParsingForPdf parsing = new LocalParsingForPdf();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ocrUrl", ocrUrl);
        ArrayList<File> list = new ArrayList<File>();
        list.add(file);
        String result = IqaHttpClientUtil.httpFilesPost((String)ocrUrl, list, null, null);
        System.out.println(result);
    }
}

