/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docParsing.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.UnicodeUtil;
import com.jxdinfo.hussar.strategy.docHander.model.Element;
import com.jxdinfo.hussar.strategy.docHander.model.TreeNode;
import com.jxdinfo.hussar.strategy.docParsing.ParsingStrategy;
import com.jxdinfo.hussar.strategy.dto.TitleRegular;
import com.jxdinfo.hussar.strategy.dto.TitleRegularList;
import com.jxdinfo.hussar.strategy.util.CommonUtil;
import com.jxdinfo.hussar.strategy.util.SplittingStrategyUtil;
import com.jxdinfo.hussar.strategy.util.TableConvertUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.stereotype.Component;

@Component(value="LocalParsingForJpg")
public class LocalParsingForJpg
implements ParsingStrategy {
    @Override
    public HashMap<String, LinkedHashMap<String, String>> fileToMap(File file, HashMap<String, Object> params) {
        String ocrUrl = (String)params.get("ocrUrl");
        ArrayList<String> texts = new ArrayList<String>();
        HashMap<String, LinkedHashMap<String, String>> map = new HashMap<String, LinkedHashMap<String, String>>();
        String fileName = file.getName();
        String titleAnalysisRegular = (String)params.get("TitleAnalysisRegular");
        Integer minTitleSplit = (Integer)params.get("MinTitleSplit");
        if (HussarUtils.isEmpty((Object)minTitleSplit)) {
            minTitleSplit = Integer.MAX_VALUE;
        }
        LinkedHashMap<Object, Object> patterMap = new LinkedHashMap();
        if (HussarUtils.isNotEmpty((Object)titleAnalysisRegular)) {
            TitleRegularList listRegular = SplittingStrategyUtil.getListRegular(titleAnalysisRegular);
            for (TitleRegular titleRegular : listRegular.getTitleRegulars()) {
                patterMap.put(titleRegular.getRegular(), titleRegular.getSeq());
            }
        } else {
            patterMap = CommonUtil.getDefaultPatternMap();
        }
        if (HussarUtils.isNotEmpty((Object)ocrUrl)) {
            ArrayList<File> fileList = new ArrayList<File>();
            fileList.add(file);
            String result = IqaHttpClientUtil.httpFilesPost((String)ocrUrl, fileList, null, null);
            if (HussarUtils.isNotEmpty((Object)result)) {
                JSONObject jsonObject = JSONObject.parseObject((String)(result = UnicodeUtil.toString((String)result)));
                if ("200".equals(jsonObject.getString("code"))) {
                    JSONArray jsonArray = jsonObject.getJSONArray("data");
                    if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                        for (Object object : jsonArray) {
                            JSONObject dataJson = (JSONObject)object;
                            String text = dataJson.getString("text");
                            if (!HussarUtils.isNotEmpty((Object)text)) continue;
                            String[] split = text.split("\\n");
                            texts.addAll(Arrays.asList(split));
                        }
                    }
                    List<String> contents = this.replaceTableLable(texts, fileName);
                    int id = 0;
                    TreeNode root = new TreeNode(new Element(id, fileName, "-1", 0));
                    CommonUtil.assembleTree(root, 0, contents, patterMap);
                    String prefix = "\u4ee5\u4e0b\u662f " + fileName + " \u7684\u6587\u6863\u8bf4\u660e\u3002\u8be5\u90e8\u5206\u5185\u5bb9\u5173\u4e8e";
                    LinkedHashMap<List<Element>, List<List<Element>>> contentsMap = new LinkedHashMap<List<Element>, List<List<Element>>>();
                    root.printTree(root.getRoot(), "", true);
                    root.findLeafNodePathsByType(root.getRoot(), new ArrayList<Element>(), Math.min(minTitleSplit, root.maxDepth(root)), new ArrayList<List<Element>>(), contentsMap);
                    HashMap<String, LinkedHashMap<String, String>> resultMap = CommonUtil.treeToMap(fileName, Math.min(minTitleSplit, root.maxDepth(root)), contentsMap, prefix);
                    resultMap.put("3", new LinkedHashMap());
                    return resultMap;
                }
                System.out.println(result);
                throw new HussarException("\u56fe\u7247" + fileName + "\u89e3\u6790\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f" + jsonObject.getString("msg"));
            }
        } else {
            throw new HussarException("\u672a\u914d\u7f6eOCR\u670d\u52a1\u5730\u5740\uff0c\u8df3\u8fc7\u56fe\u7247\u89e3\u6790");
        }
        return map;
    }

    private List<String> replaceTableLable(List<String> texts, String fileName) {
        ArrayList<String> contents = new ArrayList<String>();
        if (HussarUtils.isNotEmpty(texts)) {
            for (String text : texts) {
                if (text.contains("<table>")) {
                    String convertContent = TableConvertUtil.convert(text, fileName);
                    contents.add(convertContent);
                    continue;
                }
                contents.add(text);
            }
        }
        return contents;
    }

    public static void main(String[] args) throws IOException {
        String ocrUrl = "http://192.168.2.23:8087/pdf_parse";
        File file = new File("C:\\Users\\81067\\Desktop\\bmp\u4e0a\u4f20\u6d4b\u8bd5.bmp");
        LocalParsingForJpg parsing = new LocalParsingForJpg();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ocrUrl", ocrUrl);
        parsing.fileToMap(file, params);
    }
}

