/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.strategy.docHander.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;

public class TableProcessor {
    public static List<List<String>> convertTableToData(XWPFTable table) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        int maxRows = table.getNumberOfRows();
        int maxCols = TableProcessor.getMaxColumns(table);
        for (int i = 0; i < maxRows; ++i) {
            data.add(new ArrayList<String>(Collections.nCopies(maxCols, "")));
        }
        for (int rowIndex = 0; rowIndex < maxRows; ++rowIndex) {
            XWPFTableRow row = table.getRow(rowIndex);
            if (row == null) continue;
            List strings = (List)data.get(rowIndex);
            for (int colIndex = 0; colIndex < row.getTableCells().size(); ++colIndex) {
                int i;
                if (!((String)strings.get(colIndex)).isEmpty()) continue;
                XWPFTableCell cell = row.getCell(colIndex);
                if (TableProcessor.getColspan(cell) != -1) {
                    for (i = 0; i < TableProcessor.getColspan(cell); ++i) {
                        ((List)data.get(rowIndex + i)).set(colIndex, TableProcessor.getCellValue(cell));
                    }
                }
                if (TableProcessor.getRowspan(cell) != -1) {
                    for (i = 0; i < TableProcessor.getRowspan(cell); ++i) {
                        ((List)data.get(rowIndex)).set(colIndex + i, TableProcessor.getCellValue(cell));
                    }
                }
                if (TableProcessor.getColspan(cell) != -1 || TableProcessor.getRowspan(cell) != -1) continue;
                ((List)data.get(rowIndex)).set(colIndex, TableProcessor.getCellValue(cell));
            }
        }
        return data;
    }

    private static int getMaxColumns(XWPFTable table) {
        int maxCols = 0;
        for (XWPFTableRow row : table.getRows()) {
            maxCols = Math.max(maxCols, row.getTableCells().size());
        }
        return maxCols;
    }

    private static String getCellValue(XWPFTableCell cell) {
        return cell.getText();
    }

    private static int getColspan(XWPFTableCell cell) {
        if (cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getVMerge() != null && cell.getCTTc().getTcPr().getVMerge().getVal() != null && cell.getCTTc().getTcPr().getVMerge().getVal().equals(STMerge.RESTART)) {
            return cell.getCTTc().getTcPr().getVMerge().getVal().intValue();
        }
        return -1;
    }

    private static int getRowspan(XWPFTableCell cell) {
        if (cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getHMerge() != null && cell.getCTTc().getTcPr().getHMerge().getVal() != null && cell.getCTTc().getTcPr().getHMerge().getVal().equals(STMerge.RESTART)) {
            return cell.getCTTc().getTcPr().getHMerge().getVal().intValue();
        }
        return -1;
    }
}

