/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaScenarioMapper;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataGroupDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.DataItemDTO;
import com.jxdinfo.hussar.scenarioai.scenario.dto.SimpleScenarioDTO;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IQaFaqService;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.scenarioai.scenario.vo.AppScenarioMappingVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScenarioServiceImpl
extends ServiceImpl<QaScenarioMapper, QaScenarioModel>
implements IScenarioService {
    @Autowired
    private IQaFaqService qaFaqService;
    @Autowired
    private QaScenarioMapper scenarioMapper;
    @Autowired
    private ISysDicRefService dicRefService;
    @Autowired
    private IDialogueService dialogueService;

    @Override
    public IPage<QaScenarioModel> list(Page<QaScenarioModel> page, String scenarioName, String dataSourceType) {
        HussarException.throwBy((boolean)StringUtil.isEmpty(page), (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long userId = BaseSecurityUtil.getUser().getId();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(StringUtil.isNotEmpty((Object)scenarioName), QaScenarioModel::getScenarioName, (Object)scenarioName)).eq(StringUtil.isNotEmpty((Object)dataSourceType), QaScenarioModel::getDataSourceType, (Object)dataSourceType)).eq(HussarBaseEntity::getCreator, (Object)userId)).and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(QaScenarioModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(QaScenarioModel::getDelFlag, (Object)"0");
            });
        })).orderByDesc(HussarBaseEntity::getCreateTime);
        IPage qaScenarioModelIPage = this.scenarioMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        for (QaScenarioModel qaScenarioModel : qaScenarioModelIPage.getRecords()) {
            qaScenarioModel.setFaqList(this.qaFaqService.getFaq(qaScenarioModel.getScenarioId()));
        }
        return qaScenarioModelIPage;
    }

    @Override
    @HussarTransactional
    public void deleteBatchByIds(List<Long> scenarioIds) {
        if (CollectionUtils.isEmpty(scenarioIds)) {
            return;
        }
        this.checkAppRelations(scenarioIds);
        for (Long scenarioId : scenarioIds) {
            this.dialogueService.deleteByScenarioId(scenarioId);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null) {
            updateWrapper.set(HussarBaseEntity::getLastEditor, (Object)user.getId());
            updateWrapper.set(QaScenarioModel::getLastEditorName, (Object)user.getUserName());
            updateWrapper.set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now());
        }
        updateWrapper.in(QaScenarioModel::getScenarioId, scenarioIds);
        updateWrapper.set(QaScenarioModel::getDelFlag, (Object)"1");
        this.scenarioMapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    @HussarTransactional
    public Long saveScenario(QaScenarioModel scenario) {
        HussarException.throwByNull((Object)((Object)scenario), (String)"\u4fdd\u5b58\u5931\u8d25");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (scenario.getScenarioId() == null || scenario.getScenarioId() == 0L) {
            scenario.setCreatorName(user.getUserName());
            scenario.setDelFlag("0");
        } else {
            this.getDetail(scenario.getScenarioId());
            scenario.setLastEditorName(user.getUserName());
        }
        this.validateUniqueName(scenario.getScenarioId(), scenario.getScenarioName());
        this.saveOrUpdate((Object)scenario);
        this.qaFaqService.saveFaq(scenario.getScenarioId(), scenario.getFaqList());
        return scenario.getScenarioId();
    }

    private void validateUniqueName(Long scenarioId, String scenarioName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.ne(scenarioId != null, QaScenarioModel::getScenarioId, (Object)scenarioId)).eq(QaScenarioModel::getScenarioName, (Object)scenarioName)).and(v -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)v.isNull(QaScenarioModel::getDelFlag)).or(v2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)v2.eq(QaScenarioModel::getDelFlag, (Object)"0");
            });
        });
        HussarException.throwBy((this.count((Wrapper)queryWrapper) > 0L ? 1 : 0) != 0, (String)"\u573a\u666f\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d,\u8bf7\u4fee\u6539");
    }

    @Override
    public QaScenarioModel getDetail(Long scenarioId) {
        QaScenarioModel scenario = this.getQaScenarioModelById(scenarioId);
        HussarException.throwByNull((Object)((Object)scenario), (String)"\u573a\u666f\u6570\u636e\u4e0d\u5b58\u5728");
        List<QaFaqModel> faq = this.qaFaqService.getFaq(scenarioId);
        List<Long> dataSourceIds = scenario.getDataSourceId();
        ArrayList<String> datasourceNames = new ArrayList<String>();
        if (dataSourceIds != null && !dataSourceIds.isEmpty()) {
            for (Long dataSourceId : dataSourceIds) {
                datasourceNames.add(this.scenarioMapper.getDatasourceName(dataSourceId, scenario.getDataSourceType()));
            }
            HussarException.throwBy((boolean)ArrayUtil.isEmpty(datasourceNames), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff01");
        }
        scenario.setDataSourceName(datasourceNames);
        scenario.setFaqList(faq);
        ArrayList<Map<String, String>> dataSourceList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < Math.min(dataSourceIds.size(), datasourceNames.size()); ++i) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("id", String.valueOf(dataSourceIds.get(i)));
            source.put("name", (String)datasourceNames.get(i));
            dataSourceList.add(source);
        }
        scenario.setDataSourceList(dataSourceList);
        return scenario;
    }

    @Override
    public List<DataGroupDTO> getDatasourceList() {
        DataGroupDTO dataGroupDTO;
        List<DataGroupDTO> datasourceList = this.scenarioMapper.getDatasourceList(BaseSecurityUtil.getUser().getId());
        List types = datasourceList.stream().map(DataGroupDTO::getDataType).collect(Collectors.toList());
        if (!types.contains("0")) {
            dataGroupDTO = new DataGroupDTO();
            dataGroupDTO.setDataList(Collections.emptyList());
            dataGroupDTO.setDataType("0");
            dataGroupDTO.setDataTypeName("\u6570\u636e\u5e93");
            datasourceList.add(dataGroupDTO);
        }
        if (!types.contains("1")) {
            dataGroupDTO = new DataGroupDTO();
            dataGroupDTO.setDataList(Collections.emptyList());
            dataGroupDTO.setDataType("1");
            dataGroupDTO.setDataTypeName("\u77e5\u8bc6\u5e93");
            datasourceList.add(dataGroupDTO);
        }
        if (!types.contains("2")) {
            dataGroupDTO = new DataGroupDTO();
            dataGroupDTO.setDataList(Collections.emptyList());
            dataGroupDTO.setDataType("2");
            dataGroupDTO.setDataTypeName("\u95ee\u9898\u5e93");
            datasourceList.add(dataGroupDTO);
        }
        datasourceList.sort(Comparator.comparing(DataGroupDTO::getDataType));
        return datasourceList;
    }

    private void checkAppRelations(List<Long> scenarioIds) {
        List<AppScenarioMappingVo> existsRelations;
        if (!CollectionUtils.isEmpty(scenarioIds) && !CollectionUtils.isEmpty(existsRelations = this.scenarioMapper.getExistsRelations(scenarioIds))) {
            String tips = existsRelations.stream().map(v -> v.getScenarioName() + "\u5df2\u7ecf\u5173\u8054\u5e94\u7528\uff1a" + v.getSystemName()).collect(Collectors.joining("\n"));
            throw new HussarException(tips + "\n\u4e0d\u5141\u8bb8\u5220\u9664");
        }
    }

    @Override
    public List<QaScenarioModel> getScenarioListBySystemId(Long systemId) {
        return this.scenarioMapper.getScenarioListBySystemId(systemId);
    }

    @Override
    public SimpleScenarioDTO getSimpleScenario(Long scenarioId) {
        QaScenarioModel scenario = this.getQaScenarioModelById(scenarioId);
        HussarException.throwByNull((Object)((Object)scenario), (String)"\u573a\u666f\u6570\u636e\u4e0d\u5b58\u5728");
        SimpleScenarioDTO simpleScenarioDTO = new SimpleScenarioDTO();
        simpleScenarioDTO.setScenarioId(scenario.getScenarioId());
        simpleScenarioDTO.setScenarioName(scenario.getScenarioName());
        simpleScenarioDTO.setDataSourceType(scenario.getDataSourceType());
        simpleScenarioDTO.setDescription(scenario.getDescription());
        simpleScenarioDTO.setModelUrl(scenario.getModelUrl());
        List<Long> dataSourceIds = scenario.getDataSourceId();
        simpleScenarioDTO.setDataSourceId(dataSourceIds);
        ArrayList<String> datasourceNames = new ArrayList<String>();
        if (dataSourceIds != null && !dataSourceIds.isEmpty()) {
            for (Long dataSourceId : dataSourceIds) {
                datasourceNames.add(this.scenarioMapper.getDatasourceName(dataSourceId, scenario.getDataSourceType()));
            }
            HussarException.throwBy((boolean)ArrayUtil.isEmpty(datasourceNames), (String)"\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff01");
        }
        simpleScenarioDTO.setDataSourceName(datasourceNames);
        ArrayList<Map<String, String>> dataSourceList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < Math.min(dataSourceIds.size(), datasourceNames.size()); ++i) {
            HashMap<String, String> source = new HashMap<String, String>();
            source.put("id", String.valueOf(dataSourceIds.get(i)));
            source.put("name", (String)datasourceNames.get(i));
            dataSourceList.add(source);
        }
        scenario.setDataSourceList(dataSourceList);
        simpleScenarioDTO.setIsReferenceSource(scenario.getIsReferenceSource());
        simpleScenarioDTO.setIsNetwork(scenario.getIsNetwork());
        simpleScenarioDTO.setOpening(scenario.getOpening());
        simpleScenarioDTO.setRobotName(scenario.getRobotName());
        simpleScenarioDTO.setIsTempUpload(scenario.getIsTempUpload());
        simpleScenarioDTO.setTempUploadMaxCount(scenario.getTempUploadMaxCount());
        simpleScenarioDTO.setIsMultiturn(scenario.getIsMultiturn());
        simpleScenarioDTO.setMultiturnRoundCount(scenario.getMultiturnRoundCount());
        simpleScenarioDTO.setMultiturnRewriteMode(scenario.getMultiturnRewriteMode());
        simpleScenarioDTO.setSearchEngine(scenario.getSearchEngine());
        return simpleScenarioDTO;
    }

    private QaScenarioModel getQaScenarioModelById(Long scenarioId) {
        HussarException.throwByNull((Object)scenarioId, (String)"\u573a\u666f\u53c2\u6570scenarioId\u4e0d\u80fd\u4e3a\u7a7a");
        return (QaScenarioModel)((Object)this.scenarioMapper.selectById(scenarioId));
    }

    @Override
    public List<DataItemDTO> getModelUrlMapping() {
        ArrayList<DataItemDTO> dataItemList = new ArrayList<DataItemDTO>();
        List largeModelInterface = this.dicRefService.getDictByType("large_model_interface");
        largeModelInterface.forEach(v -> {
            DataItemDTO e;
            if ("\u77e5\u8bc6\u5e93\u6587\u672c\u95ee\u7b54\u63a5\u53e3".equals(v.getLabel())) {
                e = new DataItemDTO();
                e.setDataId(1L);
                e.setDataName(v.getValue());
                dataItemList.add(e);
            }
            if ("\u95ee\u7b54\u5e93\u95ee\u7b54\u63a5\u53e3".equals(v.getLabel())) {
                e = new DataItemDTO();
                e.setDataId(2L);
                e.setDataName(v.getValue());
                dataItemList.add(e);
            }
            if ("\u6570\u636e\u5e93\u8868\u56de\u7b54\u63a5\u53e3".equals(v.getLabel())) {
                e = new DataItemDTO();
                e.setDataId(0L);
                e.setDataName(v.getValue());
                dataItemList.add(e);
            }
        });
        return dataItemList;
    }
}

