/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaFaqMapper;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IQaFaqService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QaFaqServiceImpl
extends ServiceImpl<QaFaqMapper, QaFaqModel>
implements IQaFaqService {
    @Autowired
    private QaFaqMapper faqMapper;

    @Override
    public void saveFaq(Long scenarioId, List<QaFaqModel> questions) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId);
        this.faqMapper.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(questions)) {
            return;
        }
        List faqList = questions.stream().filter(v -> !StringUtils.isEmpty((Object)v.getQuestion())).map(v -> {
            QaFaqModel qaFaqModel = new QaFaqModel();
            qaFaqModel.setQuestion(v.getQuestion());
            qaFaqModel.setScenarioId(scenarioId);
            return qaFaqModel;
        }).collect(Collectors.toList());
        this.saveBatch(faqList);
    }

    @Override
    public List<QaFaqModel> getFaq(Long scenarioId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId)).orderByAsc(QaFaqModel::getQuestionId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public IPage<QaFaqModel> getFaqList(Page<QaFaqModel> page, Long scenarioId) {
        HussarException.throwByNull((Object)scenarioId, (String)"\u573a\u666fId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId);
        queryWrapper.orderByAsc(QaFaqModel::getQuestionId);
        return this.faqMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }
}

