/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.qadoc.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.dialogue.dao.QaDocUploadParseMapper;
import com.jxdinfo.hussar.dialogue.model.QaDocUploadParse;
import com.jxdinfo.hussar.parse.service.FileParseService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.scenarioai.qadoc.service.QaDocService;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QaDocServiceImpl
implements QaDocService {
    @Resource
    private FileParseService fileParseService;
    @Resource
    private QaDocUploadParseMapper qaDocUploadParseMapper;

    @Override
    public ApiResponse<Map<String, Object>> qaUploadFile(List<MultipartFile> files, String docIds) {
        List docIdList;
        List zjContentList;
        HashMap map = new HashMap();
        HashMap<String, String> success = new HashMap<String, String>();
        HashMap<String, String> fail = new HashMap<String, String>();
        Date now = new Date();
        if (files == null || files.isEmpty()) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        Long userId = BaseSecurityUtil.getUser().getId();
        int amount = 28940;
        int count = 0;
        if (docIds != null && !docIds.isEmpty() && (zjContentList = this.qaDocUploadParseMapper.selectBatchIds(docIdList = Arrays.stream(docIds.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList()))) != null && !zjContentList.isEmpty()) {
            int num = 0;
            for (QaDocUploadParse qaDocUploadParse : zjContentList) {
                num += qaDocUploadParse.getContent().length();
            }
            count = num;
        }
        boolean flag = false;
        for (MultipartFile file : files) {
            QaDocUploadParse qaDocUploadParse;
            if (file.isEmpty()) continue;
            String fileName = file.getOriginalFilename();
            qaDocUploadParse = new QaDocUploadParse();
            Long id = IdUtil.getSnowflakeNextId();
            qaDocUploadParse.setId(id);
            qaDocUploadParse.setCreateTime(now);
            qaDocUploadParse.setCreateUserId(userId.toString());
            qaDocUploadParse.setFileSize(Long.valueOf(file.getSize()));
            if (fileName == null) continue;
            if (flag) {
                fail.put(fileName, "\u53ef\u4e0a\u4f20\u7684\u4e34\u65f6\u6587\u4ef6\u603b\u5b57\u6570\u5df2\u8fbe\u4e0a\u9650!");
                continue;
            }
            qaDocUploadParse.setFileName(fileName);
            try {
                String content = this.fileParseService.parseFile(file);
                if (content == null || content.isEmpty()) {
                    fail.put(fileName, "\u89e3\u6790\u51fa\u7684\u8be5\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a!");
                    continue;
                }
                if ((count += content.length()) <= amount) {
                    qaDocUploadParse.setContent(content);
                    qaDocUploadParse.setCount(Integer.valueOf(content.length()));
                    this.qaDocUploadParseMapper.insert((Object)qaDocUploadParse);
                    success.put(fileName, String.valueOf(id));
                    continue;
                }
                flag = true;
                fail.put(fileName, "\u53ef\u4e0a\u4f20\u7684\u4e34\u65f6\u6587\u4ef6\u603b\u5b57\u6570\u5df2\u8fbe\u4e0a\u9650!");
            }
            catch (Exception e) {
                fail.put(fileName, e.getMessage());
            }
        }
        map.put("success", success);
        map.put("fail", fail);
        return ApiResponse.success(map);
    }

    @Override
    public ApiResponse<Boolean> deleteQaUploadFile(String docIds) {
        List docIdList = Arrays.stream(docIds.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
        this.qaDocUploadParseMapper.deleteBatchIds(docIdList);
        return ApiResponse.success((Object)true);
    }
}

