/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.scenarioai.scenario.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.dialogue.dao.QaDocUploadParseMapper;
import com.jxdinfo.hussar.dialogue.dto.QaRecord;
import com.jxdinfo.hussar.dialogue.model.QaDocUploadParse;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.factory.NetworkProviderRegistry;
import com.jxdinfo.hussar.network.service.AiNetworkService;
import com.jxdinfo.hussar.question.service.RewriteQuestionService;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.DocReferenceChunk;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.KnowledgeBaseAskRequest;
import com.jxdinfo.hussar.scenarioai.scenario.dto.qa.RewriteQuestionChunk;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.scenarioai.scenario.service.QaService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.vector.service.DocRetrieveRecallService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service
public class QaServiceImpl
implements QaService {
    private static final Logger logger = LoggerFactory.getLogger(QaServiceImpl.class);
    @Resource
    private AiNetworkService aiNetworkService;
    @Resource
    private IScenarioService scenarioService;
    @Resource
    private QaDocUploadParseMapper qaDocUploadParseMapper;
    @Resource
    private AiDocumentLibrary docLibraryConfig;
    @Autowired
    private DocRetrieveRecallService docRetrieveRecallService;
    @Autowired
    private RewriteQuestionService rewriteQuestionService;
    @Autowired
    private NetworkProviderRegistry providerRegistry;
    private static final Gson gson = new Gson();

    @Override
    public Flux<QaResponseChunk> getAnswer(KnowledgeBaseAskRequest request) {
        Flux<QaResponseChunk> response;
        QaScenarioModel appConfig = (QaScenarioModel)((Object)this.scenarioService.getById(request.getAppId()));
        if (appConfig == null) {
            logger.error("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f: appId={}", (Object)request.getAppId());
            return this.getErrorResponse("\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u7684\u5e94\u7528\u4fe1\u606f: appId=" + request.getAppId());
        }
        String rewriteQuery = request.getQuery();
        if ('1' == appConfig.getIsMultiturn().charValue() && request.getQaRecords() != null && !request.getQaRecords().isEmpty()) {
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user == null ? 0L : user.getId();
            ArrayList<List<String>> history = new ArrayList<List<String>>();
            for (QaRecord qaRecord : request.getQaRecords()) {
                ArrayList<String> qa = new ArrayList<String>();
                qa.add(qaRecord.getQuestion());
                qa.add(qaRecord.getAnswer());
                history.add(qa);
            }
            rewriteQuery = this.rewriteQuery(appConfig.getDataSourceId(), userId, request.getQuery(), history);
        }
        if (request.isNetworkEnabled()) {
            response = this.getNetworkAnswer(rewriteQuery, request.getNetworkProviderCode(), appConfig.getApiKey(), appConfig.getSearchEngine());
        } else if (request.isTemFileEnabled()) {
            String docIds = request.getDocIds();
            if (docIds == null || docIds.isEmpty()) {
                throw new HussarException("\u4f20\u5165\u7684\u4e34\u65f6\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            }
            response = this.getTemFileAnswer(appConfig.getRobotName(), request.getQuery(), docIds, false);
        } else {
            response = this.getAnswerByKnowledgeBase(appConfig.getRobotName(), rewriteQuery, appConfig.getDataSourceId());
        }
        if (Objects.equals(rewriteQuery, request.getQuery())) {
            return response;
        }
        RewriteQuestionChunk rewriteQuestionChunk = new RewriteQuestionChunk();
        rewriteQuestionChunk.setRewrite_question(rewriteQuery);
        return response.startWith((Object[])new QaResponseChunk[]{rewriteQuestionChunk});
    }

    @Override
    public Flux<QaResponseChunk> getTestAnswer(KnowledgeBaseAskRequest request) {
        Flux<QaResponseChunk> response;
        String rewriteQuery = request.getQuery();
        if (request.isMultiturnEnabled() && request.getQaRecords() != null && !request.getQaRecords().isEmpty()) {
            List<QaRecord> qaList = request.getQaRecords();
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user == null ? 0L : user.getId();
            ArrayList<List<String>> history = new ArrayList<List<String>>();
            for (QaRecord qaRecord : qaList) {
                ArrayList<String> qa = new ArrayList<String>();
                qa.add(qaRecord.getQuestion());
                qa.add(qaRecord.getAnswer());
                history.add(qa);
            }
            rewriteQuery = this.rewriteQuery(request.getDataSourceId(), userId, request.getQuery(), history);
        }
        if (request.isNetworkEnabled()) {
            response = this.getNetworkAnswer(rewriteQuery, request.getNetworkProviderCode(), request.getApiKey(), request.getSearchEngine());
        } else if (request.isTemFileEnabled()) {
            String docIds = request.getDocIds();
            if (docIds == null || docIds.isEmpty()) {
                throw new HussarException("\u4f20\u5165\u7684\u4e34\u65f6\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            }
            response = this.getTemFileAnswer(request.getRobotName(), request.getQuery(), docIds, false);
        } else {
            response = this.getAnswerByKnowledgeBase(request.getRobotName(), rewriteQuery, request.getDataSourceId());
        }
        if (Objects.equals(rewriteQuery, request.getQuery())) {
            return response;
        }
        RewriteQuestionChunk rewriteQuestionChunk = new RewriteQuestionChunk();
        rewriteQuestionChunk.setRewrite_question(rewriteQuery);
        return response.startWith((Object[])new QaResponseChunk[]{rewriteQuestionChunk});
    }

    private String rewriteQuery(List<Long> dataSourceId, Long userId, String query, List<List<String>> history) {
        try {
            query = this.rewriteQuestionService.rewriteQuery(dataSourceId, userId, query, history);
        }
        catch (Exception e) {
            logger.error("\u591a\u8f6e\u95ee\u9898\u6539\u5199\u5931\u8d25", (Throwable)e);
        }
        return query;
    }

    private Flux<QaResponseChunk> getAnswerByKnowledgeBase(String robotName, String question, List<Long> dataSourceIds) {
        try {
            Map result = this.docRetrieveRecallService.docRetrieveRecall(question, dataSourceIds, "model");
            List texts = (List)result.get("texts");
            ArrayList answers = (ArrayList)result.get("answers");
            ArrayList<DocReferenceChunk.DocReferenceInfo> sourceList = new ArrayList<DocReferenceChunk.DocReferenceInfo>();
            block2: for (String answer : answers) {
                for (JSONObject text : texts) {
                    if (!text.getString("text").equals(answer)) continue;
                    DocReferenceChunk.DocReferenceInfo docReferenceInfo = new DocReferenceChunk.DocReferenceInfo();
                    docReferenceInfo.setKm(text.getLong("knowledge_name"));
                    docReferenceInfo.setDoc(text.getString("document_name"));
                    docReferenceInfo.setContent(text.getString("text"));
                    sourceList.add(docReferenceInfo);
                    continue block2;
                }
            }
            DocReferenceChunk docReferenceChunk = new DocReferenceChunk();
            docReferenceChunk.setDoc(sourceList);
            StringBuilder knowledge = new StringBuilder();
            for (int i = 0; i < answers.size(); ++i) {
                knowledge.append("\u53c2\u8003\u6587\u6863").append(i + 1).append("\uff1a").append((String)answers.get(i)).append("\n");
            }
            String content = "\u4f60\u662f\u667a\u80fd\u95ee\u7b54\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002\u5df2\u77e5\u4fe1\u606f\uff1a" + (knowledge.length() < 28500 ? knowledge : knowledge.substring(0, 28500)) + "\u8bf7\u6839\u636e\u4e0a\u8ff0\u5df2\u77e5\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + question;
            return this.requestModelGetFluxResponse(content).startWith((Object[])new QaResponseChunk[]{docReferenceChunk});
        }
        catch (Exception e) {
            logger.error("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6", (Throwable)e);
            return this.getErrorResponse("\u672a\u627e\u5230\u76f8\u5173\u77e5\u8bc6");
        }
    }

    private Flux<QaResponseChunk> requestModelGetFluxResponse(String content) {
        HashMap<String, Object> gParam = new HashMap<String, Object>();
        ArrayList messages = new ArrayList();
        HashMap<String, String> systemMessage = new HashMap<String, String>();
        systemMessage.put("role", "system");
        systemMessage.put("content", "You are a helpful assistant.");
        messages.add(systemMessage);
        HashMap<String, String> userMessage = new HashMap<String, String>();
        userMessage.put("role", "user");
        userMessage.put("content", content);
        messages.add(userMessage);
        gParam.put("model", this.docLibraryConfig.getModel());
        gParam.put("messages", messages);
        gParam.put("temperature", 0.2);
        gParam.put("stream", true);
        gParam.put("top_p", 0.2);
        WebClient webClient = WebClient.builder().baseUrl(this.docLibraryConfig.getQaUrl()).build();
        return ((WebClient.RequestBodySpec)webClient.post().contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue(gParam).retrieve().bodyToFlux(String.class).map(this::getQaResponseChunk);
    }

    private Flux<QaResponseChunk> getErrorResponse(String msg) {
        QaResponseChunk chunk = new QaResponseChunk(msg);
        QaResponseChunk end = new QaResponseChunk("", true);
        return Flux.just((Object[])new QaResponseChunk[]{chunk, end});
    }

    private Flux<QaResponseChunk> getNetworkAnswer(String query, int providerCode, String apiKey, String searchEngine) {
        try {
            NetworkRequest networkRequest = new NetworkRequest();
            networkRequest.setContent(query);
            networkRequest.setApiKey(apiKey);
            networkRequest.setSearchEngine(searchEngine);
            return this.aiNetworkService.sendRequest(providerCode, networkRequest);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u5916\u90e8ai-search\u670d\u52a1\u5f02\u5e38\uff0c\u4f9b\u5e94\u5546: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)this.providerRegistry.getProvider(providerCode).getName(), (Object)e.getMessage());
            return this.getErrorResponse("\u5f53\u524d\u7f51\u7edc\u641c\u7d22\u670d\u52a1\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private QaResponseChunk getQaResponseChunk(String content) {
        try {
            JsonObject delta;
            JsonArray choices;
            if ("[DONE]".equals(content)) {
                return new QaResponseChunk("", true);
            }
            JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
            QaResponseChunk qaResponseChunk = new QaResponseChunk();
            if (root.has("choices") && !(choices = root.getAsJsonArray("choices")).isEmpty() && (delta = choices.get(0).getAsJsonObject().getAsJsonObject("delta")) != null) {
                if (delta.has("content") && !delta.get("content").isJsonNull()) {
                    qaResponseChunk.setContent(delta.get("content").getAsString());
                }
                if (delta.has("reasoning_content") && !delta.get("reasoning_content").isJsonNull()) {
                    qaResponseChunk.setReasoning_content(delta.get("reasoning_content").getAsString());
                }
            }
            return qaResponseChunk;
        }
        catch (Exception e) {
            return new QaResponseChunk();
        }
    }

    private Flux<QaResponseChunk> getTemFileAnswer(String robotName, String query, String docIds, Boolean deleteFlag) {
        List docIdList = Arrays.stream(docIds.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::valueOf).collect(Collectors.toList());
        List parses = this.qaDocUploadParseMapper.selectBatchIds(docIdList);
        StringBuilder info = new StringBuilder();
        if (parses != null && !parses.isEmpty()) {
            for (QaDocUploadParse qaDocUploadParse : parses) {
                info.append("\n").append(qaDocUploadParse.getContent());
            }
        } else {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u6587\u6863\u89e3\u6790\u5185\u5bb9\uff01");
        }
        String content = "\u4f60\u662f\u667a\u80fd\u95ee\u7b54\u52a9\u624b\uff0c\u540d\u5b57\u53eb\u505a" + robotName + "\u3002\u5df2\u77e5\u4fe1\u606f\uff1a\u5df2\u77e5\u4fe1\u606f\uff1a" + info + " \u8bf7\u6839\u636e\u4e0a\u8ff0\u5df2\u77e5\u4fe1\u606f\u56de\u7b54\u95ee\u9898\u3002\u6211\u7684\u95ee\u9898\u662f\uff1a" + query;
        if (deleteFlag.booleanValue()) {
            this.qaDocUploadParseMapper.deleteBatchIds(docIdList);
        }
        return this.requestModelGetFluxResponse(content);
    }
}

