/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.parse.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class TextExtractUtils {
    public static String extractText(MultipartFile file) throws Exception {
        String fileType;
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e3a\u7a7a");
        }
        String fileName = file.getOriginalFilename();
        if (fileName == null || !fileName.contains(".")) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u65e0\u6548");
        }
        switch (fileType = fileName.substring(fileName.lastIndexOf(".")).toLowerCase()) {
            case ".txt": 
            case ".md": {
                return TextExtractUtils.readPlainText(file.getInputStream());
            }
            case ".doc": {
                return TextExtractUtils.extractDoc(file.getInputStream());
            }
            case ".docx": {
                return TextExtractUtils.extractDocx(file.getInputStream());
            }
            case ".xls": {
                return TextExtractUtils.extractXls(file.getInputStream());
            }
            case ".xlsx": {
                return TextExtractUtils.extractXlsx(file.getInputStream());
            }
            case ".csv": {
                return TextExtractUtils.readPlainText(file.getInputStream());
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b: " + fileType);
    }

    private static String readPlainText(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    private static String extractDoc(InputStream is) throws IOException {
        try (HWPFDocument doc = new HWPFDocument(is);){
            String string = doc.getDocumentText();
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private static String extractDocx(InputStream is) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String extractXls(InputStream is) throws Exception {
        StringBuilder text = new StringBuilder();
        try (HSSFWorkbook workbook = new HSSFWorkbook(is);){
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                HSSFSheet sheet = workbook.getSheetAt(i);
                for (Row row : sheet) {
                    for (Cell cell : row) {
                        text.append(cell.toString()).append("\t");
                    }
                    text.append("\n");
                }
            }
        }
        return text.toString();
    }

    private static String extractXlsx(InputStream is) throws Exception {
        StringBuilder text = new StringBuilder();
        try (XSSFWorkbook workbook = new XSSFWorkbook(is);){
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                XSSFSheet sheet = workbook.getSheetAt(i);
                for (Row row : sheet) {
                    for (Cell cell : row) {
                        text.append(cell.toString()).append("\t");
                    }
                    text.append("\n");
                }
            }
        }
        return text.toString();
    }
}

