/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.parse.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.config.AiDocumentLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.common.util.IqaSpringContextUtils;
import com.jxdinfo.hussar.parse.service.FileParseService;
import com.jxdinfo.hussar.parse.util.TextExtractUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.UnicodeUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileParseServiceImpl
implements FileParseService {
    @Resource
    private AiDocumentLibrary docLibraryConfig;

    @Override
    public String parseFile(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (fileName == null || fileName.isEmpty()) {
            throw new HussarException("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a!");
        }
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        String content = "";
        if (".doc".equals(fileType) || ".docx".equals(fileType) || ".txt".equals(fileType) || ".md".equals(fileType) || ".xls".equals(fileType) || ".xlsx".equals(fileType) || ".csv".equals(fileType)) {
            try {
                content = TextExtractUtils.extractText(file);
                if (content == null || content.isEmpty()) {
                    throw new HussarException("\u6587\u4ef6\u5185\u5bb9\u89e3\u6790\u5931\u8d25!");
                }
                content = content.replaceAll("<", "<&nbsp;");
            }
            catch (Exception e) {
                throw new HussarException(e.getMessage());
            }
        } else if (".pdf".equals(fileType) || ".jpg".equals(fileType) || ".png".equals(fileType) || ".jpeg".equals(fileType) || ".bmp".equals(fileType)) {
            String tempPath = this.getFilePath();
            File leftFile = this.convertToFile(file, tempPath + fileName);
            ArrayList<File> list = new ArrayList<File>();
            list.add(leftFile);
            String result = IqaHttpClientUtil.httpFilesPost((String)this.docLibraryConfig.getOcrUrl(), list, null, null);
            if (HussarUtils.isNotEmpty((Object)result)) {
                JSONObject jsonObject = JSONObject.parseObject((String)(result = UnicodeUtil.toString((String)result)));
                if ("200".equals(jsonObject.getString("code"))) {
                    JSONArray jsonArray = jsonObject.getJSONArray("data");
                    if (HussarUtils.isNotEmpty((Object)jsonArray)) {
                        for (Object object : jsonArray) {
                            JSONObject dataJson = (JSONObject)object;
                            String text = dataJson.getString("text");
                            content = content + text;
                        }
                    }
                } else {
                    throw new HussarException("ocr\u670d\u52a1\uff1a" + this.docLibraryConfig.getOcrUrl() + "\u5931\u8d25!");
                }
            }
            if (leftFile.exists()) {
                leftFile.delete();
            }
        } else {
            throw new HussarException("\u4e0d\u652f\u6301" + fileType + "\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        return content;
    }

    private String getFilePath() {
        boolean created;
        String path = this.getSourceFilePath();
        File dir = new File(path);
        if (!dir.exists() && !(created = dir.mkdirs())) {
            throw new HussarException("\u6587\u4ef6\u89e3\u6790\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25");
        }
        return path;
    }

    private String getSourceFilePath() {
        ApplicationContext appCtx = IqaSpringContextUtils.getApplicationContext();
        Environment environment = (Environment)appCtx.getBean(Environment.class);
        return environment.getProperty("docbase.sourceFilePath");
    }

    private File convertToFile(MultipartFile multipartFile, String targetFilePath) {
        File outputFile = new File(targetFilePath);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.write(multipartFile.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputFile;
    }
}

