/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.factory;

import com.jxdinfo.hussar.network.factory.NetworkProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class NetworkProviderRegistry {
    private final Map<Integer, NetworkProvider> providerMap = new ConcurrentHashMap<Integer, NetworkProvider>();

    public NetworkProviderRegistry(List<NetworkProvider> providers) {
        providers.forEach(p -> this.providerMap.put(p.getCode(), (NetworkProvider)p));
    }

    public NetworkProvider getProvider(int code) {
        NetworkProvider provider = this.providerMap.get(code);
        if (provider == null) {
            throw new IllegalArgumentException("\u672a\u77e5\u7684\u4f9b\u5e94\u5546\u7f16\u7801: " + code);
        }
        return provider;
    }

    public Collection<NetworkProvider> getAllProviders() {
        return this.providerMap.values();
    }
}

