/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.network.service.impl;

import com.jxdinfo.hussar.common.model.QaResponseChunk;
import com.jxdinfo.hussar.network.dto.NetworkRequest;
import com.jxdinfo.hussar.network.factory.NetworkProvider;
import com.jxdinfo.hussar.network.factory.NetworkProviderFactory;
import com.jxdinfo.hussar.network.factory.NetworkProviderRegistry;
import com.jxdinfo.hussar.network.factory.NetworkProviderService;
import com.jxdinfo.hussar.network.service.AiNetworkService;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

@Service
public class AiNetworkServiceImpl
implements AiNetworkService {
    private final NetworkProviderRegistry providerRegistry;
    private final NetworkProviderFactory networkProviderFactory;

    public AiNetworkServiceImpl(NetworkProviderRegistry providerRegistry, NetworkProviderFactory networkProviderFactory) {
        this.providerRegistry = providerRegistry;
        this.networkProviderFactory = networkProviderFactory;
    }

    @Override
    public Flux<QaResponseChunk> sendRequest(int providerCode, NetworkRequest request) {
        NetworkProvider provider = this.providerRegistry.getProvider(providerCode);
        NetworkProviderService networkProviderService = this.networkProviderFactory.getService(provider);
        if (networkProviderService == null) {
            throw new IllegalStateException("\u672a\u627e\u5230 provider \u4e3a " + provider.getName() + " \u7684\u670d\u52a1\u5b9e\u73b0");
        }
        return networkProviderService.sendRequest(request);
    }
}

