/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.model.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.model.constant.ModelTypeEnum;
import com.jxdinfo.hussar.model.dao.ModelServiceMapper;
import com.jxdinfo.hussar.model.model.QaModel;
import com.jxdinfo.hussar.model.model.QaPublicModel;
import com.jxdinfo.hussar.model.service.PublicModelService;
import com.jxdinfo.hussar.model.service.QaModelService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class QaModelServiceImpl
extends ServiceImpl<ModelServiceMapper, QaModel>
implements QaModelService {
    @Resource
    private PublicModelService publicModelService;
    @Resource
    private ModelServiceMapper modelServiceMapper;
    private static final Logger logger = LoggerFactory.getLogger(QaModelServiceImpl.class);

    @Override
    public Boolean saveModel(QaModel model) {
        HussarException.throwByNull((Object)((Object)model), (String)"\u5165\u53c2\u4e3a\u7a7a");
        Long modelId = model.getModelId();
        if (HussarUtils.isEmpty((Object)modelId)) {
            HussarException.throwByNull((Object)model.getModelType(), (String)"\u672a\u4f20\u5165\u6a21\u578b\u7c7b\u578b");
            HussarException.throwByNull((Object)model.getModelName(), (String)"\u672a\u4f20\u5165\u6a21\u578b\u540d\u79f0");
            HussarException.throwByNull((Object)model.getModelKey(), (String)"\u672a\u4f20\u5165\u6a21\u578b\u6807\u8bc6");
            HussarException.throwByNull((Object)model.getModelThinkType(), (String)"\u672a\u4f20\u5165\u601d\u8003\u6a21\u5f0f");
            HussarException.throwByNull((Object)model.getMaxInputToken(), (String)"\u672a\u4f20\u5165\u6700\u5927\u8f93\u5165token");
            HussarException.throwByNull((Object)model.getModelApiUrl(), (String)"\u672a\u4f20\u5165api\u5730\u5740");
            modelId = IdUtil.getSnowflakeNextId();
            if (!model.getModelType().equals(ModelTypeEnum.CUSTOMIZE.getTypeCode())) {
                QaPublicModel publicModel = this.publicModelService.qryPublicModelBykey(model.getModelKey());
                HussarException.throwByNull((Object)((Object)publicModel), (String)"\u672a\u67e5\u8be2\u5230\u516c\u6709\u6a21\u578b\u4fe1\u606f");
                model.setModelName(publicModel.getPublicModelName());
                model.setModelKey(publicModel.getPublicModelKey());
                model.setModelThinkType(publicModel.getPublicModelThink());
                model.setModelApiUrl(model.getModelApiUrl());
            }
            if (HussarUtils.isNotEmpty((Object)model.getApiKey())) {
                // empty if block
            }
            model.setModelId(modelId);
            return this.save((Object)model);
        }
        return this.updateById((Object)model);
    }

    @Override
    public Boolean delete(Long modelId) {
        HussarException.throwByNull((Object)modelId, (String)"\u672a\u4f20\u5165\u6a21\u578bid");
        int count = this.modelServiceMapper.countScenariosByModelId(modelId);
        if (count > 0) {
            throw new HussarException("\u8be5\u6a21\u578b\u5df2\u88ab\u5e94\u7528\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return this.removeById(modelId);
    }

    @Override
    public Map<String, Object> qryModels() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        qw.orderByDesc(HussarBaseEntity::getCreateTime);
        List list = this.list((Wrapper)qw);
        ArrayList<QaModel> customList = new ArrayList<QaModel>();
        ArrayList<QaModel> deepSeekList = new ArrayList<QaModel>();
        ArrayList<QaModel> qwenList = new ArrayList<QaModel>();
        try {
            for (QaModel qaModel : list) {
                String modelType = qaModel.getModelType();
                String apiKey = qaModel.getApiKey();
                if (HussarUtils.isNotEmpty((Object)apiKey)) {
                    // empty if block
                }
                if (ModelTypeEnum.CUSTOMIZE.getTypeCode().equals(modelType)) {
                    customList.add(qaModel);
                }
                if (ModelTypeEnum.DEEPSEEK.getTypeCode().equals(modelType)) {
                    deepSeekList.add(qaModel);
                }
                if (!ModelTypeEnum.QWEN.getTypeCode().equals(modelType)) continue;
                qwenList.add(qaModel);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        resultMap.put("customize", customList);
        resultMap.put("deepseek", deepSeekList);
        resultMap.put("qwen", qwenList);
        return resultMap;
    }

    @Override
    public Map<String, Object> checkModelName(@RequestParam(required=false) Long modelId, String modelName) {
        HashMap<String, Object> resultMap;
        Boolean exist;
        block2: {
            List list;
            block1: {
                exist = false;
                HussarException.throwByNull((Object)modelName, (String)"\u672a\u4f20\u5165\u6a21\u578b\u540d\u79f0");
                resultMap = new HashMap<String, Object>();
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                qw.eq(QaModel::getModelName, (Object)modelName);
                qw.eq(HussarDelflagEntity::getDelFlag, (Object)"0");
                list = this.list((Wrapper)qw);
                if (!HussarUtils.isEmpty((Object)modelId)) break block1;
                if (!HussarUtils.isNotEmpty((Object)list)) break block2;
                exist = true;
                break block2;
            }
            for (QaModel qaModel : list) {
                String name = qaModel.getModelName();
                if (!HussarUtils.equals((Object)modelName, (Object)name) || HussarUtils.equals((Object)modelId, (Object)qaModel.getModelId())) continue;
                exist = true;
                break;
            }
        }
        resultMap.put("exist", exist);
        return resultMap;
    }

    @Override
    public Boolean testConnection(QaModel model) {
        Boolean flag = true;
        HussarException.throwByNull((Object)((Object)model), (String)"\u672a\u4f20\u5165\u53c2\u6570");
        HussarException.throwByNull((Object)model.getModelKey(), (String)"\u672a\u4f20\u5165\u6a21\u578b\u6807\u8bc6");
        HussarException.throwByNull((Object)model.getModelApiUrl(), (String)"\u672a\u4f20\u5165api\u5730\u5740");
        HussarException.throwByNull((Object)model.getModelType(), (String)"\u672a\u4f20\u5165\u6a21\u578b\u7c7b\u578b");
        try {
            HashMap header = new HashMap();
            if (ModelTypeEnum.CUSTOMIZE.getTypeCode().equals(model.getModelType())) {
                String extendParam = model.getExtendParam();
                if (HussarUtils.isNotEmpty((Object)extendParam) && HussarUtils.isNotEmpty((Object)JSONObject.parseObject((String)extendParam))) {
                    JSONObject jsonObject = JSONObject.parseObject((String)extendParam);
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        header.put(entry.getKey(), entry.getValue().toString());
                    }
                }
            } else {
                HussarException.throwByNull((Object)model.getApiKey(), (String)"\u672a\u4f20\u5165apikey");
                header.put("Authorization", model.getApiKey());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("model", model.getModelKey());
            ArrayList messages = new ArrayList();
            HashMap<String, String> message = new HashMap<String, String>();
            message.put("role", "user");
            message.put("content", "\u4f60\u662f\u8c01");
            messages.add(message);
            params.put("messages", messages);
            params.put("enable_thinking", false);
            String result = IqaHttpClientUtil.httpPost((String)model.getModelApiUrl(), (String)JSON.toJSONString(params), header);
            if (HussarUtils.isEmpty((Object)result) || HussarUtils.isEmpty((Object)JSONObject.parseObject((String)result))) {
                return false;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (HussarUtils.isNotEmpty((Object)jsonObject.getJSONObject("error"))) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            flag = false;
        }
        return flag;
    }
}

