/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.common.config.AiGraphRagLibrary;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.doclibrary.dao.FileBaseMapper;
import com.jxdinfo.hussar.doclibrary.model.QAFileBase;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class VectorizationQueryService
implements InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(VectorizationQueryService.class);
    private final Map<String, VectorizationTask> pendingTasks = new ConcurrentHashMap<String, VectorizationTask>();
    @Resource
    private AiGraphRagLibrary docConfig;
    @Resource
    private FileBaseMapper fileBaseMapper;
    private ThreadPoolTaskScheduler dedicatedScheduler;
    private ScheduledFuture<?> scheduledFuture;
    private final Object scheduleLock = new Object();
    private boolean isScheduleRunning = false;

    public void addTask(String checkId, Long docId, Long docBaseId) {
        VectorizationTask task = new VectorizationTask();
        task.setCheckId(checkId);
        task.setDocId(docId);
        task.setDocBaseId(docBaseId);
        task.setCreatedTime(LocalDateTime.now());
        task.setRetryCount(0);
        if (checkId != null && !checkId.isEmpty()) {
            this.pendingTasks.put(checkId, task);
            this.logger.info("\u6dfb\u52a0\u65b0\u7684\u5411\u91cf\u5316\u67e5\u8be2\u4efb\u52a1: checkId={}, docBaseId={}", (Object)checkId, (Object)docBaseId);
            this.ensureSchedulerRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchedulerRunning() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (!this.isScheduleRunning) {
                this.scheduledFuture = this.dedicatedScheduler.scheduleWithFixedDelay(this::batchQueryVectorizationStatus, new Date(), 20000L);
                this.isScheduleRunning = true;
                this.logger.info("\u542f\u52a8\u5411\u91cf\u5316\u67e5\u8be2\u8c03\u5ea6\u5668");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSchedulerIfNoTasks() {
        Object object = this.scheduleLock;
        synchronized (object) {
            if (this.isScheduleRunning && this.pendingTasks.isEmpty()) {
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(false);
                    this.scheduledFuture = null;
                }
                this.isScheduleRunning = false;
                this.logger.info("\u505c\u6b62\u5411\u91cf\u5316\u67e5\u8be2\u8c03\u5ea6\u5668 - \u65e0\u4efb\u52a1\u5f85\u5904\u7406");
            }
        }
    }

    public void batchQueryVectorizationStatus() {
        if (this.pendingTasks.isEmpty()) {
            this.stopSchedulerIfNoTasks();
            return;
        }
        this.logger.info("\u5f00\u59cb\u6279\u91cf\u67e5\u8be2\u5411\u91cf\u5316\u72b6\u6001\uff0c\u5171\u6709{}\u4e2a\u4efb\u52a1\u5f85\u5904\u7406", (Object)this.pendingTasks.size());
        Iterator<Map.Entry<String, VectorizationTask>> iterator = this.pendingTasks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VectorizationTask> entry = iterator.next();
            VectorizationTask task = entry.getValue();
            boolean shouldRemove = this.processTask(task);
            if (!shouldRemove) continue;
            iterator.remove();
        }
        if (this.pendingTasks.isEmpty()) {
            this.stopSchedulerIfNoTasks();
        }
    }

    private boolean processTask(VectorizationTask task) {
        if (task.getRetryCount() >= 1000) {
            this.updateFailedFileInfo(task.getDocId(), task.getDocBaseId(), "\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + task.getDocId());
            this.logger.error("\u6587\u6863\u5904\u7406\u67e5\u8be2\u8d85\u65f6: checkId={}, docBaseId={}, \u8fbe\u5230\u6700\u5927\u91cd\u8bd5\u6b21\u65701000", (Object)task.getCheckId(), (Object)task.getDocBaseId());
            return true;
        }
        try {
            String queryUrl = this.docConfig.getCheckStatusUrl();
            JSONObject param = new JSONObject();
            param.put("check_id", (Object)task.getCheckId());
            param.put("knowledge_base_id", (Object)String.valueOf(task.getDocBaseId()));
            String paramStr = param.toJSONString();
            HashMap headers = new HashMap();
            String result = IqaHttpClientUtil.httpPost((String)queryUrl, (String)paramStr, headers);
            if (HussarUtils.isNotEmpty((Object)result)) {
                String code;
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject == null) {
                    this.logger.error("\u67e5\u8be2\u6587\u6863\u5904\u7406\u72b6\u6001\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a: checkId={}, docBaseId={}", (Object)task.getCheckId(), (Object)task.getDocBaseId());
                    code = "10001";
                } else {
                    code = jsonObject.getString("code");
                    if ("200".equals(code)) {
                        JSONObject dataObject = jsonObject.getJSONObject("data");
                        boolean status = dataObject.getBoolean("status");
                        code = status ? "200" : "5000";
                    }
                }
                if (HussarUtils.isEmpty((Object)code)) {
                    code = "10001";
                }
                switch (code) {
                    case "5000": {
                        task.setRetryCount(task.getRetryCount() + 1);
                        this.logger.info("\u6587\u6863\u6b63\u5728\u5904\u7406\u4e2d: checkId={}, docBaseId={}, \u7b2c{}\u6b21\u67e5\u8be2", new Object[]{task.getCheckId(), task.getDocBaseId(), task.getRetryCount()});
                        return false;
                    }
                    case "200": {
                        this.updateSuccessVector(task.getDocId(), task.getDocBaseId());
                        this.logger.info("\u6587\u6863\u5904\u7406\u5b8c\u6210: checkId={}, docBaseId={}", (Object)task.getCheckId(), (Object)task.getDocBaseId());
                        return true;
                    }
                }
                this.updateFailedFileInfo(task.getDocId(), task.getDocBaseId(), "\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + task.getDocId());
                this.logger.error("\u6587\u6863\u5904\u7406\u5931\u8d25: checkId={}, docBaseId={}, \u6a21\u578b\u8fd4\u56de\u7ed3\u679c={}", new Object[]{task.getCheckId(), task.getDocBaseId(), jsonObject == null ? "\u7a7a" : jsonObject.toJSONString()});
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6587\u6863\u5904\u7406\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38: checkId={}, docBaseId={}, \u5f02\u5e38\u4fe1\u606f={}", new Object[]{task.getCheckId(), task.getDocBaseId(), e.getMessage()});
            this.updateFailedFileInfo(task.getDocId(), task.getDocBaseId(), "\u5411\u91cf\u5316\u5931\u8d25\uff0c\u6587\u672cid\uff1a" + task.getDocId());
            return true;
        }
        return false;
    }

    private void updateSuccessVector(Long docId, Long docBaseId) {
        QAFileBase successFileBase = new QAFileBase();
        successFileBase.setState("2");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        wrapper.eq(QAFileBase::getDocId, (Object)docId);
        this.fileBaseMapper.update(successFileBase, (Wrapper)wrapper);
    }

    private void updateFailedFileInfo(Long docId, Long docBaseId, String defaultErrorMsg) {
        QAFileBase fileBaseError = new QAFileBase();
        fileBaseError.setState("4");
        fileBaseError.setReason("\u56fe\u8c31\u5904\u7406\u5931\u8d25\uff01" + (HussarUtils.isNotEmpty((Object)defaultErrorMsg) ? defaultErrorMsg : ""));
        LambdaUpdateWrapper updateWrapperError = new LambdaUpdateWrapper();
        updateWrapperError.eq(QAFileBase::getDocBaseId, (Object)docBaseId);
        updateWrapperError.eq(QAFileBase::getDocId, (Object)docId);
        this.fileBaseMapper.update(fileBaseError, (Wrapper)updateWrapperError);
    }

    public void destroy() {
        try {
            if (!this.pendingTasks.isEmpty()) {
                this.logger.info("\u670d\u52a1\u505c\u6b62\uff0c\u5c06{}\u4e2a\u672a\u5b8c\u6210\u4efb\u52a1\u6807\u8bb0\u4e3a\u5931\u8d25", (Object)this.pendingTasks.size());
                for (VectorizationTask task : this.pendingTasks.values()) {
                    this.updateFailedFileInfo(task.getDocId(), task.getDocBaseId(), "\u670d\u52a1\u505c\u6b62\uff0c\u4efb\u52a1\u81ea\u52a8\u7ec8\u6b62");
                }
                this.pendingTasks.clear();
            }
        }
        catch (Exception e) {
            this.logger.error("\u670d\u52a1\u505c\u6b62\u65f6\u5904\u7406\u672a\u5b8c\u6210\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (this.dedicatedScheduler != null) {
                this.dedicatedScheduler.shutdown();
            }
            this.logger.info("\u5411\u91cf\u5316\u67e5\u8be2\u670d\u52a1\u4e13\u7528\u8c03\u5ea6\u5668\u5df2\u5173\u95ed");
        }
    }

    public void afterPropertiesSet() {
        this.dedicatedScheduler = new ThreadPoolTaskScheduler();
        this.dedicatedScheduler.setPoolSize(1);
        this.dedicatedScheduler.setThreadNamePrefix("vector-query-dedicated-");
        this.dedicatedScheduler.setDaemon(true);
        this.dedicatedScheduler.initialize();
        this.logger.info("\u5411\u91cf\u5316\u67e5\u8be2\u670d\u52a1\u4e13\u7528\u8c03\u5ea6\u5668\u5df2\u521d\u59cb\u5316");
    }

    public static class VectorizationTask {
        private String checkId;
        private Long docId;
        private Long docBaseId;
        private LocalDateTime createdTime;
        private int retryCount;

        public String getCheckId() {
            return this.checkId;
        }

        public void setCheckId(String checkId) {
            this.checkId = checkId;
        }

        public Long getDocId() {
            return this.docId;
        }

        public void setDocId(Long docId) {
            this.docId = docId;
        }

        public Long getDocBaseId() {
            return this.docBaseId;
        }

        public void setDocBaseId(Long docBaseId) {
            this.docBaseId = docBaseId;
        }

        public LocalDateTime getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(LocalDateTime createdTime) {
            this.createdTime = createdTime;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public VectorizationTask() {
        }

        public VectorizationTask(String checkId, Long docId, Long docBaseId, LocalDateTime createdTime, int retryCount) {
            this.checkId = checkId;
            this.docId = docId;
            this.docBaseId = docBaseId;
            this.createdTime = createdTime;
            this.retryCount = retryCount;
        }
    }
}

