/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.doclibrary.dto.KnowledgeBasePageObj;
import com.jxdinfo.hussar.doclibrary.model.AIKnowledgeBase;
import com.jxdinfo.hussar.doclibrary.service.KnowledgeBaseService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/qa/knowledgeBase"})
public class KnowledgeBaseController {
    @Resource
    private KnowledgeBaseService knowledgeBaseService;

    @PostMapping(value={"/createKnowledBase"})
    public ApiResponse createKnowledBase(@RequestBody JSONObject param) {
        String knowledge_base_name = param.getString("knowledge_base_name");
        String knowledge_base_type = param.getString("knowledge_base_type");
        String description = param.getString("description");
        String splittingStrategyId = param.getString("splittingStrategyId");
        String processingMode = param.getString("processingMode");
        JSONArray entityExtractionRule = param.getJSONArray("entityExtractionRule");
        List ruleList = entityExtractionRule.toJavaList(String.class);
        return ApiResponse.success((String)this.knowledgeBaseService.createKnowledBase(knowledge_base_name, knowledge_base_type, description, splittingStrategyId, processingMode, ruleList));
    }

    @PostMapping(value={"/editKnowledBase"})
    public ApiResponse editKnowledBase(@RequestBody JSONObject param) {
        String knowledge_base_name = param.getString("knowledge_base_name");
        String description = param.getString("description");
        String splittingStrategyId = param.getString("splittingStrategyId");
        String baseId = param.getString("baseId");
        JSONArray entityExtractionRule = param.getJSONArray("entityExtractionRule");
        List ruleList = entityExtractionRule.toJavaList(String.class);
        return ApiResponse.success((Object)this.knowledgeBaseService.editKnowledBase(knowledge_base_name, description, splittingStrategyId, baseId, ruleList));
    }

    @PostMapping(value={"/getknowledgeBasesList"})
    public ApiResponse<List<KnowledgeBasePageObj>> getknowledgeBasesList(@RequestBody Map<String, String> param) {
        String queryName = param.get("query");
        String queryType = param.get("type");
        return ApiResponse.success(this.knowledgeBaseService.getknowledgeBasesList(queryName, queryType));
    }

    @PostMapping(value={"/delKnowledBase"})
    public ApiResponse delKnowledBase(@RequestBody Map<String, String> param) {
        String knowledge_base_name = param.get("knowledge_base_name");
        String knowledge_base_type = param.get("knowledge_base_type");
        return ApiResponse.success((String)this.knowledgeBaseService.delKnowledBase(knowledge_base_name, knowledge_base_type));
    }

    @GetMapping(value={"/qryKnoeledgeBase"})
    public ApiResponse<AIKnowledgeBase> qryKnoeledgeBase(Long baseId) {
        return ApiResponse.success((Object)((Object)this.knowledgeBaseService.qryKnoeledgeBase(baseId)));
    }

    @GetMapping(value={"/checkName"})
    public ApiResponse<Boolean> checkName(String baseName, Long baseId) {
        return ApiResponse.success((Object)this.knowledgeBaseService.checkName(baseName, baseId));
    }
}

