/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.doclibrary.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.doclibrary.dto.EnableDto;
import com.jxdinfo.hussar.doclibrary.dto.MergeDto;
import com.jxdinfo.hussar.doclibrary.dto.QADocFragmentListDto;
import com.jxdinfo.hussar.doclibrary.model.QADocFragment;
import com.jxdinfo.hussar.doclibrary.service.DocService;
import com.jxdinfo.hussar.doclibrary.service.IQADocFragmentService;
import com.jxdinfo.hussar.doclibrary.vo.PageDocFragmentListVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"qa/docmanager"})
public class QADocFragmentController {
    @Autowired
    private IQADocFragmentService qaDocFragmentService;
    @Autowired
    private DocService docService;

    @GetMapping(value={"list"})
    public ApiResponse<PageDocFragmentListVo> list(Page<QADocFragment> page, QADocFragmentListDto queryModel) {
        return ApiResponse.success((Object)this.qaDocFragmentService.listQaDocFragment(page, queryModel));
    }

    @PostMapping(value={"saveOrUpdate"})
    @HussarTransactional
    public ApiResponse<String> saveOrUpdate(@RequestBody QADocFragment qaDocFragment) {
        qaDocFragment = this.qaDocFragmentService.isSave(qaDocFragment);
        this.qaDocFragmentService.saveOrUpdate((Object)qaDocFragment);
        this.qaDocFragmentService.updateFragmentsNumber(qaDocFragment.getDocSourceId(), qaDocFragment.getFileBaseId());
        if ("1".equals(qaDocFragment.getEnable()) && "1".equals(this.docService.getFileBase(qaDocFragment.getFileBaseId(), qaDocFragment.getDocSourceId()).getEnable()) && !this.qaDocFragmentService.updateEmbeddingByLLM(qaDocFragment.getDocSourceId(), qaDocFragment.getFileBaseId()).booleanValue()) {
            throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
        }
        return ApiResponse.success((String)String.valueOf(qaDocFragment.getDocFragmentId()));
    }

    @PostMapping(value={"del"})
    public ApiResponse<Boolean> del(@RequestBody EnableDto enableDto) {
        return this.qaDocFragmentService.del(enableDto);
    }

    @PostMapping(value={"merge"})
    public ApiResponse<?> merge(@RequestBody MergeDto mergeDto) {
        this.qaDocFragmentService.merge(mergeDto);
        return ApiResponse.success();
    }

    @PostMapping(value={"enableOrDisable"})
    @HussarTransactional
    public ApiResponse<?> enableOrDisable(@RequestBody EnableDto enableDto) {
        this.qaDocFragmentService.enableOrDisable(enableDto.getIds(), enableDto.getEnable());
        if (enableDto.getIsUpdate().booleanValue() && "1".equals(this.docService.getFileBase(enableDto.getFileBaseId(), enableDto.getDocSourceId()).getEnable()) && !this.qaDocFragmentService.updateEmbeddingByLLM(enableDto.getDocSourceId(), enableDto.getFileBaseId()).booleanValue()) {
            throw new HussarException("\u6a21\u578b\u5411\u91cf\u5316\u5931\u8d25");
        }
        return ApiResponse.success();
    }
}

