/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dialogue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.dialogue.dao.RecommendQuestionMapper;
import com.jxdinfo.hussar.dialogue.model.RecommendQuestion;
import com.jxdinfo.hussar.dialogue.service.IRecommendQuestionService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class IRecommendQuestionServiceImpl
extends ServiceImpl<RecommendQuestionMapper, RecommendQuestion>
implements IRecommendQuestionService {
    @Resource
    RecommendQuestionMapper recommendQuestionMapper;

    @Override
    public List<String> getRecommendQuestionFromDialogueId(Long dialogueId) {
        if (dialogueId == null) {
            return new ArrayList<String>();
        }
        List recommendQuestions = this.recommendQuestionMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(RecommendQuestion::getDialogueId, (Object)dialogueId.toString()));
        if (recommendQuestions == null || recommendQuestions.isEmpty()) {
            return new ArrayList<String>();
        }
        return recommendQuestions.stream().map(RecommendQuestion::getQuestion).collect(Collectors.toList());
    }

    @Override
    @HussarTransactional
    public Boolean saveRecommendQuestion(Long dialogueId, List<String> questions) {
        this.recommendQuestionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(RecommendQuestion::getDialogueId, (Object)dialogueId.toString()));
        ArrayList<RecommendQuestion> recommendQuestions = new ArrayList<RecommendQuestion>();
        for (String question : questions) {
            RecommendQuestion recommendQuestion = new RecommendQuestion();
            recommendQuestion.setQuestion(question);
            recommendQuestion.setDialogueId(dialogueId);
            recommendQuestions.add(recommendQuestion);
        }
        return this.saveBatch(recommendQuestions);
    }
}

