/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class IqaFileConvertUtil {
    public static void convertCSVToXLSX(String csvFilePath, String xlsxFilePath) throws IOException {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        try (FileInputStream inputStream = new FileInputStream(csvFilePath);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
             BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            int rowIndex = 0;
            while ((line = bufferedReader.readLine()) != null) {
                String[] data = line.split(",");
                Row row = sheet.createRow(rowIndex++);
                int cellIndex = 0;
                for (String item : data) {
                    Cell cell = row.createCell(cellIndex++);
                    cell.setCellValue(item);
                }
            }
        }
        var5_5 = null;
        try (FileOutputStream outputStream = new FileOutputStream(xlsxFilePath);){
            workbook.write((OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    public static void main(String[] args) throws IOException {
        String csvFilePath = "D:\\upload\\1836943668269064192\\ai_opportunity.csv";
        String xlsxFilePath = "D:\\upload\\1836943668269064192\\ai_opportunity1.xlsx";
        IqaFileConvertUtil.convertCSVToXLSX(csvFilePath, xlsxFilePath);
    }
}

