/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util.pdfUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class IqaffmpegUtil {
    private static String ffmpegEXE;

    public IqaffmpegUtil(String ffmpegEXE) {
        IqaffmpegUtil.ffmpegEXE = ffmpegEXE;
    }

    public static void getThumb(String videoFilename, String thumbFilename, int width, int height, int hour, int min, float sec) throws IOException, InterruptedException {
        String line;
        ProcessBuilder processBuilder = new ProcessBuilder(ffmpegEXE, "-y", "-i", videoFilename, "-vframes", "1", "-ss", hour + ":" + min + ":" + sec, "-f", "mjpeg", "-s", width + "*" + height, "-an", thumbFilename);
        Process process = processBuilder.start();
        InputStream stderr = process.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
        }
        process.waitFor();
        if (br != null) {
            br.close();
        }
        if (isr != null) {
            isr.close();
        }
        if (stderr != null) {
            stderr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertor(String videoInputPath, String mp3InputPath, double seconds, String videoOutputPath) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ffmpegEXE);
        command.add("-i");
        command.add(videoInputPath);
        command.add("-i");
        command.add(mp3InputPath);
        command.add("-t");
        command.add(String.valueOf(seconds));
        command.add("-y");
        command.add(videoOutputPath);
        InputStream errorStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader br = null;
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            Process process = builder.start();
            errorStream = process.getErrorStream();
            inputStreamReader = new InputStreamReader(errorStream);
            br = new BufferedReader(inputStreamReader);
            while (br.readLine() != null) {
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (errorStream != null) {
                errorStream.close();
            }
        }
    }

    public static synchronized void convetor(String videoInputPath, String videoOutPath) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ffmpegEXE);
        command.add("-i");
        command.add(videoInputPath);
        command.add("-vcodec");
        command.add("libx264");
        command.add("-max_muxing_queue_size");
        command.add("9999");
        command.add(videoOutPath);
        ProcessBuilder builder = new ProcessBuilder(command);
        Process process = null;
        try {
            process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream errorStream = process.getErrorStream();
        InputStreamReader inputStreamReader = new InputStreamReader(errorStream);
        BufferedReader br = new BufferedReader(inputStreamReader);
        String line = "";
        while ((line = br.readLine()) != null) {
        }
        if (br != null) {
            br.close();
        }
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (errorStream != null) {
            errorStream.close();
        }
    }

    public static synchronized void convetorAvi(String videoInputPath, String videoOutPath) throws Exception {
        String pdfFilePathAvi = videoInputPath.substring(0, videoInputPath.lastIndexOf(".")) + "_new.avi";
        IqaffmpegUtil.convetor(videoInputPath, pdfFilePathAvi);
        File fileAvi = new File(pdfFilePathAvi);
        File fileOut = new File(videoOutPath);
        FileUtils.copyFile((File)fileAvi, (File)fileOut);
    }
}

