/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class IqaCSVUtils {
    public static Path toZip(File file) {
        Path path = Paths.get(file.getPath(), file.getName() + ".zip");
        ArrayList<Object> srcFiles = new ArrayList<Object>();
        if (file.isDirectory()) {
            srcFiles.addAll(Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())));
        } else {
            srcFiles.add(file);
        }
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(path, new OpenOption[0]));
            for (File file2 : srcFiles) {
                int len;
                if (file2.isDirectory()) continue;
                FileInputStream in = new FileInputStream(file2);
                out.putNextEntry(new ZipEntry(file2.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public static void exportCSVFile(HttpServletResponse response, File file) {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            int len = 0;
            byte[] buffer = new byte[1024];
            out = response.getOutputStream();
            response.reset();
            response.setContentType("application/zip;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
            response.setCharacterEncoding("UTF-8");
            out.write(new byte[]{-17, -69, -65});
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                assert (in != null);
                in.close();
                assert (out != null);
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static File compressFileByZIP(File file) {
        File zipFile = Paths.get(file.getParent(), file.getName() + ".zip").toFile();
        ArrayList<Object> fileList = new ArrayList<Object>();
        if (file.isDirectory()) {
            fileList.addAll(Arrays.asList((Object[])Objects.requireNonNull(file.listFiles())));
        } else {
            fileList.add(file);
        }
        FileInputStream fileInputStream = null;
        try {
            CheckedOutputStream checkedOutputStream = null;
            FileOutputStream outputStream = new FileOutputStream(zipFile);
            checkedOutputStream = new CheckedOutputStream(outputStream, new Adler32());
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)checkedOutputStream);
            zipOutputStream.setEncoding("UTF-8");
            for (File file2 : fileList) {
                int read;
                if (file2.isDirectory()) continue;
                zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                fileInputStream = new FileInputStream(file2);
                byte[] bytes = new byte[1024];
                while ((read = fileInputStream.read(bytes)) != -1) {
                    zipOutputStream.write(bytes);
                }
            }
            byte[] bytes = new byte[1024];
            while (true) {
                assert (fileInputStream != null);
                int n = fileInputStream.read(bytes);
                if (n == -1) break;
                zipOutputStream.write(bytes);
            }
            fileInputStream.close();
            zipOutputStream.close();
            outputStream.close();
            checkedOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return zipFile;
    }

    public static void deleteFile(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return super.postVisitDirectory(dir, exc);
            }
        });
    }
}

