/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.mybatis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={JSONArray.class})
public class JSONArrayTypeHandler
extends BaseTypeHandler<JSONArray> {
    public void setNonNullParameter(PreparedStatement ps, int i, JSONArray parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, parameter.toJSONString());
    }

    public JSONArray getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String jsonString = rs.getString(columnName);
        return this.parseJSON(jsonString);
    }

    public JSONArray getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String jsonString = rs.getString(columnIndex);
        return this.parseJSON(jsonString);
    }

    public JSONArray getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String jsonString = cs.getString(columnIndex);
        return this.parseJSON(jsonString);
    }

    private JSONArray parseJSON(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return JSON.parseArray((String)jsonString);
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }
}

