/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.util;

import com.jxdinfo.hussar.chatbi.dto.result.DimensionInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import java.util.List;
import java.util.Set;

public class FieldTypeUtil {
    public static final String FIELD_TYPE_NUMBER = "number";
    public static final String FIELD_TYPE_DATE = "date";
    public static final String FIELD_TYPE_STRING = "string";

    public static boolean checkFieldType(String fieldType) {
        return FIELD_TYPE_NUMBER.equals(fieldType) || FIELD_TYPE_DATE.equals(fieldType) || FIELD_TYPE_STRING.equals(fieldType);
    }

    public static boolean isString(String fieldType) {
        return FIELD_TYPE_STRING.equals(fieldType);
    }

    public static boolean isNumber(String fieldType) {
        return FIELD_TYPE_NUMBER.equals(fieldType);
    }

    public static boolean isDate(String fieldType) {
        return FIELD_TYPE_DATE.equals(fieldType);
    }

    public static void classifyFieldCommentsByType(Set<String> stringSet, Set<String> numberSet, Set<String> dateSet, List<FieldInfoSearchObj> fieldInfoSearchObjs) {
        if (fieldInfoSearchObjs == null) {
            return;
        }
        block8: for (FieldInfoSearchObj fieldInfoSearchObj : fieldInfoSearchObjs) {
            String fieldType = fieldInfoSearchObj.getField_type();
            String comment = fieldInfoSearchObj.getField_comment();
            switch (fieldType) {
                case "date": {
                    dateSet.add(comment);
                    continue block8;
                }
                case "number": {
                    numberSet.add(comment);
                    continue block8;
                }
            }
            stringSet.add(comment);
        }
    }

    public static void classifyDimensionNamesByType(Set<String> stringSet, Set<String> numberSet, Set<String> dateSet, List<DimensionInfoSearchObj> dimensionList) {
        if (dimensionList == null) {
            return;
        }
        block8: for (DimensionInfoSearchObj dimension : dimensionList) {
            String dimensionType = dimension.getDimension_type();
            String dimensionName = dimension.getDimension_name();
            switch (dimensionType) {
                case "date": {
                    dateSet.add(dimensionName);
                    continue block8;
                }
                case "number": {
                    numberSet.add(dimensionName);
                    continue block8;
                }
            }
            stringSet.add(dimensionName);
        }
    }
}

