/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.controller;

import com.jxdinfo.hussar.chatbi.dto.AddMetric;
import com.jxdinfo.hussar.chatbi.dto.AddTerm;
import com.jxdinfo.hussar.chatbi.dto.DatasetAndFieldInfos;
import com.jxdinfo.hussar.chatbi.dto.DatasetRelation;
import com.jxdinfo.hussar.chatbi.dto.QaPair;
import com.jxdinfo.hussar.chatbi.dto.SearchDatasetAndFieldsResult;
import com.jxdinfo.hussar.chatbi.dto.SearchDimensionResult;
import com.jxdinfo.hussar.chatbi.dto.SearchMetricAndDimensionResult;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.TermInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.search.SearchBase;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetAndFields;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetFieldValue;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDatasetFieldValueBatch;
import com.jxdinfo.hussar.chatbi.dto.search.SearchDimension;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricAndDimension;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricDimensionValue;
import com.jxdinfo.hussar.chatbi.dto.search.SearchMetricDimensionValueBatch;
import com.jxdinfo.hussar.chatbi.model.DataDomainAuthInfo;
import com.jxdinfo.hussar.chatbi.service.ChatBIApiService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.vector.milvus.dto.QueryCollectionData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

@RestController
@RequestMapping(value={"/chatbi/api"})
public class ChatBIApiController {
    @Resource
    private ChatBIApiService chatBIApiService;

    @GetMapping(value={"/startUpdateValueTask"})
    public ApiResponse<Boolean> startUpdateValueTask() {
        return ApiResponse.success((Object)this.chatBIApiService.updateAllFieldAndDimensionValueAsync());
    }

    @PostMapping(value={"/dataDomain/init"})
    public ApiResponse<Map<String, Object>> initDataDomain(@RequestBody DataDomainAuthInfo dataDomainAuthInfo) {
        return ApiResponse.success(this.chatBIApiService.initDataDomain(dataDomainAuthInfo));
    }

    @PostMapping(value={"/dataDomain/update"})
    public ApiResponse<Boolean> updateDataDomainInfo(@RequestBody DataDomainAuthInfo dataDomainAuthInfo) {
        return ApiResponse.success((Object)this.chatBIApiService.updateDataDomainInfo(dataDomainAuthInfo));
    }

    @GetMapping(value={"/dataDomain/delete"})
    public ApiResponse<Boolean> deleteDataDomainInfo(String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteDataDomainInfo(dataDomainCode));
    }

    @GetMapping(value={"/refreshCache"})
    public ApiResponse<Boolean> refreshCache(String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.refreshCache(dataDomainCode));
    }

    @PostMapping(value={"/dataset/addInfoAndFields"})
    public ApiResponse<Boolean> addDatasetAndFieldInfos(@RequestBody DatasetAndFieldInfos datasetAndFieldInfos, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.addDatasetAndFieldInfos(datasetAndFieldInfos, dataDomainCode));
    }

    @PostMapping(value={"/dataset/updateInfoAndFields"})
    public ApiResponse<Boolean> updateDatasetAndFieldInfos(@RequestBody DatasetAndFieldInfos datasetAndFieldInfos, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.updateDatasetAndFieldInfos(datasetAndFieldInfos, dataDomainCode));
    }

    @GetMapping(value={"/dataset/delete"})
    public ApiResponse<Boolean> deleteDataset(String dataset_id, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteDataset(dataset_id, dataDomainCode));
    }

    @PostMapping(value={"/dimension/upsert"})
    public ApiResponse<Boolean> updateDimension(@RequestBody DimensionInfoSearchObj updateDimension, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.upsertDimension(updateDimension, dataDomainCode));
    }

    @GetMapping(value={"/dimension/delete"})
    public ApiResponse<Boolean> deleteDimension(String dimension_id, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteDimension(dimension_id, dataDomainCode));
    }

    @PostMapping(value={"/metric/upsert"})
    public ApiResponse<Boolean> upsertMetric(@RequestBody AddMetric addMetric, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.upsertMetric(addMetric, dataDomainCode));
    }

    @GetMapping(value={"/metric/delete"})
    public ApiResponse<Boolean> deleteMetric(String metric_id, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteMetric(metric_id, dataDomainCode));
    }

    @PostMapping(value={"/queryCollectionData"})
    public ApiResponse<List<Map<String, Object>>> queryCollectionData(@RequestBody QueryCollectionData queryCollectionData) {
        return ApiResponse.success(this.chatBIApiService.queryCollectionData(queryCollectionData));
    }

    @PostMapping(value={"/qaPair/batch/add"})
    public ApiResponse<Boolean> addQaPairBatch(@RequestBody List<QaPair> qaPairs, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.addQaPairBatch(qaPairs, dataDomainCode));
    }

    @PostMapping(value={"/qaPair/add"})
    public ApiResponse<Boolean> addQaPairBatch(@RequestBody QaPair qaPair, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.addQaPairBatch(Collections.singletonList(qaPair), dataDomainCode));
    }

    @GetMapping(value={"/qaPair/delete"})
    public ApiResponse<Boolean> deleteQaPair(String question, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteQaPair(question, dataDomainCode));
    }

    @PostMapping(value={"/dataset/updateRelation"})
    public ApiResponse<Boolean> updateDatasetRelation(@RequestBody DatasetRelation datasetRelation, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.updateDatasetRelation(datasetRelation, dataDomainCode));
    }

    @PostMapping(value={"/dataset/addRelation"})
    public ApiResponse<Boolean> addDatasetRelation(@RequestBody DatasetRelation datasetRelation, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.addDatasetRelation(datasetRelation, dataDomainCode));
    }

    @GetMapping(value={"/dataset/deleteRelation"})
    public ApiResponse<Boolean> deleteDatasetRelation(String dataset_id, String relation_id, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteDatasetRelation(dataset_id, relation_id, dataDomainCode));
    }

    @PostMapping(value={"/term/batch/add"})
    public ApiResponse<Boolean> addTermBatch(@RequestBody List<AddTerm> terms, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.addTermBatch(terms, dataDomainCode));
    }

    @PostMapping(value={"/term/update"})
    public ApiResponse<Boolean> updateTerm(@RequestBody TermInfoSearchObj term, @RequestParam String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.updateTerm(term, dataDomainCode));
    }

    @GetMapping(value={"/term/delete"})
    public ApiResponse<Boolean> removeTerm(String term_id, String dataDomainCode) {
        return ApiResponse.success((Object)this.chatBIApiService.deleteTerm(term_id, dataDomainCode));
    }

    @GetMapping(value={"/term/list"})
    public ApiResponse<List<TermInfoSearchObj>> termList(String dataDomainCode) {
        return ApiResponse.success(this.chatBIApiService.termList(dataDomainCode));
    }

    @PostMapping(value={"/search/qaPair"})
    public ApiResponse<List<QaPair>> searchQaPair(@RequestBody SearchBase searchBase, @RequestParam Long dataDomainId) {
        List<QaPair> list = this.chatBIApiService.searchQaPair(searchBase, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/metricAndDimension"})
    public ApiResponse<List<SearchMetricAndDimensionResult>> searchMetricAndDimension(@RequestBody SearchMetricAndDimension searchParameter, @RequestParam Long dataDomainId) {
        List<SearchMetricAndDimensionResult> list = this.chatBIApiService.searchMetricAndDimension(searchParameter, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/dimension"})
    public ApiResponse<SearchDimensionResult> searchDimension(@RequestBody SearchDimension searchDimension, @RequestParam Long dataDomainId) {
        SearchDimensionResult result = this.chatBIApiService.searchDimension(searchDimension, dataDomainId);
        return ApiResponse.success((Object)result);
    }

    @PostMapping(value={"/search/metricDimensionValue"})
    public ApiResponse<List<String>> searchMetricDimensionValue(@RequestBody SearchMetricDimensionValue searchParameter, @RequestParam Long dataDomainId) {
        List<String> list = this.chatBIApiService.searchMetricDimensionValue(searchParameter, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/batch/metricDimensionValue"})
    public ApiResponse<Map<String, Map<String, List<String>>>> searchDimensionValueBatch(@RequestBody SearchMetricDimensionValueBatch searchParameter, @RequestParam Long dataDomainId) {
        Map<String, Map<String, List<String>>> result = this.chatBIApiService.searchDimensionValueBatch(searchParameter, dataDomainId);
        return ApiResponse.success(result);
    }

    @PostMapping(value={"/search/term"})
    public ApiResponse<List<String>> searchTerm(@RequestBody SearchBase searchBase, @RequestParam Long dataDomainId) {
        List<String> list = this.chatBIApiService.searchTerm(searchBase, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/datasetAndField"})
    public ApiResponse<List<SearchDatasetAndFieldsResult>> searchDatasetAndField(@RequestBody SearchDatasetAndFields searchParam, @RequestParam Long dataDomainId) {
        List<SearchDatasetAndFieldsResult> list = this.chatBIApiService.searchDatasetAndField(searchParam, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/datasetFieldValue"})
    public ApiResponse<List<String>> searchDatasetFieldValue(@RequestBody SearchDatasetFieldValue searchParameters, @RequestParam Long dataDomainId) {
        List<String> list = this.chatBIApiService.searchDatasetFieldValue(searchParameters, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/search/batch/datasetFieldValue"})
    public ApiResponse<Map<String, Map<String, List<String>>>> searchDatasetFieldValueBatch(@RequestBody SearchDatasetFieldValueBatch searchParameters, @RequestParam Long dataDomainId) {
        Map<String, Map<String, List<String>>> list = this.chatBIApiService.searchDatasetFieldValueBatch(searchParameters, dataDomainId);
        return ApiResponse.success(list);
    }

    @PostMapping(value={"/qa"})
    public ApiResponse<Map<String, Object>> qa(@RequestBody Map<String, Object> params, @RequestParam String dataDomainCode, @RequestParam(required=false) String demoFlag) {
        Map<String, Object> response = this.chatBIApiService.qa(params, dataDomainCode, demoFlag);
        return ApiResponse.success(response);
    }

    @PostMapping(value={"/qaStream"}, produces={"text/event-stream"})
    public Flux<String> qaStream(@RequestBody Map<String, Object> params, @RequestParam String dataDomainCode, @RequestParam(required=false) String demoFlag) {
        return this.chatBIApiService.qaStream(params, dataDomainCode, demoFlag);
    }

    @PostMapping(value={"/summarize"})
    public ApiResponse<Map<String, Object>> summarize(@RequestBody Map<String, Object> params, @RequestParam(required=false) String demoFlag) {
        Map<String, Object> response = this.chatBIApiService.summarize(params, demoFlag);
        return ApiResponse.success(response);
    }

    @PostMapping(value={"/dataAnalysis"}, produces={"text/event-stream"})
    public Flux<String> dataAnalysis(@RequestBody Map<String, Object> params, @RequestParam(required=false) String demoFlag) {
        return this.chatBIApiService.dataAnalysis(params, demoFlag);
    }
}

