/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.chatbi.service.impl;

import com.jxdinfo.hussar.chatbi.dto.QaPair;
import com.jxdinfo.hussar.chatbi.dto.TextVector;
import com.jxdinfo.hussar.chatbi.dto.result.DatasetInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.DimensionValueSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.FieldInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.MetricInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.QaInfoSearchObj;
import com.jxdinfo.hussar.chatbi.dto.result.TermInfoSearchObj;
import com.jxdinfo.hussar.chatbi.model.DatasetEntity;
import com.jxdinfo.hussar.chatbi.model.DimensionEntity;
import com.jxdinfo.hussar.chatbi.model.DimensionValueEntity;
import com.jxdinfo.hussar.chatbi.model.FieldEntity;
import com.jxdinfo.hussar.chatbi.model.MetricEntity;
import com.jxdinfo.hussar.chatbi.model.QaEntity;
import com.jxdinfo.hussar.chatbi.model.TermEntity;
import com.jxdinfo.hussar.chatbi.service.VectorStoreService;
import com.jxdinfo.hussar.chatbi.util.DataDomainIdVectorCountCache;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.vector.milvus.dto.QueryCollectionData;
import com.jxdinfo.hussar.vector.milvus.service.IMilvusAnnotationService;
import com.jxdinfo.hussar.vector.milvus.util.MSFunction;
import com.jxdinfo.hussar.vector.milvus.wrapper.MilvusHybridSearchWrapper;
import com.jxdinfo.hussar.vector.milvus.wrapper.MilvusQueryWrapper;
import com.jxdinfo.hussar.vector.milvus.wrapper.MilvusSearchWrapper;
import io.milvus.v2.service.vector.request.data.BaseVector;
import io.milvus.v2.service.vector.request.data.EmbeddedText;
import io.milvus.v2.service.vector.request.data.FloatVec;
import io.milvus.v2.service.vector.request.ranker.BaseRanker;
import io.milvus.v2.service.vector.request.ranker.WeightedRanker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mtMilvusVectorStoreService")
public class MilvusVectorStoreServiceImpl
implements VectorStoreService {
    private static final Logger logger = LoggerFactory.getLogger(MilvusVectorStoreServiceImpl.class);
    private static final ExecutorService executor = Executors.newFixedThreadPool(64);
    private final DataDomainIdVectorCountCache countCache = new DataDomainIdVectorCountCache();
    @Resource
    private IMilvusAnnotationService milvusService;

    @Override
    public void init(List<String> dataDomainIds) {
        for (String dataDomainId : dataDomainIds) {
            this.countCache.init(dataDomainId);
            this.refresh(dataDomainId);
        }
    }

    @Override
    public void refresh(List<String> dataDomainIds) {
        for (String dataDomainId : dataDomainIds) {
            this.countCache.init(dataDomainId);
        }
    }

    @Override
    public void refresh(String dataDomainId) {
        long metricCount = this.countCollectionEntity(MetricEntity.class, dataDomainId);
        this.countCache.resetMetricCount(dataDomainId, metricCount);
        long qaCount = this.countCollectionEntity(QaEntity.class, dataDomainId);
        this.countCache.resetQaCount(dataDomainId, qaCount);
        long termCount = this.countCollectionEntity(TermEntity.class, dataDomainId);
        this.countCache.resetTermCount(dataDomainId, termCount);
    }

    @Override
    public List<DatasetInfoSearchObj> searchDataset(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DatasetEntity.class, dataDomainId);
                wrapper.topK(topK).searchParams(searchParams).data((BaseVector)new FloatVec(textVector.getDenseVector())).annsField(DatasetEntity::getDataset_name_dense_vector);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DatasetEntity.class, dataDomainId);
                wrapper.topK(bm25TopK).searchParams(bm25Params).data((BaseVector)new EmbeddedText(textVector.getText())).annsField(DatasetEntity::getDataset_name);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "dataset_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<DatasetInfoSearchObj> datasetInfoSearchObjs = new ArrayList<DatasetInfoSearchObj>();
        for (Map map : data) {
            DatasetInfoSearchObj dataset = new DatasetInfoSearchObj();
            dataset.setDataset_id(map.get("dataset_id").toString());
            dataset.setDataset_name(map.get("dataset_name").toString());
            dataset.setDataset_info(map.get("dataset_info").toString());
            datasetInfoSearchObjs.add(dataset);
        }
        return datasetInfoSearchObjs;
    }

    private List<Map<String, Object>> sortHybridResults(List<Map<String, Object>> denseResults, List<Map<String, Object>> bm25Results, String idKey) {
        String id;
        int i;
        HashMap<String, Integer> denseRankMap = new HashMap<String, Integer>();
        HashMap<String, Integer> bm25RankMap = new HashMap<String, Integer>();
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
        for (i = 0; i < denseResults.size(); ++i) {
            id = denseResults.get(i).get(idKey).toString();
            denseRankMap.put(id, i + 1);
            dataMap.put(id, denseResults.get(i));
        }
        for (i = 0; i < bm25Results.size(); ++i) {
            id = bm25Results.get(i).get(idKey).toString();
            bm25RankMap.put(id, i + 1);
            dataMap.put(id, bm25Results.get(i));
        }
        ArrayList<String> bothIds = new ArrayList<String>();
        ArrayList<String> bm25OnlyIds = new ArrayList<String>();
        ArrayList<String> denseOnlyIds = new ArrayList<String>();
        for (String id2 : dataMap.keySet()) {
            boolean inDense = denseRankMap.containsKey(id2);
            boolean inBm25 = bm25RankMap.containsKey(id2);
            if (inDense && inBm25) {
                bothIds.add(id2);
                continue;
            }
            if (inBm25) {
                bm25OnlyIds.add(id2);
                continue;
            }
            denseOnlyIds.add(id2);
        }
        bothIds.sort((a, b) -> {
            int sumA = (Integer)denseRankMap.get(a) + (Integer)bm25RankMap.get(a);
            int sumB = (Integer)denseRankMap.get(b) + (Integer)bm25RankMap.get(b);
            return Integer.compare(sumA, sumB);
        });
        bm25OnlyIds.sort(Comparator.comparingInt(bm25RankMap::get));
        denseOnlyIds.sort(Comparator.comparingInt(denseRankMap::get));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (String id3 : bothIds) {
            result.add((Map<String, Object>)dataMap.get(id3));
        }
        for (String id4 : bm25OnlyIds) {
            result.add((Map<String, Object>)dataMap.get(id4));
        }
        for (String id5 : denseOnlyIds) {
            result.add((Map<String, Object>)dataMap.get(id5));
        }
        return result;
    }

    @Override
    public List<DatasetInfoSearchObj> queryDatasetListByIdList(List<String> datasetIds, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DatasetEntity.class, dataDomainId);
        wrapper.ids(new ArrayList<String>(datasetIds));
        return this.milvusService.queryList(wrapper, DatasetInfoSearchObj.class);
    }

    @Override
    public void deleteDataset(String datasetId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DatasetEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(datasetId));
        this.milvusService.delete(wrapper);
    }

    @Override
    public void updateDataset(DatasetEntity dataset, String dataDomainId) {
        this.milvusService.upsert((Object)dataset, dataDomainId);
    }

    @Override
    public void insertDataset(DatasetEntity dataset, String dataDomainId) {
        this.milvusService.insert((Object)dataset, dataDomainId);
    }

    @Override
    public Long countTerm(String dataDomainId) {
        return this.countCache.getTermCount(dataDomainId);
    }

    @Override
    public TermInfoSearchObj queryTermById(String termId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(TermEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(termId));
        List terms = this.milvusService.queryList(wrapper, TermInfoSearchObj.class);
        if (terms.isEmpty()) {
            return null;
        }
        return (TermInfoSearchObj)terms.get(0);
    }

    @Override
    public List<TermInfoSearchObj> searchTerm(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(TermEntity.class, dataDomainId);
                wrapper.topK(topK).searchParams(searchParams).data((BaseVector)new FloatVec(textVector.getDenseVector())).annsField(TermEntity::getTerm_dense_vector);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(TermEntity.class, dataDomainId);
                wrapper.topK(bm25TopK).searchParams(bm25Params).data((BaseVector)new EmbeddedText(textVector.getText())).annsField(TermEntity::getTerm);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "term_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<TermInfoSearchObj> termInfoSearchObjs = new ArrayList<TermInfoSearchObj>();
        for (Map map : data) {
            TermInfoSearchObj termInfoSearchObj = new TermInfoSearchObj();
            termInfoSearchObj.setTerm_id(map.get("term_id").toString());
            termInfoSearchObj.setTerm(map.get("term").toString());
            termInfoSearchObj.setExplanation(map.get("explanation").toString());
            termInfoSearchObjs.add(termInfoSearchObj);
        }
        return termInfoSearchObjs;
    }

    @Override
    public List<TermInfoSearchObj> termPage(long current, long size, String dataDomainId) {
        long offset = (current - 1L) * size;
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(TermEntity.class, dataDomainId);
        wrapper.eq(TermEntity::getTerm_id, (Object)"-1").limit(size).offset(offset);
        return this.milvusService.queryList(wrapper, TermInfoSearchObj.class);
    }

    @Override
    public List<TermEntity> termVectorPage(long current, long size, String dataDomainId) {
        long offset = (current - 1L) * size;
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(TermEntity.class, dataDomainId);
        wrapper.eq(TermEntity::getTerm_id, (Object)"-1").limit(size).offset(offset).queryVector(true);
        return this.milvusService.queryList(wrapper);
    }

    @Override
    public List<TermInfoSearchObj> termList(String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(TermEntity.class, dataDomainId);
        wrapper.eq(TermEntity::getTerm_id, (Object)"-1");
        return this.milvusService.queryList(wrapper, TermInfoSearchObj.class);
    }

    @Override
    public void deleteTermList(List<String> termIds, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(TermEntity.class, dataDomainId);
        wrapper.ids(new ArrayList<String>(termIds));
        long c = this.milvusService.delete(wrapper);
        this.countCache.decrementTermCount(dataDomainId, c);
    }

    @Override
    public void updateTerm(TermEntity term, String dataDomainId) {
        this.milvusService.upsert((Object)term, dataDomainId);
    }

    @Override
    public void insertTermList(List<TermEntity> terms, String dataDomainId) {
        long c = this.milvusService.insertBatch(terms, dataDomainId);
        this.countCache.incrementTermCount(dataDomainId, c);
    }

    @Override
    public List<DimensionInfoSearchObj> queryStringDimensionListByIds(List<String> dimensionIds, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionEntity.class, dataDomainId);
        wrapper.eq(DimensionEntity::getDimension_type, (Object)"string");
        wrapper.in(DimensionEntity::getDimension_id, dimensionIds);
        return this.milvusService.queryList(wrapper, DimensionInfoSearchObj.class);
    }

    @Override
    public List<DimensionInfoSearchObj> dimensionList(String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionEntity.class, dataDomainId);
        wrapper.ne(DimensionEntity::getDimension_id, (Object)"-1");
        return this.milvusService.queryList(wrapper, DimensionInfoSearchObj.class);
    }

    @Override
    public void deleteDimensionAndValue(String dimensionId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(dimensionId));
        this.milvusService.delete(wrapper);
        MilvusQueryWrapper wrapper2 = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper2.eq(DimensionValueEntity::getDimension_id, (Object)dimensionId);
        this.milvusService.delete(wrapper2);
    }

    @Override
    public void updateDimension(DimensionEntity dimensionEntity, String dataDomainId) {
        this.milvusService.upsert((Object)dimensionEntity, dataDomainId);
    }

    @Override
    public DimensionEntity queryDimension(String dimensionId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(dimensionId)).queryVector(true);
        List rList = this.milvusService.queryList(wrapper);
        if (rList.isEmpty()) {
            return null;
        }
        return (DimensionEntity)rList.get(0);
    }

    @Override
    public void insertDimension(DimensionEntity dimensionEntity, String dataDomainId) {
        this.milvusService.insert((Object)dimensionEntity, dataDomainId);
    }

    @Override
    public List<DimensionInfoSearchObj> searchCompositeMetricDimension(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId, List<String> dimensionIds) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionEntity.class, dataDomainId);
                wrapper.in(DimensionEntity::getDimension_id, dimensionIds);
                wrapper.topK(topK).searchParams(searchParams).data((BaseVector)new FloatVec(textVector.getDenseVector())).annsField(DimensionEntity::getDimension_name_dense_vector);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionEntity.class, dataDomainId);
                wrapper.in(DimensionEntity::getDimension_id, dimensionIds);
                wrapper.topK(bm25TopK).searchParams(bm25Params).data((BaseVector)new EmbeddedText(textVector.getText())).annsField(DimensionEntity::getDimension_name);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "dimension_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<DimensionInfoSearchObj> dimensions = new ArrayList<DimensionInfoSearchObj>();
        for (Map map : data) {
            DimensionInfoSearchObj dimension = new DimensionInfoSearchObj();
            dimension.setDimension_id(map.get("dimension_id").toString());
            dimension.setDimension_name(map.get("dimension_name").toString());
            dimension.setDimension_type(map.get("dimension_type").toString());
            dimensions.add(dimension);
        }
        return dimensions;
    }

    @Override
    public void deleteFieldValuesByFieldIds(List<String> fieldIds, String dataDomainId) {
        if (fieldIds == null || fieldIds.isEmpty()) {
            return;
        }
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper.in(DimensionValueEntity::getField_id, fieldIds);
        this.milvusService.delete(wrapper);
    }

    @Override
    public List<DimensionValueSearchObj> searchValues(List<String> fieldIds, List<String> dimensionIds, String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        ArrayList denseResults = new ArrayList();
        ArrayList bm25Results = new ArrayList();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionValueEntity.class, dataDomainId);
                wrapper.annsField(DimensionValueEntity::getValue_dense_vector).data((BaseVector)new FloatVec(textVector.getDenseVector())).searchParams(searchParams).topK(topK);
                if (fieldIds != null && !fieldIds.isEmpty()) {
                    wrapper.in(DimensionValueEntity::getField_id, fieldIds);
                }
                if (dimensionIds != null && !dimensionIds.isEmpty()) {
                    wrapper.or().in(DimensionValueEntity::getDimension_id, dimensionIds);
                }
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionValueEntity.class, dataDomainId);
                wrapper.annsField(DimensionValueEntity::getDimension_value).data((BaseVector)new EmbeddedText(textVector.getText())).searchParams(bm25Params).topK(bm25TopK);
                if (fieldIds != null && !fieldIds.isEmpty()) {
                    wrapper.in(DimensionValueEntity::getField_id, fieldIds);
                }
                if (dimensionIds != null && !dimensionIds.isEmpty()) {
                    wrapper.or().in(DimensionValueEntity::getDimension_id, dimensionIds);
                }
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        ArrayList data = new ArrayList();
        data.addAll(denseResults);
        data.addAll(bm25Results);
        ArrayList<DimensionValueSearchObj> r = new ArrayList<DimensionValueSearchObj>();
        for (Map d : data) {
            DimensionValueSearchObj value = new DimensionValueSearchObj();
            value.setDimension_id(d.get("dimension_id").toString());
            value.setField_id(d.get("field_id").toString());
            value.setDimension_value(d.get("dimension_value").toString());
            r.add(value);
        }
        return r;
    }

    @Override
    public List<String> searchDimensionValues(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId, String dimensionId) {
        return this.searchDimFieldValues(searchType, topK, bm25TopK, searchParams, bm25Params, textVector, dataDomainId, DimensionValueEntity::getDimension_id, dimensionId);
    }

    @Override
    public List<String> searchFieldValues(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId, String fieldId) {
        return this.searchDimFieldValues(searchType, topK, bm25TopK, searchParams, bm25Params, textVector, dataDomainId, DimensionValueEntity::getField_id, fieldId);
    }

    private List<String> searchDimFieldValues(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId, MSFunction<DimensionValueEntity, ?> getter, String value) {
        ArrayList denseResults = new ArrayList();
        ArrayList bm25Results = new ArrayList();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionValueEntity.class, dataDomainId);
                wrapper.annsField(DimensionValueEntity::getValue_dense_vector).data((BaseVector)new FloatVec(textVector.getDenseVector())).searchParams(searchParams).topK(topK).outputFields(new MSFunction[]{DimensionValueEntity::getDimension_value}).eq(getter, (Object)value);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(DimensionValueEntity.class, dataDomainId);
                wrapper.annsField(DimensionValueEntity::getDimension_value).topK(bm25TopK).data((BaseVector)new EmbeddedText(textVector.getText())).searchParams(bm25Params).outputFields(new MSFunction[]{DimensionValueEntity::getDimension_value}).eq(getter, (Object)value);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        ArrayList data = new ArrayList();
        data.addAll(denseResults);
        data.addAll(bm25Results);
        HashSet<String> results = new HashSet<String>();
        for (Map r : data) {
            results.add(r.get("dimension_value").toString());
        }
        return new ArrayList<String>(results);
    }

    @Override
    public void insertDimensionValueList(String dimensionId, List<TextVector> valuesToAdd, String dataDomainId) {
        this.insertDimensionOrFieldValuesToVectorDB(dimensionId, "", valuesToAdd, dataDomainId);
    }

    @Override
    public void insertFieldValueList(String fieldId, List<TextVector> valuesToAdd, String dataDomainId) {
        this.insertDimensionOrFieldValuesToVectorDB("", fieldId, valuesToAdd, dataDomainId);
    }

    private void insertDimensionOrFieldValuesToVectorDB(String dimensionId, String fieldId, List<TextVector> textVectors, String dataDomainId) {
        ArrayList<DimensionValueEntity> dataList = new ArrayList<DimensionValueEntity>();
        for (TextVector textVector : textVectors) {
            DimensionValueEntity data = new DimensionValueEntity();
            data.setDimension_id(dimensionId);
            data.setField_id(fieldId);
            data.setDimension_value(textVector.getText());
            data.setValue_dense_vector(textVector.getDenseVector());
            dataList.add(data);
        }
        long c = this.milvusService.insertBatch(dataList, dataDomainId);
        logger.info("\u7ef4\u5ea6\u503c\u603b\u5171\u65b0\u589e\u4e86{}\u4e2a\uff0c\u7ef4\u5ea6id\uff1a{}\uff0c\u5b57\u6bb5id\uff1a{}", new Object[]{c, dimensionId, fieldId});
    }

    @Override
    public void deleteFieldValues(String fieldId, List<String> valuesToDelete, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper.eq(DimensionValueEntity::getField_id, (Object)fieldId).in(DimensionValueEntity::getDimension_value, valuesToDelete);
        long c = this.milvusService.delete(wrapper);
        logger.info("\u5b57\u6bb5\u503c\u5220\u9664\u4e86{}\u4e2a", (Object)c);
    }

    @Override
    public void deleteDimensionValues(String dimensionId, List<String> valuesToDelete, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper.eq(DimensionValueEntity::getDimension_id, (Object)dimensionId).in(DimensionValueEntity::getDimension_value, valuesToDelete);
        long c = this.milvusService.delete(wrapper);
        logger.info("\u7ef4\u5ea6\u503c\u5220\u9664\u4e86{}\u4e2a", (Object)c);
    }

    @Override
    public List<String> queryFieldValues(String fieldId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper.eq(DimensionValueEntity::getField_id, (Object)fieldId);
        wrapper.outputFields(new MSFunction[]{DimensionValueEntity::getDimension_value});
        List rList = this.milvusService.queryMapList(wrapper);
        ArrayList<String> result = new ArrayList<String>();
        for (Map r : rList) {
            result.add(r.get("dimension_value").toString());
        }
        return result;
    }

    @Override
    public List<String> queryDimensionValues(String dimensionId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        wrapper.eq(DimensionValueEntity::getDimension_id, (Object)dimensionId);
        wrapper.outputFields(new MSFunction[]{DimensionValueEntity::getDimension_value});
        List rList = this.milvusService.queryMapList(wrapper);
        ArrayList<String> result = new ArrayList<String>();
        for (Map r : rList) {
            result.add(r.get("dimension_value").toString());
        }
        return result;
    }

    @Override
    public QaInfoSearchObj queryQaById(String qaId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(QaEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(qaId));
        List rList = this.milvusService.queryMapList(wrapper);
        if (rList == null || rList.isEmpty()) {
            return null;
        }
        Map entity = (Map)rList.get(0);
        QaInfoSearchObj qaInfoSearchObj = new QaInfoSearchObj();
        qaInfoSearchObj.setQa_id(entity.get("qa_id").toString());
        qaInfoSearchObj.setQuestion(entity.get("question").toString());
        qaInfoSearchObj.setAnswer(entity.get("answer").toString());
        return qaInfoSearchObj;
    }

    @Override
    public void deleteQaByIdList(List<String> qaIds, String dataDomainId) {
        ArrayList<String> idObjs = new ArrayList<String>(qaIds);
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(QaEntity.class, dataDomainId);
        wrapper.ids(idObjs);
        long c = this.milvusService.delete(wrapper);
        this.countCache.decrementQaCount(dataDomainId, c);
    }

    @Override
    public Long countQa(String dataDomainId) {
        return this.countCache.getQaCount(dataDomainId);
    }

    @Override
    public List<QaInfoSearchObj> qaPage(long current, long size, String dataDomainId) {
        long offset = (current - 1L) * size;
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(QaEntity.class, dataDomainId);
        wrapper.ne(QaEntity::getQa_id, (Object)"-1").offset(offset).limit(size);
        return this.milvusService.queryList(wrapper, QaInfoSearchObj.class);
    }

    @Override
    public List<QaPair> searchQaPair(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(QaEntity.class, dataDomainId);
                wrapper.annsField(QaEntity::getQuestion_dense_vector).data((BaseVector)new FloatVec(textVector.getDenseVector())).searchParams(searchParams).topK(topK);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(QaEntity.class, dataDomainId);
                wrapper.annsField(QaEntity::getQuestion).topK(bm25TopK).data((BaseVector)new EmbeddedText(textVector.getText())).searchParams(bm25Params);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "qa_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<QaPair> qaPairs = new ArrayList<QaPair>();
        for (Map map : data) {
            QaPair qaPair = new QaPair();
            qaPair.setQuestion(map.get("question").toString());
            qaPair.setAnswer(map.get("answer").toString());
            qaPairs.add(qaPair);
        }
        return qaPairs;
    }

    @Override
    public void deleteQaPair(String question, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(QaEntity.class, dataDomainId);
        wrapper.eq(QaEntity::getQuestion, (Object)question);
        long c = this.milvusService.delete(wrapper);
        this.countCache.decrementQaCount(dataDomainId, c);
    }

    @Override
    public void insertQaPairList(List<QaEntity> qaEntities, String dataDomainId) {
        long c = this.milvusService.insertBatch(qaEntities, dataDomainId);
        this.countCache.incrementQaCount(dataDomainId, c);
    }

    @Override
    public void updateQaPair(QaEntity qaEntity, String dataDomainId) {
        this.milvusService.upsert((Object)qaEntity, dataDomainId);
    }

    @Override
    public List<QaInfoSearchObj> queryQaListByQuestionList(List<String> questions, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(QaEntity.class, dataDomainId);
        wrapper.in(QaEntity::getQuestion, questions);
        return this.milvusService.queryList(wrapper, QaInfoSearchObj.class);
    }

    @Override
    public List<MetricInfoSearchObj> metricPage(long current, long size, String dataDomainId) {
        long offset = (current - 1L) * size;
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(MetricEntity.class, dataDomainId);
        wrapper.ne(MetricEntity::getMetric_id, (Object)"-1").offset(offset).limit(size);
        return this.milvusService.queryList(wrapper, MetricInfoSearchObj.class);
    }

    @Override
    public Long countMetric(String dataDomainId) {
        return this.countCache.getMetricCount(dataDomainId);
    }

    private long countCollectionEntity(Class<?> clazz, String id) {
        return this.milvusService.count(clazz, id);
    }

    @Override
    public List<MetricInfoSearchObj> searchMetric(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusHybridSearchWrapper wrapper = new MilvusHybridSearchWrapper(MetricEntity.class, dataDomainId);
                wrapper.topK(topK).reranker((BaseRanker)new WeightedRanker(Arrays.asList(Float.valueOf(0.8f), Float.valueOf(0.2f)))).addSearchRequest(MetricEntity::getMetric_name_dense_vector, (BaseVector)new FloatVec(textVector.getDenseVector()), topK, searchParams).addSearchRequest(MetricEntity::getMetric_info_dense_vector, (BaseVector)new FloatVec(textVector.getDenseVector()), topK, searchParams);
                return this.milvusService.hybridSearchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(MetricEntity.class, dataDomainId);
                wrapper.annsField(MetricEntity::getMetric_name).topK(bm25TopK).data((BaseVector)new EmbeddedText(textVector.getText())).searchParams(bm25Params);
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "metric_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<MetricInfoSearchObj> resultList = new ArrayList<MetricInfoSearchObj>();
        for (Map map : data) {
            MetricInfoSearchObj metric = new MetricInfoSearchObj();
            metric.setMetric_id(map.get("metric_id").toString());
            metric.setMetric_name(map.get("metric_name").toString());
            metric.setMetric_info(map.get("metric_info").toString());
            metric.setTime_dimension_id(map.get("time_dimension_id").toString());
            metric.setDataset_id(map.get("dataset_id").toString());
            resultList.add(metric);
        }
        return resultList;
    }

    @Override
    public void deleteMetric(String metricId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(MetricEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(metricId));
        long c = this.milvusService.delete(wrapper);
        this.countCache.decrementMetricCount(dataDomainId, c);
    }

    @Override
    public void updateMetric(MetricEntity updateMetric, String dataDomainId) {
        this.milvusService.upsert((Object)updateMetric, dataDomainId);
    }

    @Override
    public MetricInfoSearchObj queryMetricByName(String metricName, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(MetricEntity.class, dataDomainId);
        wrapper.eq(MetricEntity::getMetric_name, (Object)metricName);
        List resultList = this.milvusService.queryList(wrapper, MetricInfoSearchObj.class);
        if (resultList.isEmpty()) {
            return null;
        }
        return (MetricInfoSearchObj)resultList.get(0);
    }

    @Override
    public MetricEntity queryVMetric(String metricId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(MetricEntity.class, dataDomainId);
        wrapper.ids(Collections.singletonList(metricId)).queryVector(true);
        List rList = this.milvusService.queryList(wrapper);
        if (rList.isEmpty()) {
            return null;
        }
        return (MetricEntity)rList.get(0);
    }

    @Override
    public void insertMetric(MetricEntity metricEntity, String dataDomainId) {
        long c = this.milvusService.insert((Object)metricEntity, dataDomainId);
        this.countCache.incrementMetricCount(dataDomainId, c);
    }

    @Override
    public List<FieldInfoSearchObj> queryStringFieldListByDatasetIds(List<String> datasetIds, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(FieldEntity.class, dataDomainId);
        wrapper.eq(FieldEntity::getField_type, (Object)"string").in(FieldEntity::getDataset_id, datasetIds);
        return this.milvusService.queryList(wrapper, FieldInfoSearchObj.class);
    }

    @Override
    public List<FieldInfoSearchObj> queryFieldListByIdList(List<String> fieldIds, String dataDomainId) {
        ArrayList<String> idObjs = new ArrayList<String>(fieldIds);
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(FieldEntity.class, dataDomainId);
        wrapper.ids(idObjs);
        return this.milvusService.queryList(wrapper, FieldInfoSearchObj.class);
    }

    @Override
    public List<FieldInfoSearchObj> fieldList(String dataDomainId) {
        MilvusSearchWrapper wrapper = new MilvusSearchWrapper(FieldEntity.class, dataDomainId);
        wrapper.eq(FieldEntity::getField_id, (Object)"-1");
        return this.milvusService.queryList((MilvusQueryWrapper)wrapper, FieldInfoSearchObj.class);
    }

    @Override
    public List<FieldInfoSearchObj> searchFieldList(String searchType, int topK, int bm25TopK, Map<String, Object> searchParams, Map<String, Object> bm25Params, TextVector textVector, String dataDomainId, List<String> datasetIds, String dateDimensionId) {
        ArrayList<Map<String, Object>> denseResults = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> bm25Results = new ArrayList<Map<String, Object>>();
        CompletableFuture<List> denseFuture = null;
        CompletableFuture<List> bm25Future = null;
        if ("dense".equals(searchType) || "hybrid".equals(searchType)) {
            denseFuture = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(FieldEntity.class, dataDomainId);
                wrapper.annsField(FieldEntity::getField_comment_dense_vector).topK(topK).data((BaseVector)new FloatVec(textVector.getDenseVector())).searchParams(bm25Params);
                wrapper.in(FieldEntity::getDataset_id, datasetIds);
                if (dateDimensionId != null && !dateDimensionId.isEmpty()) {
                    wrapper.ne(FieldEntity::getDimension_id, (Object)dateDimensionId);
                }
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        if ("bm25".equals(searchType) || "hybrid".equals(searchType)) {
            bm25Future = CompletableFuture.supplyAsync(() -> {
                MilvusSearchWrapper wrapper = new MilvusSearchWrapper(FieldEntity.class, dataDomainId);
                wrapper.annsField(FieldEntity::getField_comment).topK(bm25TopK).data((BaseVector)new EmbeddedText(textVector.getText())).searchParams(bm25Params);
                wrapper.in(FieldEntity::getDataset_id, datasetIds);
                if (dateDimensionId != null && !dateDimensionId.isEmpty()) {
                    wrapper.ne(FieldEntity::getDimension_id, (Object)dateDimensionId);
                }
                return this.milvusService.searchMap(wrapper);
            }, executor);
        }
        ArrayList<CompletableFuture<List>> all = new ArrayList<CompletableFuture<List>>();
        if (denseFuture != null) {
            all.add(denseFuture);
        }
        if (bm25Future != null) {
            all.add(bm25Future);
        }
        CompletableFuture.allOf(all.toArray(new CompletableFuture[0])).join();
        if (denseFuture != null) {
            denseResults.addAll(denseFuture.join());
        }
        if (bm25Future != null) {
            bm25Results.addAll(bm25Future.join());
        }
        List<Object> data = new ArrayList<Map<String, Object>>();
        if ("hybrid".equals(searchType)) {
            data = this.sortHybridResults(denseResults, bm25Results, "field_id");
        } else {
            data.addAll(denseResults);
            data.addAll(bm25Results);
        }
        ArrayList<FieldInfoSearchObj> fieldInfoSearchObjs = new ArrayList<FieldInfoSearchObj>();
        for (Map map : data) {
            FieldInfoSearchObj fieldInfoSearchObj = new FieldInfoSearchObj();
            fieldInfoSearchObj.setField_id(map.get("field_id").toString());
            fieldInfoSearchObj.setDimension_id(map.get("dimension_id").toString());
            fieldInfoSearchObj.setDataset_id(map.get("dataset_id").toString());
            fieldInfoSearchObj.setField_comment(map.get("field_comment").toString());
            fieldInfoSearchObj.setField_type(map.get("field_type").toString());
            fieldInfoSearchObjs.add(fieldInfoSearchObj);
        }
        return fieldInfoSearchObjs;
    }

    @Override
    public List<String> queryFieldIdsByDatasetId(String datasetId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(FieldEntity.class, datasetId);
        wrapper.eq(FieldEntity::getDataset_id, (Object)datasetId);
        wrapper.outputFields(new MSFunction[]{FieldEntity::getField_id});
        List r = this.milvusService.queryMapList(wrapper);
        return r.stream().map(map -> map.get("field_id").toString()).collect(Collectors.toList());
    }

    @Override
    public void insertFieldList(List<FieldEntity> fieldEntities, String dataDomainId) {
        this.milvusService.insertBatch(fieldEntities, dataDomainId);
    }

    @Override
    public void updateFieldList(List<FieldEntity> fieldEntities, String dataDomainId) {
        this.milvusService.upsertBatch(fieldEntities, dataDomainId);
    }

    @Override
    public void deleteFieldAndValue(List<String> fieldIds, String dataDomainId) {
        if (fieldIds == null || fieldIds.isEmpty()) {
            return;
        }
        ArrayList<String> objFieldsToDelete = new ArrayList<String>(fieldIds);
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(FieldEntity.class, dataDomainId);
        wrapper.ids(objFieldsToDelete);
        this.milvusService.delete(wrapper);
        MilvusQueryWrapper valueWrapper = new MilvusQueryWrapper(DimensionValueEntity.class, dataDomainId);
        valueWrapper.in(DimensionValueEntity::getField_id, fieldIds);
        this.milvusService.delete(valueWrapper);
    }

    @Override
    public List<FieldEntity> queryVFieldListByDatasetId(String datasetId, String dataDomainId) {
        MilvusQueryWrapper wrapper = new MilvusQueryWrapper(FieldEntity.class, dataDomainId);
        wrapper.eq(FieldEntity::getDataset_id, (Object)datasetId).queryVector(true);
        return this.milvusService.queryList(wrapper);
    }

    @Override
    public void dropAllCollections(String dataDomainId) {
        this.milvusService.dropCollection(MetricEntity.class, dataDomainId);
        logger.info("\u6307\u6807\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(FieldEntity.class, dataDomainId);
        logger.info("\u5b57\u6bb5\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(DimensionEntity.class, dataDomainId);
        logger.info("\u7ef4\u5ea6\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(DimensionValueEntity.class, dataDomainId);
        logger.info("\u7ef4\u5ea6\u503c\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(QaEntity.class, dataDomainId);
        logger.info("\u95ee\u7b54\u793a\u4f8b\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(TermEntity.class, dataDomainId);
        logger.info("\u672f\u8bed\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.milvusService.dropCollection(DatasetEntity.class, dataDomainId);
        logger.info("\u6570\u636e\u96c6\u96c6\u5408\u5df2\u7ecf\u5220\u9664\uff0cdataDomainId={}", (Object)dataDomainId);
        this.countCache.remove(dataDomainId);
    }

    @Override
    public void initCollection(String dataDomainId) {
        try {
            this.milvusService.createCollection(MetricEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u6307\u6807\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(FieldEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u5b57\u6bb5\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(DimensionEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u7ef4\u5ea6\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(DimensionValueEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u7ef4\u5ea6\u503c\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(QaEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u95ee\u7b54\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(TermEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u672f\u8bed\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.milvusService.createCollection(DatasetEntity.class, dataDomainId);
            logger.info("Milvus\uff0c\u6570\u636e\u96c6\u96c6\u5408\u521b\u5efa\u6210\u529f\uff01");
            this.countCache.init(dataDomainId);
        }
        catch (Exception e) {
            logger.error("\u6307\u6807\u5e73\u53f0\u96c6\u5408\u521d\u59cb\u5316\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            throw new HussarException("\u6307\u6807\u5e73\u53f0\u96c6\u5408\u521d\u59cb\u5316\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<Map<String, Object>> queryCollectionData(QueryCollectionData queryCollectionData) {
        return this.milvusService.queryCollectionData(queryCollectionData);
    }
}

