/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.qa.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.dataManager41.dto.AiDataSourceDto;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceService;
import com.jxdinfo.hussar.ai.qa.service.IntelligentInterfaceService;
import com.jxdinfo.hussar.ai.qa.service.IntelligentQuestionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.support.exception.HussarException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u667a\u80fd\u95ee\u7b54\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/intelligentInterface"})
public class IntelligentInterfaceController {
    private Logger log = LoggerFactory.getLogger(IntelligentInterfaceController.class);
    @Resource
    private IScenarioService scenarioService;
    @Resource
    private AiDatasourceService aiDatasourceService;
    @Resource
    private IntelligentInterfaceService intelligentInterfaceService;
    @Resource
    private IntelligentQuestionService intelligentQuestionService;

    @GetMapping(value={"/getAnswer"})
    @ApiOperation(value="\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u7b54\u6848", notes="\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u7b54\u6848")
    public ApiResponse<Map<String, Object>> getAnswer(String question, String sql, Page page, Long scenarioId) {
        QaScenarioModel detail = this.scenarioService.getDetail(scenarioId);
        HussarException.throwBy((boolean)HussarUtils.equals((Object)"1", (Object)detail.getDelFlag()), (String)"\u8be5\u5e94\u7528\u4e0d\u53ef\u7528");
        Long dataSourceId = (Long)detail.getDataSourceId().get(0);
        AiDataSourceDto dataSourceDto = this.aiDatasourceService.getDataSourceById(dataSourceId);
        Map<String, Object> answer = this.intelligentInterfaceService.getAnswer(question, sql, page, dataSourceDto.getConnName(), detail.getModelUrl(), dataSourceId);
        if (this.intelligentQuestionService.saveQuestion(question, answer.get("data"), answer.get("sqlResult"))) {
            answer.put("msg", "\u4fdd\u5b58\u6210\u529f");
        } else {
            answer.put("msg", "\u4fdd\u5b58\u5931\u8d25");
        }
        return ApiResponse.success(answer);
    }

    @GetMapping(value={"/getSql"})
    @ApiOperation(value="\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u7b54\u6848sql", notes="\u83b7\u53d6\u667a\u80fd\u95ee\u7b54\u7b54\u6848sql")
    public ApiResponse<String> getSql(String question) {
        this.log.info("\u95ee\u9898======>" + question);
        long stime = System.currentTimeMillis();
        String sql = this.intelligentInterfaceService.getSql(question);
        long endTime = System.currentTimeMillis();
        this.log.info("getSql\u603b\u8017\u65f6======>" + (endTime - stime));
        return ApiResponse.success((Object)sql, (String)"\u67e5\u8be2\u6210\u529f");
    }
}

