/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.datamanager.dao.QADateBaseContentMapper;
import com.jxdinfo.hussar.ai.datamanager.dto.QADateBaseContentDto;
import com.jxdinfo.hussar.ai.datamanager.model.QAColumn;
import com.jxdinfo.hussar.ai.datamanager.model.QADatasource;
import com.jxdinfo.hussar.ai.datamanager.model.QADateBaseContent;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.service.QAColumnService;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.datamanager.service.QADateBaseContentService;
import com.jxdinfo.hussar.ai.datamanager.service.QATableService;
import com.jxdinfo.hussar.ai.datamanager.vo.DataGroupVO;
import com.jxdinfo.hussar.ai.datamanager.vo.DataItemVO;
import com.jxdinfo.hussar.ai.datamanager.vo.QADateBaseContentVO;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QADocumentKnowledge;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.IDocKnowledgeBaseService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QADateBaseContentServiceImpl
extends ServiceImpl<QADateBaseContentMapper, QADateBaseContent>
implements QADateBaseContentService {
    @Resource
    private QADatasourceService QADatasourceService;
    @Resource
    private QAColumnService columnService;
    @Resource
    private QATableService qaTableService;
    @Resource
    private QADateBaseContentMapper dateBaseContentMapper;
    @Resource
    private IDocKnowledgeBaseService docKnowledgeBaseService;

    @Override
    public IPage<QADateBaseContentVO> listQaDateBaseContent(Page<QADateBaseContent> page, QADateBaseContent qaDateBaseContent) {
        if (HussarUtils.isNotEmpty(page) && HussarUtils.isNotEmpty((Object)((Object)qaDateBaseContent))) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.like(HussarUtils.isNotEmpty((Object)qaDateBaseContent.getDbcName()), QADateBaseContent::getDbcName, (Object)qaDateBaseContent.getDbcName());
            queryWrapper.eq(HussarUtils.isNotEmpty((Object)qaDateBaseContent.getDbcCheckResult()), QADateBaseContent::getDbcCheckResult, (Object)qaDateBaseContent.getDbcCheckResult());
            queryWrapper.eq(HussarUtils.isNotEmpty((Object)qaDateBaseContent.getDbcSourceId()), QADateBaseContent::getDbcSourceId, (Object)qaDateBaseContent.getDbcSourceId());
            queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
            Page baseContentPage = (Page)this.page((IPage)page, (Wrapper)queryWrapper);
            Page aiDateBaseContentVoPage = new Page();
            BeanUtil.copy((Object)baseContentPage, (Object)aiDateBaseContentVoPage);
            List records = baseContentPage.getRecords();
            List voPageRecords = BeanUtil.copyToList((Collection)records, QADateBaseContentVO.class);
            voPageRecords.sort(Comparator.comparing(HussarBaseEntity::getCreateTime).reversed());
            aiDateBaseContentVoPage.setRecords(voPageRecords);
            if (HussarUtils.isNotEmpty((Object)records)) {
                List dbcSIds = records.stream().map(QADateBaseContent::getDbcSourceId).collect(Collectors.toList());
                List qaDatasources = this.QADatasourceService.listByIds(dbcSIds);
                Map<Long, String> dbMap = qaDatasources.stream().collect(Collectors.toMap(QADatasource::getDbId, QADatasource::getDbName));
                for (QADateBaseContentVO record : voPageRecords) {
                    record.setDbName(dbMap.get(record.getDbcSourceId()));
                }
            }
            return aiDateBaseContentVoPage;
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    public List<DataGroupVO> findAll() {
        List qaDateBaseContents = this.list();
        ArrayList<DataGroupVO> dataGroupVOs = new ArrayList<DataGroupVO>();
        DataGroupVO qaDateBaseContentVO = new DataGroupVO();
        ArrayList<DataItemVO> qaDateBaseContentItemVOs = new ArrayList<DataItemVO>();
        for (QADateBaseContent qaDateBaseContent : qaDateBaseContents) {
            DataItemVO dataItemVO = new DataItemVO();
            dataItemVO.setDataId(qaDateBaseContent.getDbcId());
            dataItemVO.setDataName(qaDateBaseContent.getDbcName());
            qaDateBaseContentItemVOs.add(dataItemVO);
        }
        qaDateBaseContentVO.setDataList(qaDateBaseContentItemVOs);
        qaDateBaseContentVO.setDataType(QAConstant.TABLE_BASE.getStatus());
        qaDateBaseContentVO.setDataTypeName(QAConstant.TABLE_BASE.getDesc());
        dataGroupVOs.add(qaDateBaseContentVO);
        List docKnowledgeBases = this.docKnowledgeBaseService.list();
        DataGroupVO docKnowledgeBaseVO = new DataGroupVO();
        ArrayList<DataItemVO> docKnowledgeBaseItemVOs = new ArrayList<DataItemVO>();
        for (QADocumentKnowledge docKnowledgeBase : docKnowledgeBases) {
            DataItemVO dataItemVO = new DataItemVO();
            dataItemVO.setDataId(docKnowledgeBase.getId());
            dataItemVO.setDataName(docKnowledgeBase.getName());
            docKnowledgeBaseItemVOs.add(dataItemVO);
        }
        docKnowledgeBaseVO.setDataList(docKnowledgeBaseItemVOs);
        docKnowledgeBaseVO.setDataType(QAConstant.DOC_BASE.getStatus());
        docKnowledgeBaseVO.setDataTypeName(QAConstant.DOC_BASE.getDesc());
        dataGroupVOs.add(docKnowledgeBaseVO);
        return dataGroupVOs;
    }

    @Override
    public Long createQaDateBaseContent(List<MultipartFile> fileList, QADateBaseContentDto contentDto) {
        QADateBaseContent content = new QADateBaseContent();
        content.setDbcName(contentDto.getContentName());
        content.setDbcSourceType("0");
        this.dateBaseContentMapper.insert((Object)content);
        Long dbcId = content.getDbcId();
        try {
            if (!fileList.isEmpty()) {
                for (MultipartFile tempFile : fileList) {
                    if (tempFile.getOriginalFilename() != null && (tempFile.getOriginalFilename().endsWith(".csv") || tempFile.getOriginalFilename().endsWith(".CSV"))) {
                        this.columnService.dealCSV(tempFile, contentDto, dbcId);
                        continue;
                    }
                    if (tempFile.getOriginalFilename() != null && (tempFile.getOriginalFilename().endsWith(".xlsx") || tempFile.getOriginalFilename().endsWith(".xls"))) {
                        this.columnService.dealExcel(tempFile, contentDto, dbcId);
                        continue;
                    }
                    return 0L;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dateBaseContentMapper.deleteById(dbcId);
            return 0L;
        }
        return dbcId;
    }

    @Override
    public Boolean removeDateBaseContentByIds(List<String> ids) {
        HussarException.throwByNull(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u9879");
        LambdaQueryWrapper qaTableLambdaQueryWrapper = new LambdaQueryWrapper();
        qaTableLambdaQueryWrapper.in(QATable::getDbcId, ids);
        List qaTableList = this.qaTableService.list((Wrapper)qaTableLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)qaTableList)) {
            List tableIds = qaTableList.stream().map(QATable::getTableId).collect(Collectors.toList());
            LambdaQueryWrapper qaColumnLambdaQueryWrapper = new LambdaQueryWrapper();
            qaColumnLambdaQueryWrapper.in(QAColumn::getTableId, tableIds);
            this.columnService.remove((Wrapper)qaColumnLambdaQueryWrapper);
            this.qaTableService.remove((Wrapper)qaTableLambdaQueryWrapper);
        }
        this.removeByIds(ids);
        return true;
    }
}

