/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.qaGroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.qaGroup.dao.QAGroupBaseMapper;
import com.jxdinfo.hussar.ai.qaGroup.dao.QAGroupPairMapper;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupBase;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupPair;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupBaseService;
import com.jxdinfo.hussar.ai.qaGroup.vo.EntityExpandVo;
import com.jxdinfo.hussar.ai.qaGroup.vo.QAGroupBaseVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class QAGroupBaseServiceImpl
extends ServiceImpl<QAGroupBaseMapper, QAGroupBase>
implements IQAGroupBaseService {
    @Resource
    private QAGroupBaseMapper qaGroupBaseMapper;
    @Resource
    private QAGroupPairMapper qaGroupDetailMapper;

    @Override
    public Map<String, Long> add(QAGroupBase qaGroupBase) {
        HussarException.throwByNull((Object)((Object)qaGroupBase), (String)"\u5165\u53c2\u4e3a\u7a7a");
        HashMap<String, Long> map = new HashMap<String, Long>();
        this.save((Object)qaGroupBase);
        map.put("qaGroupId", qaGroupBase.getQaGroupId());
        return map;
    }

    @Override
    public Page<QAGroupBaseVo> list(Page<QAGroupBase> page, String qaGroupName, String qaGroupType) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.orderByDesc(HussarBaseEntity::getCreateTime);
        if (HussarUtils.isNotEmpty((Object)qaGroupName)) {
            qw.like(QAGroupBase::getQaGroupName, (Object)qaGroupName);
        }
        if (HussarUtils.isNotEmpty((Object)qaGroupType)) {
            qw.eq(QAGroupBase::getQaGroupType, (Object)qaGroupType);
        }
        Page qaGroupBasePage = (Page)this.qaGroupBaseMapper.selectPage((IPage)page, (Wrapper)qw);
        List records = qaGroupBasePage.getRecords();
        Page voPage = new Page();
        voPage.setTotal(qaGroupBasePage.getTotal());
        voPage.setCurrent(qaGroupBasePage.getCurrent());
        voPage.setPages(qaGroupBasePage.getPages());
        voPage.setSize(qaGroupBasePage.getSize());
        if (HussarUtils.isNotEmpty((Object)records)) {
            ArrayList<QAGroupBaseVo> list = new ArrayList<QAGroupBaseVo>();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            for (QAGroupBase qaGroupBase : records) {
                QAGroupBaseVo qaGroupBaseVo = new QAGroupBaseVo();
                BeanUtil.copy((Object)((Object)qaGroupBase), (Object)qaGroupBaseVo);
                queryWrapper.eq(QAGroupPair::getQaGroupId, (Object)qaGroupBase.getQaGroupId());
                Long total = this.qaGroupDetailMapper.selectCount((Wrapper)queryWrapper);
                qaGroupBaseVo.setTotal(total);
                queryWrapper.eq(QAGroupPair::getValidateStatus, (Object)4);
                Long passCount = this.qaGroupDetailMapper.selectCount((Wrapper)queryWrapper);
                if (total != 0L) {
                    BigDecimal bigDecimal = new BigDecimal(passCount).divide(new BigDecimal(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                    BigDecimal passRate = bigDecimal.setScale(2, RoundingMode.HALF_UP);
                    if ("0.00".equals(passRate.toString())) {
                        qaGroupBaseVo.setPassRate("0");
                    } else {
                        qaGroupBaseVo.setPassRate(passRate + "%");
                    }
                } else {
                    qaGroupBaseVo.setPassRate("0");
                }
                list.add(qaGroupBaseVo);
                queryWrapper.clear();
            }
            voPage.setRecords(list);
        }
        return voPage;
    }

    @Override
    public int edit(QAGroupBase qaGroupBase) {
        if (HussarUtils.isEmpty((Object)((Object)qaGroupBase))) {
            throw new HussarException("\u4fee\u6539\u95ee\u7b54\u6570\u636e\u7ec4\u4fe1\u606f\u4e3a\u7a7a");
        }
        QAGroupBase groupBase = (QAGroupBase)((Object)this.qaGroupBaseMapper.selectById(qaGroupBase.getQaGroupId()));
        if (HussarUtils.isEmpty((Object)((Object)groupBase))) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u8be5\u95ee\u7b54\u6570\u636e\u7ec4");
        }
        return this.qaGroupBaseMapper.updateById((Object)qaGroupBase);
    }

    @Override
    public QAGroupBase loadQAgroup(Long qaGroupId) {
        if (HussarUtils.isEmpty((Object)qaGroupId)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a");
        }
        return (QAGroupBase)((Object)this.qaGroupBaseMapper.selectById(qaGroupId));
    }

    @Override
    public Boolean delete(Long qaGroupId) {
        if (HussarUtils.isEmpty((Object)qaGroupId)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a");
        }
        QAGroupBase qaGroupBase = (QAGroupBase)((Object)this.qaGroupBaseMapper.selectById(qaGroupId));
        if (HussarUtils.isEmpty((Object)((Object)qaGroupBase))) {
            throw new HussarException("\u95ee\u7b54\u6570\u636e\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664");
        }
        return this.removeById(qaGroupId);
    }

    @Override
    @HussarTransactional
    public Boolean deleteByIds(List<Long> ids) {
        HussarException.throwByNull(ids, (String)"\u5165\u53c2\u4e3a\u7a7a");
        this.removeByIds(ids);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(QAGroupPair::getQaGroupId, ids);
        this.qaGroupDetailMapper.delete((Wrapper)qw);
        return true;
    }

    @Override
    public QAGroupBase queryQAGroupType(Long qaGroupId) {
        if (HussarUtils.isEmpty((Object)qaGroupId)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a");
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAGroupBase::getQaGroupId, (Object)qaGroupId);
        QAGroupBase groupBase = (QAGroupBase)((Object)this.qaGroupBaseMapper.selectOne((Wrapper)qw));
        return groupBase;
    }

    @Override
    public EntityExpandVo qryExpandRules(Long qaGroupId) {
        EntityExpandVo entityExpandVo = new EntityExpandVo();
        if (HussarUtils.isEmpty((Object)qaGroupId)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a");
        }
        QAGroupBase groupBase = (QAGroupBase)((Object)this.qaGroupBaseMapper.selectById(qaGroupId));
        if (HussarUtils.isNotEmpty((Object)((Object)groupBase))) {
            entityExpandVo.setQaGroupId(qaGroupId);
            entityExpandVo.setEntityExpandRules(groupBase.getEntityExpandRules());
            return entityExpandVo;
        }
        return null;
    }

    @Override
    public List<QAGroupBase> qryQAGroupBytype(String type) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(QAGroupBase::getQaGroupType, (Object)type);
        List qaGroupBases = this.qaGroupBaseMapper.selectList((Wrapper)qw);
        return qaGroupBases;
    }
}

