/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.integration;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.integration.dto.IgAddDialogueQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgAppInfoDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDelDialogueDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDelDialogueQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDialogueCreateDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDialogueDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDialogueQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgFeedbackDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgPageApiResponse;
import com.jxdinfo.hussar.ai.integration.dto.IgSqlQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgStreamQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgUpdateDialogueNameDTO;
import com.jxdinfo.hussar.ai.integration.service.IntegrationService;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/qa_chat/v1"})
@Api(value="qa_chat", tags={"\u4e1a\u52a1\u7cfb\u7edf\u96c6\u6210\u63a5\u53e3"})
public class SystemIntegrationController {
    @Autowired
    private IntegrationService integrationService;

    @GetMapping(value={"get_app_info"})
    public ApiResponse<IgAppInfoDTO> getAppInfo(Long systemId, String userId, String userName) {
        return ApiResponse.success((Object)this.integrationService.getAppInfo(systemId));
    }

    @GetMapping(value={"get_dialogues"})
    public ApiResponse<List<IgDialogueDTO>> getDialogues(Long systemId, String userId, String userName) {
        return ApiResponse.success(this.integrationService.getDialogues(systemId, userId));
    }

    @PostMapping(value={"create_dialogue"})
    public ApiResponse<?> createDialogue(@RequestBody IgDialogueCreateDTO dialogueCreateDTO) {
        return ApiResponse.success((Object)this.integrationService.createDialogue(dialogueCreateDTO));
    }

    @GetMapping(value={"get_dialogue_qa_list"})
    public IgPageApiResponse<IgDialogueQaDTO> getDialogueQaList(Page<DialogueQa> page, Long dialogueId, String userId, String userName) {
        IPage<DialogueQa> dialogueQaList = this.integrationService.getDialogueQaList(page, dialogueId, userId);
        return IgPageApiResponse.fromPage(dialogueQaList, a -> {
            IgDialogueQaDTO igDialogueQaDTO = new IgDialogueQaDTO();
            igDialogueQaDTO.setId(a.getId());
            igDialogueQaDTO.setQaType(a.getQaType());
            igDialogueQaDTO.setQuestions(a.getQuestions());
            igDialogueQaDTO.setAnswers(a.getAnswers());
            igDialogueQaDTO.setIsUseful(a.getIsUseful());
            igDialogueQaDTO.setCreateTime(a.getCreateTime());
            return igDialogueQaDTO;
        });
    }

    @PostMapping(value={"inference"})
    public ApiResponse<Map<String, Object>> inference(@RequestBody IgSqlQaDTO sqlQaDTO) {
        return ApiResponse.success(this.integrationService.inference(sqlQaDTO));
    }

    @PostMapping(value={"knowledge_base_chat"})
    public SseEmitter knowledgeBaseChat(@RequestBody IgStreamQaDTO igStreamQaDTO) {
        return this.integrationService.knowledgeBaseChat(igStreamQaDTO);
    }

    @GetMapping(value={"get_faq_list"})
    public IgPageApiResponse<String> getFaqList(Page<QaFaqModel> page, Long scenarioId, String userId, String userName) {
        IPage<QaFaqModel> faqList = this.integrationService.getFaqList(page, scenarioId);
        return IgPageApiResponse.fromPage(faqList, QaFaqModel::getQuestion);
    }

    @PostMapping(value={"del_dialogue_qa"})
    public ApiResponse<?> delDialogueQa(@RequestBody IgDelDialogueQaDTO igDelDialogueQaDTO) {
        this.integrationService.delDialogueQa(igDelDialogueQaDTO);
        return ApiResponse.success();
    }

    @PostMapping(value={"del_dialogue"})
    public ApiResponse<?> delDialogue(@RequestBody IgDelDialogueDTO igDelDialogueDTO) {
        this.integrationService.delDialogue(igDelDialogueDTO);
        return ApiResponse.success();
    }

    @PostMapping(value={"feedback"})
    public ApiResponse<?> feedback(@RequestBody IgFeedbackDTO igFeedbackDTO) {
        this.integrationService.feedback(igFeedbackDTO);
        return ApiResponse.success();
    }

    @PostMapping(value={"add_dialogue_qa"})
    public ApiResponse<Long> addDialogueQa(@RequestBody IgAddDialogueQaDTO igAddDialogueQaDTO) {
        Long id = this.integrationService.addDialogueQa(igAddDialogueQaDTO);
        return ApiResponse.success((Object)id);
    }

    @PostMapping(value={"update_dialogue_name"})
    public ApiResponse<?> updateDialogueName(@RequestBody IgUpdateDialogueNameDTO igUpdateDialogueNameDTO) {
        this.integrationService.updateDialogueName(igUpdateDialogueNameDTO);
        return ApiResponse.success();
    }
}

