/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.datamanager.common.JsonToPythonLikeString;
import com.jxdinfo.hussar.ai.datamanager.dao.QAColumnMapper;
import com.jxdinfo.hussar.ai.datamanager.dao.QATableMapper;
import com.jxdinfo.hussar.ai.datamanager.dto.QADateBaseContentDto;
import com.jxdinfo.hussar.ai.datamanager.model.QAColumn;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.service.QAColumnService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class QAColumnServiceImpl
extends ServiceImpl<QAColumnMapper, QAColumn>
implements QAColumnService {
    @Resource
    private QATableMapper qaTableMapper;
    @Resource
    private QAColumnMapper columnMapper;
    private static final Logger logger = LoggerFactory.getLogger(QAColumnServiceImpl.class);

    @Override
    public void dealCSV(MultipartFile file, QADateBaseContentDto contentDto, Long dbcId) throws IOException {
        QATable table = new QATable();
        ArrayList<QAColumn> columns = new ArrayList<QAColumn>();
        table.setTableName(file.getOriginalFilename());
        CSVReader csvFile = new CSVReaderBuilder((Reader)new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8))).build();
        Iterator iterator = csvFile.iterator();
        Long tableId = 0L;
        boolean first = true;
        boolean second = true;
        boolean third = true;
        QAColumn secondColumn = new QAColumn();
        while (iterator.hasNext()) {
            String[] line = (String[])iterator.next();
            if (first) {
                if (!(HussarUtils.equals((Object)line[0], (Object)"\u8868\u683c\u63cf\u8ff0\uff08\u4e0b1\uff09\u903b\u8f91\u8868\u540d\uff08\u4e0b2\uff09\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)line[1], (Object)"\u5b57\u6bb5\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)line[2], (Object)"\u540d\u79f0\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)line[3], (Object)"\u7c7b\u578b\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)line[4], (Object)"\u5907\u6ce8\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)line[5], (Object)"\u53ec\u56de\u5173\u952e\u8bcd") && HussarUtils.equals((Object)line[6], (Object)"\u5b57\u5178\uff08\u683c\u5f0f\u8981\u6c42\uff1a{'key1'\uff1a'\u503c1'\uff0c'key2'\uff1a'\u503c2'}\uff09"))) {
                    throw new IOException();
                }
                first = false;
                continue;
            }
            if (second) {
                table.setTableComment(line[0]);
                second = false;
                secondColumn.setColName(line[1]);
                secondColumn.setLogicColName(line[2]);
                secondColumn.setDataType(line[3]);
                secondColumn.setColComment(line[4]);
                secondColumn.setKeyWord(line[5]);
                secondColumn.setDict(JsonToPythonLikeString.convertPythonStringToJson(line[6]));
                continue;
            }
            if (third) {
                table.setLogicTableName(line[0]);
                third = false;
                table.setDbcId(dbcId);
                this.qaTableMapper.insert((Object)table);
                tableId = table.getTableId();
                secondColumn.setTableId(tableId);
                columns.add(secondColumn);
            }
            if (line.length <= 6 || !HussarUtils.isNotEmpty((Object)line[1]) || !HussarUtils.isNotEmpty((Object)line[2]) || !HussarUtils.isNotEmpty((Object)line[3]) || !HussarUtils.isNotEmpty((Object)line[4])) continue;
            QAColumn tempColumn = new QAColumn();
            tempColumn.setColName(line[1]);
            tempColumn.setLogicColName(line[2]);
            tempColumn.setDataType(line[3]);
            tempColumn.setColComment(line[4]);
            tempColumn.setKeyWord(line[5]);
            tempColumn.setDict(JsonToPythonLikeString.convertPythonStringToJson(line[6]));
            tempColumn.setTableId(tableId);
            columns.add(tempColumn);
        }
        if (first || second || third) {
            throw new IOException();
        }
        this.saveBatch(columns);
    }

    @Override
    public void dealExcel(MultipartFile file, QADateBaseContentDto contentDto, Long dbcId) throws IOException {
        HSSFWorkbook wk = null;
        if (file.getOriginalFilename() != null) {
            if (file.getOriginalFilename().endsWith(".xls")) {
                wk = new HSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
            } else if (file.getOriginalFilename().endsWith(".xlsx")) {
                wk = new XSSFWorkbook((InputStream)new ByteArrayInputStream(file.getBytes()));
            }
        }
        int sheetNums = 0;
        if (wk != null) {
            sheetNums = wk.getNumberOfSheets();
        }
        for (int i = 0; i < sheetNums; ++i) {
            QATable table = new QATable();
            ArrayList<QAColumn> columns = new ArrayList<QAColumn>();
            QAColumn secondColumn = new QAColumn();
            Sheet sheet = wk.getSheetAt(i);
            if (sheet.getLastRowNum() < 2) {
                throw new IOException();
            }
            table.setTableName(wk.getSheetName(i));
            Long tableId = 0L;
            boolean first = true;
            boolean second = true;
            boolean third = true;
            for (Row row : sheet) {
                if (first) {
                    if (!(HussarUtils.equals((Object)row.getCell(0).getStringCellValue(), (Object)"\u8868\u683c\u63cf\u8ff0\uff08\u4e0b1\uff09\u903b\u8f91\u8868\u540d\uff08\u4e0b2\uff09\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)row.getCell(1).getStringCellValue(), (Object)"\u5b57\u6bb5\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)row.getCell(2).getStringCellValue(), (Object)"\u540d\u79f0\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)row.getCell(3).getStringCellValue(), (Object)"\u7c7b\u578b\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)row.getCell(4).getStringCellValue(), (Object)"\u5907\u6ce8\uff08\u5fc5\u586b\uff09") && HussarUtils.equals((Object)row.getCell(5).getStringCellValue(), (Object)"\u53ec\u56de\u5173\u952e\u8bcd") && HussarUtils.equals((Object)row.getCell(6).getStringCellValue(), (Object)"\u5b57\u5178\uff08\u683c\u5f0f\u8981\u6c42\uff1a{'key1'\uff1a'\u503c1'\uff0c'key2'\uff1a'\u503c2'}\uff09"))) {
                        throw new IOException();
                    }
                    first = false;
                    continue;
                }
                if (second) {
                    table.setTableComment(HussarUtils.isNotEmpty((Object)row.getCell(0)) ? row.getCell(0).getStringCellValue() : null);
                    second = false;
                    if (!HussarUtils.isNotEmpty((Object)row.getCell(1)) || !HussarUtils.isNotEmpty((Object)row.getCell(2)) || !HussarUtils.isNotEmpty((Object)row.getCell(3)) || !HussarUtils.isNotEmpty((Object)row.getCell(4))) continue;
                    secondColumn.setColName(row.getCell(1).getStringCellValue());
                    secondColumn.setLogicColName(row.getCell(2).getStringCellValue());
                    secondColumn.setDataType(row.getCell(3).getStringCellValue());
                    secondColumn.setColComment(row.getCell(4).getStringCellValue());
                    secondColumn.setKeyWord(HussarUtils.isNotEmpty((Object)row.getCell(5)) ? row.getCell(5).getStringCellValue() : null);
                    secondColumn.setDict(HussarUtils.isNotEmpty((Object)row.getCell(6)) ? JsonToPythonLikeString.convertPythonStringToJson(row.getCell(6).getStringCellValue()) : null);
                    continue;
                }
                if (third) {
                    table.setLogicTableName(HussarUtils.isNotEmpty((Object)row.getCell(0)) ? row.getCell(0).getStringCellValue() : null);
                    table.setDbcId(dbcId);
                    third = false;
                    this.qaTableMapper.insert((Object)table);
                    tableId = table.getTableId();
                    if (HussarUtils.isNotEmpty((Object)secondColumn.getColName())) {
                        secondColumn.setTableId(tableId);
                        columns.add(secondColumn);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)row.getCell(1)) || !HussarUtils.isNotEmpty((Object)row.getCell(2)) || !HussarUtils.isNotEmpty((Object)row.getCell(3)) || !HussarUtils.isNotEmpty((Object)row.getCell(4))) continue;
                QAColumn tempColumn = new QAColumn();
                tempColumn.setColName(row.getCell(1).getStringCellValue());
                tempColumn.setLogicColName(row.getCell(2).getStringCellValue());
                tempColumn.setDataType(row.getCell(3).getStringCellValue());
                tempColumn.setColComment(row.getCell(4).getStringCellValue());
                tempColumn.setKeyWord(HussarUtils.isNotEmpty((Object)row.getCell(5)) ? row.getCell(5).getStringCellValue() : null);
                tempColumn.setDict(HussarUtils.isNotEmpty((Object)row.getCell(6)) ? JsonToPythonLikeString.convertPythonStringToJson(row.getCell(6).getStringCellValue()) : null);
                tempColumn.setTableId(tableId);
                columns.add(tempColumn);
            }
            table.setFields(columns);
            this.saveBatch(columns);
        }
    }

    @Override
    public List<QAColumn> getListByTableId(Long tableId) {
        LambdaQueryWrapper columnWrapper = new LambdaQueryWrapper();
        columnWrapper.eq(QAColumn::getTableId, (Object)tableId);
        return this.columnMapper.selectList((Wrapper)columnWrapper);
    }
}

