/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.ai.datamanager.common.JsonToPythonLikeString;
import com.jxdinfo.hussar.ai.datamanager.dao.QAColumnMapper;
import com.jxdinfo.hussar.ai.datamanager.dao.QADateBaseContentMapper;
import com.jxdinfo.hussar.ai.datamanager.dao.QATableMapper;
import com.jxdinfo.hussar.ai.datamanager.model.QAColumn;
import com.jxdinfo.hussar.ai.datamanager.model.QADateBaseContent;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentExcelQuery;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentModelQuery;
import com.opencsv.CSVWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataBaseContentFileUtil {
    @Resource
    private QATableMapper tableMapper;
    @Resource
    private QAColumnMapper columnMapper;
    @Resource
    private QADateBaseContentMapper baseContentMapper;
    private static final Logger logger = LoggerFactory.getLogger(DataBaseContentFileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadModel(HttpServletResponse response, DataBaseContentModelQuery query) {
        String type = query.getType();
        String fileName = type.equals("csv") ? "QaColumnModel.csv" : "QaColumnModel.xlsx";
        InputStream inputStream = null;
        ServletOutputStream servletOutputStream = null;
        try {
            inputStream = this.getClass().getClassLoader().getResourceAsStream("modelFile/" + fileName);
            if (inputStream != null) {
                response.setContentType("application/octet-stream");
                response.setHeader("Content-disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, "UTF-8") + "\"");
                response.setStatus(200);
                servletOutputStream = response.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)servletOutputStream);
                servletOutputStream.flush();
            } else {
                response.sendError(500, "\u6587\u4ef6\u4e3a\u7a7a\u6216\u5df2\u635f\u574f");
            }
        }
        catch (IOException e) {
            logger.error(type + "\u6587\u4ef6\u6a21\u677f\u4e0b\u8f7d\u51fa\u9519");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (servletOutputStream != null) {
                    servletOutputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadExcel(HttpServletResponse response, DataBaseContentExcelQuery query) {
        Long dbcId = query.getDbcId();
        QADateBaseContent content = (QADateBaseContent)((Object)this.baseContentMapper.selectById(dbcId));
        OutputStream outputStream = null;
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            LambdaQueryWrapper tableWrapper = new LambdaQueryWrapper();
            tableWrapper.eq(QATable::getDbcId, (Object)dbcId);
            List tableList = this.tableMapper.selectList((Wrapper)tableWrapper);
            for (QATable table : tableList) {
                LambdaQueryWrapper columnWrapper = new LambdaQueryWrapper();
                columnWrapper.eq(QAColumn::getTableId, (Object)table.getTableId());
                List columns = this.columnMapper.selectList((Wrapper)columnWrapper);
                Sheet sheet = workbook.createSheet(table.getTableName());
                for (int j = -1; j < columns.size(); ++j) {
                    Cell cell0;
                    Row row = sheet.createRow(j + 1);
                    Cell cell1 = row.createCell(1);
                    Cell cell2 = row.createCell(2);
                    Cell cell3 = row.createCell(3);
                    Cell cell4 = row.createCell(4);
                    Cell cell5 = row.createCell(5);
                    Cell cell6 = row.createCell(6);
                    if (j == -1) {
                        Cell cell02 = row.createCell(0);
                        cell02.setCellValue("\u8868\u683c\u63cf\u8ff0\uff08\u4e0b1\uff09\u903b\u8f91\u8868\u540d\uff08\u4e0b2\uff09\uff08\u5fc5\u586b\uff09");
                        cell1.setCellValue("\u5b57\u6bb5\uff08\u5fc5\u586b\uff09");
                        cell2.setCellValue("\u540d\u79f0\uff08\u5fc5\u586b\uff09");
                        cell3.setCellValue("\u7c7b\u578b\uff08\u5fc5\u586b\uff09");
                        cell4.setCellValue("\u5907\u6ce8\uff08\u5fc5\u586b\uff09");
                        cell5.setCellValue("\u53ec\u56de\u5173\u952e\u8bcd");
                        cell6.setCellValue("\u5b57\u5178\uff08\u683c\u5f0f\u8981\u6c42\uff1a{'key1'\uff1a'\u503c1'\uff0c'key2'\uff1a'\u503c2'}\uff09");
                        continue;
                    }
                    QAColumn column = (QAColumn)((Object)columns.get(j));
                    if (j == 0) {
                        cell0 = row.createCell(0);
                        cell0.setCellValue(table.getTableComment());
                    } else if (j == 1) {
                        cell0 = row.createCell(0);
                        cell0.setCellValue(table.getLogicTableName());
                    }
                    cell1.setCellValue(column.getColName());
                    cell2.setCellValue(column.getLogicColName());
                    cell3.setCellValue(column.getDataType());
                    cell4.setCellValue(column.getColComment());
                    cell5.setCellValue(column.getKeyWord());
                    cell6.setCellValue(JsonToPythonLikeString.convertJsonToPythonLikeString(column.getDict()));
                }
            }
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=\"" + URLEncoder.encode(content.getDbcName() + ".xlsx", "utf-8") + "\"");
            response.setStatus(200);
            outputStream = response.getOutputStream();
            workbook.write(outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            logger.error("excel\u5bfc\u51fa\u51fa\u9519");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void downloadCSV(HttpServletResponse response, Long dbcId) {
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"multipleCSV.zip\"");
        LambdaQueryWrapper tableWrapper = new LambdaQueryWrapper();
        tableWrapper.eq(QATable::getDbcId, (Object)dbcId);
        List tableList = this.tableMapper.selectList((Wrapper)tableWrapper);
        try (ServletOutputStream outputStream = response.getOutputStream();
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            for (QATable table : tableList) {
                OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);
                Throwable throwable = null;
                try {
                    CSVWriter csvWriter = new CSVWriter((Writer)writer);
                    Throwable throwable2 = null;
                    try {
                        LambdaQueryWrapper columnWrapper = new LambdaQueryWrapper();
                        columnWrapper.eq(QAColumn::getTableId, (Object)table.getTableId());
                        List columns = this.columnMapper.selectList((Wrapper)columnWrapper);
                        for (int j = -1; j < columns.size(); ++j) {
                            String[] texts = new String[5];
                            if (j == -1) {
                                texts[0] = "\u8868\u683c\u63cf\u8ff0";
                                texts[1] = "\u5b57\u6bb5";
                                texts[2] = "\u7c7b\u578b";
                                texts[3] = "\u5907\u6ce8";
                                texts[4] = "\u5b57\u5178";
                                csvWriter.writeNext(texts);
                                continue;
                            }
                            QAColumn column = (QAColumn)((Object)columns.get(j));
                            if (j == 1) {
                                texts[0] = table.getLogicTableName() + table.getTableComment();
                            }
                            texts[1] = column.getLogicColName();
                            texts[2] = column.getDataType();
                            texts[3] = column.getColName() + column.getColComment();
                            texts[4] = JsonToPythonLikeString.convertJsonToPythonLikeString(column.getDict());
                            csvWriter.writeNext(texts);
                        }
                        byte[] csvBytes = byteArrayOutputStream.toByteArray();
                        outputStream.write(csvBytes);
                        outputStream.flush();
                        byteArrayOutputStream.reset();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (csvWriter == null) continue;
                        if (throwable2 != null) {
                            try {
                                csvWriter.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        csvWriter.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            logger.error("CSV\u5bfc\u51fa\u51fa\u9519");
        }
    }
}

