/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.dataManager41.controller;

import com.jxdinfo.hussar.ai.dataManager41.dto.AiDataSourceDto;
import com.jxdinfo.hussar.ai.dataManager41.model.AiTable;
import com.jxdinfo.hussar.ai.dataManager41.service.AiDatasourceService;
import com.jxdinfo.hussar.ai.dataManager41.service.AiTableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.Api;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6570\u636e\u6cbb\u7406\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/dataManage"})
public class AiTableinfoController {
    @Resource
    private AiTableService aiTableService;
    @Resource
    private AiDatasourceService aiDatasourceService;

    @GetMapping(value={"/exportCSV"})
    public ApiResponse<?> exportCSV(HttpServletResponse response, String ids, @RequestParam(value="isUpload", defaultValue="false") Boolean isUpload) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.aiTableService.exportCSV(response, idList, isUpload);
        return ApiResponse.success();
    }

    @PostMapping(value={"/saveOrUpdate"})
    public ApiResponse<?> saveOrUpdate(@RequestBody List<AiTable> tableInfos, @RequestParam(value="isUpload", defaultValue="false") Boolean isUpload) {
        this.aiTableService.saveOrUpdate(tableInfos, isUpload);
        return ApiResponse.success();
    }

    @PostMapping(value={"/delete"})
    public ApiResponse<?> delete(@RequestBody List<String> ids) {
        this.aiTableService.delete(ids);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getCusTableInfo"})
    public ApiResponse<?> getCusTableInfo(Long id, String tableName, String tableComment) {
        AiDataSourceDto dataSourceDto = this.aiDatasourceService.getDataSourceById(id);
        return ApiResponse.success(this.aiTableService.getCusTableInfo(dataSourceDto.getInstantName(), dataSourceDto.getDbType(), tableName, tableComment, dataSourceDto.getConnName()));
    }

    @GetMapping(value={"/getAiTable"})
    public ApiResponse<?> getAiTable(Long id) {
        return ApiResponse.success(this.aiTableService.getAiTable(id, null));
    }
}

