/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.ragmanager.service.impl;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.qaGroup.config.ModelConfig;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupBase;
import com.jxdinfo.hussar.ai.qaGroup.model.QAGroupPair;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupBaseService;
import com.jxdinfo.hussar.ai.qaGroup.service.IQAGroupPairService;
import com.jxdinfo.hussar.ai.ragmanager.dao.QARagTaskDetailMapper;
import com.jxdinfo.hussar.ai.ragmanager.dao.QARagTaskMapper;
import com.jxdinfo.hussar.ai.ragmanager.dto.CompleteRagTest;
import com.jxdinfo.hussar.ai.ragmanager.dto.CompletionRate;
import com.jxdinfo.hussar.ai.ragmanager.dto.ModelDetail;
import com.jxdinfo.hussar.ai.ragmanager.dto.QARagTaskDTO;
import com.jxdinfo.hussar.ai.ragmanager.dto.QARagTaskDetailDTO;
import com.jxdinfo.hussar.ai.ragmanager.dto.TestRagModel;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagModel;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagTask;
import com.jxdinfo.hussar.ai.ragmanager.model.QARagTaskDetail;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagModelService;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagTaskDetailService;
import com.jxdinfo.hussar.ai.ragmanager.service.QARagTaskService;
import com.jxdinfo.hussar.ai.ragmanager.vo.QARagTaskVO;
import com.jxdinfo.hussar.ai.util.YamlUtil;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.util.IqaHttpClientUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class QARagTaskServiceImpl
extends ServiceImpl<QARagTaskMapper, QARagTask>
implements QARagTaskService {
    @Resource
    private IQAGroupBaseService qaGroupBaseService;
    @Resource
    private QARagTaskDetailMapper qaRagTaskDetailMapper;
    @Resource
    @Lazy
    private QARagTaskDetailService qaRagTaskDetailService;
    @Resource
    private QARagModelService qaRagModelService;
    @Resource
    private IQAGroupPairService iqaGroupPairService;
    @Resource
    private ModelConfig modelConfig;
    private static final Logger logger = LoggerFactory.getLogger(QARagTaskServiceImpl.class);

    @Override
    public IPage<QARagTaskVO> listQaRagTask(Page<QARagTask> page, QARagTaskDTO model) {
        if (HussarUtils.isNotEmpty(page) && HussarUtils.isNotEmpty((Object)model) && HussarUtils.isNotEmpty((Object)model.getModelId())) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date start = null;
            Date end = null;
            try {
                start = HussarUtils.isNotEmpty((Object)model.getStartTime()) ? formatter.parse(model.getStartTime()) : null;
                end = HussarUtils.isNotEmpty((Object)model.getEndTime()) ? formatter.parse(model.getEndTime()) : null;
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            LambdaQueryWrapper taskLambdaQueryWrapper = new LambdaQueryWrapper();
            taskLambdaQueryWrapper.eq(QARagTask::getModelId, (Object)model.getModelId());
            taskLambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)model.getTaskStatus()), QARagTask::getTaskStatus, (Object)model.getTaskStatus());
            taskLambdaQueryWrapper.ge(HussarUtils.isNotEmpty((Object)model.getStartTime()), HussarBaseEntity::getCreateTime, (Object)start);
            taskLambdaQueryWrapper.le(HussarUtils.isNotEmpty((Object)model.getEndTime()), HussarBaseEntity::getCreateTime, (Object)end);
            taskLambdaQueryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
            Page ragTaskPage = (Page)this.page((IPage)page, (Wrapper)taskLambdaQueryWrapper);
            Page qaRagTaskVoPage = new Page();
            BeanUtil.copy((Object)ragTaskPage, (Object)qaRagTaskVoPage);
            List records = ragTaskPage.getRecords();
            if (HussarUtils.isNotEmpty((Object)records)) {
                List QARagTaskVOs = BeanUtil.copyToList((Collection)records, QARagTaskVO.class);
                List qaGroupIds = records.stream().map(QARagTask::getQaGroupId).collect(Collectors.toList());
                LambdaQueryWrapper groupBaseLambdaQueryWrapper = new LambdaQueryWrapper();
                groupBaseLambdaQueryWrapper.in(QAGroupBase::getQaGroupId, qaGroupIds);
                List groupBaseList = this.qaGroupBaseService.list((Wrapper)groupBaseLambdaQueryWrapper);
                Map<Long, String> qaGroupBaseMap = groupBaseList.stream().collect(Collectors.toMap(QAGroupBase::getQaGroupId, QAGroupBase::getQaGroupName));
                List<CompletionRate> completionRates = this.qaRagTaskDetailMapper.getCompletionRate(records.stream().map(QARagTask::getTaskId).collect(Collectors.toList()));
                Map<Long, Double> completionRateMap = completionRates.stream().collect(Collectors.toMap(CompletionRate::getTaskId, CompletionRate::getPercentage));
                for (QARagTaskVO qaRagTaskVO : QARagTaskVOs) {
                    qaRagTaskVO.setQaGroupName(qaGroupBaseMap.get(qaRagTaskVO.getQaGroupId()));
                    if (!HussarUtils.isNotEmpty(completionRateMap) || !completionRateMap.containsKey(qaRagTaskVO.getTaskId()) || HussarUtils.equals((Object)"1", (Object)qaRagTaskVO.getTaskStatus()) || HussarUtils.equals((Object)"0", (Object)qaRagTaskVO.getTaskStatus())) continue;
                    qaRagTaskVO.setSearchResult("\u901a\u8fc7\u7387" + completionRateMap.get(qaRagTaskVO.getTaskId()) + "%");
                }
                QARagTaskVOs.sort(Comparator.comparing(HussarBaseEntity::getCreateTime).reversed());
                qaRagTaskVoPage.setRecords(QARagTaskVOs);
            }
            return qaRagTaskVoPage;
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    @Async(value="ragTaskExecutor")
    public void testRagModel(Long ragTaskId) {
        QARagTask qaRagTask = (QARagTask)((Object)this.getById(ragTaskId));
        QARagModel ragModel = (QARagModel)((Object)this.qaRagModelService.getById(qaRagTask.getModelId()));
        qaRagTask.setModelArg(ragModel.getModelArg());
        this.updateById((Object)qaRagTask);
        TestRagModel testRagModel = new TestRagModel();
        testRagModel.setModelType(ragModel.getModelType());
        testRagModel.setRagTestId(ragTaskId);
        testRagModel.setNowledgeBaseId(String.valueOf(qaRagTask.getModelId()));
        testRagModel.setModelArg(JSONObject.parseObject((String)JSON.toJSONString(YamlUtil.transferToMap(ragModel.getModelArg()))));
        LambdaQueryWrapper ragTaskDetailLambdaQueryWrapper = new LambdaQueryWrapper();
        ragTaskDetailLambdaQueryWrapper.eq(QARagTaskDetail::getTaskId, (Object)ragTaskId);
        List ragTaskDetails = this.qaRagTaskDetailMapper.selectList((Wrapper)ragTaskDetailLambdaQueryWrapper);
        List modelDetails = BeanUtil.copyToList((Collection)ragTaskDetails, ModelDetail.class);
        testRagModel.setModelDetails(modelDetails);
        logger.info("testRagModel======\u5f00\u59cb\u8c03\u7528========>" + JSON.toJSONString((Object)testRagModel));
        String result = IqaHttpClientUtil.httpPost((String)this.modelConfig.getTestRagModelUrl(), (String)JSONUtil.toJsonStr((Object)testRagModel), new HashMap());
        logger.info("testRagModel======\u8c03\u7528\u7ed3\u679c========>" + result);
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String status = jsonObject.getString("status");
        String msg = jsonObject.getString("msg");
        if (QAConstant.HTTP_ERROR.getStatus().equals(status) || HussarUtils.isEmpty((Object)status)) {
            this.updateRagTaskStatusById(ragTaskId, QAConstant.RAG_TASK_DO_ERROR.getStatus(), jsonObject.toJSONString());
            HussarException.throwBy((boolean)QAConstant.HTTP_ERROR.getStatus().equals(status), (String)msg);
        }
    }

    @Override
    public void completeRagTest(CompleteRagTest data) {
        List<QARagTaskDetailDTO> ragTaskDetails = data.getModelDetails();
        if (HussarUtils.isEmpty(ragTaskDetails)) {
            return;
        }
        List taskDetails = BeanUtil.copyToList(ragTaskDetails, QARagTaskDetail.class);
        for (QARagTaskDetail qaRagTaskDetail : taskDetails) {
            qaRagTaskDetail.setTaskId(data.getRagTestId());
        }
        this.qaRagTaskDetailService.saveOrUpdateBatch(taskDetails);
    }

    @Override
    public void updateRagTaskStatusById(Long ragTaskId, String status, String reason) {
        LambdaUpdateWrapper ragTaskLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ragTaskLambdaUpdateWrapper.eq(QARagTask::getTaskId, (Object)ragTaskId);
        ragTaskLambdaUpdateWrapper.set(QARagTask::getTaskStatus, (Object)status);
        ragTaskLambdaUpdateWrapper.set(HussarUtils.isNotEmpty((Object)reason), QARagTask::getErrorReason, (Object)reason);
        this.update((Wrapper)ragTaskLambdaUpdateWrapper);
    }

    @Override
    public void saveOrUpdateQARagTask(QARagTask qaRagTask) {
        this.saveOrUpdate((Object)qaRagTask);
        if (HussarUtils.isNotEmpty((Object)qaRagTask.getModelArg()) && HussarUtils.isNotEmpty((Object)qaRagTask.getModelId())) {
            LambdaUpdateWrapper ragModelLambdaUpdateWrapper = new LambdaUpdateWrapper();
            ragModelLambdaUpdateWrapper.eq(QARagModel::getModelId, (Object)qaRagTask.getModelId());
            ragModelLambdaUpdateWrapper.set(QARagModel::getModelArg, (Object)qaRagTask.getModelArg());
            this.qaRagModelService.update((Wrapper)ragModelLambdaUpdateWrapper);
        }
        Long qaGroupId = qaRagTask.getQaGroupId();
        LambdaQueryWrapper qaGroupPairLambdaQueryWrapper = new LambdaQueryWrapper();
        qaGroupPairLambdaQueryWrapper.eq(QAGroupPair::getQaGroupId, (Object)qaGroupId);
        List qaGroupPairs = this.iqaGroupPairService.list((Wrapper)qaGroupPairLambdaQueryWrapper);
        ArrayList<QARagTaskDetail> qaRagTaskDetails = new ArrayList<QARagTaskDetail>();
        for (QAGroupPair qaGroupPair : qaGroupPairs) {
            qaRagTaskDetails.add(new QARagTaskDetail(qaRagTask.getTaskId(), qaGroupPair.getAnswer(), qaGroupPair.getQuestion()));
        }
        this.qaRagTaskDetailService.saveBatch(qaRagTaskDetails);
    }

    @Override
    public Boolean removeQARagTask(List<String> ids) {
        LambdaQueryWrapper qaRagTaskDetailLambdaQueryWrapper = new LambdaQueryWrapper();
        qaRagTaskDetailLambdaQueryWrapper.in(QARagTaskDetail::getTaskId, ids);
        this.qaRagTaskDetailMapper.delete((Wrapper)qaRagTaskDetailLambdaQueryWrapper);
        return this.removeByIds(ids);
    }

    @Override
    @Async(value="ragTaskExecutor")
    public void batchTestRagModel(TestRagModel testRagModel) {
        QARagTask qaRagTask = (QARagTask)((Object)this.getById(testRagModel.getRagTestId()));
        QARagModel ragModel = (QARagModel)((Object)this.qaRagModelService.getById(qaRagTask.getModelId()));
        qaRagTask.setModelArg(ragModel.getModelArg());
        this.updateById((Object)qaRagTask);
        testRagModel.setModelType(ragModel.getModelType());
        testRagModel.setNowledgeBaseId(String.valueOf(qaRagTask.getModelId()));
        List<ModelDetail> testRagModelModelDetails = testRagModel.getModelDetails();
        List<ModelDetail> modelDetails = new ArrayList<ModelDetail>();
        if (HussarUtils.isNotEmpty(testRagModelModelDetails)) {
            List detailIds = testRagModelModelDetails.stream().map(ModelDetail::getDetailId).collect(Collectors.toList());
            LambdaQueryWrapper ragTaskDetailLambdaQueryWrapper = new LambdaQueryWrapper();
            ragTaskDetailLambdaQueryWrapper.in(QARagTaskDetail::getDetailId, detailIds);
            List ragTaskDetails = this.qaRagTaskDetailMapper.selectList((Wrapper)ragTaskDetailLambdaQueryWrapper);
            modelDetails = BeanUtil.copyToList((Collection)ragTaskDetails, ModelDetail.class);
        }
        testRagModel.setModelDetails(modelDetails);
        String result = IqaHttpClientUtil.httpPost((String)this.modelConfig.getTestRagModelUrl(), (String)JSONUtil.toJsonStr((Object)testRagModel), new HashMap());
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        String status = jsonObject.getString("status");
        String msg = jsonObject.getString("msg");
        if (QAConstant.HTTP_ERROR.getStatus().equals(status) || HussarUtils.isEmpty((Object)status)) {
            this.updateRagTaskStatusById(testRagModel.getRagTestId(), QAConstant.RAG_TASK_DO_ERROR.getStatus(), jsonObject.toJSONString());
            HussarException.throwBy((boolean)QAConstant.HTTP_ERROR.getStatus().equals(status), (String)msg);
        }
    }
}

