/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.ai.directoryNavigation.constant.DirectoryNavConstant;
import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryBusiness;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryBusinessService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryNodeService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.INavModelService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
@RestController
@RequestMapping(value={"/directoryNav"})
public class DirectoryNavController {
    @Resource
    private IDirectoryService directoryService;
    @Resource
    private IDirectoryNodeService directoryNodeService;
    @Resource
    private IDirectoryBusinessService businessService;
    @Resource
    private INavModelService modelService;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryNavController.class);

    @GetMapping(value={"/list"})
    public ApiResponse<IPage<Directory>> list(Page<Directory> page, String name, String key) {
        return ApiResponse.success(this.directoryService.getDirectoryList(page, name, key));
    }

    @GetMapping(value={"/getTreeByDirectoryId"})
    public ApiResponse<Directory> getDirectoryNodeTreeById(Long directoryId) {
        return ApiResponse.success((Object)((Object)this.directoryService.getDirectoryNodeTreeById(directoryId)));
    }

    @PostMapping(value={"/saveOrUpdateDirectory"})
    public ApiResponse<Directory> saveOrUpdateDirectory(@RequestBody Directory directory) {
        try {
            return ApiResponse.success((Object)((Object)this.directoryService.saveOrUpdateDirectory(directory)));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteDirectories"})
    public ApiResponse<String> deleteDirectories(@RequestBody List<Long> directoryIds) {
        List directories = this.directoryService.listByIds(directoryIds);
        for (Directory directory : directories) {
            logger.info("\u5220\u9664\u76ee\u5f55\uff1a{} {}", (Object)directory.getId(), (Object)directory.getDirectoryName());
            directory.setIsDeleted(DirectoryNavConstant.DELETED.getCode());
        }
        this.directoryService.updateBatchById(directories);
        Thread thread = new Thread(() -> {
            for (Directory directory : directories) {
                this.modelService.uploadKnowledgeBase(directory).subscribe(value -> {}, error -> {
                    directory.setDirectoryStatus(DirectoryNavConstant.UPLOAD_FAILED.getCode());
                    directory.setErrorInfo(error.getMessage());
                    this.directoryService.updateById((Object)directory);
                    logger.error("\u7f6e\u7a7a\u77e5\u8bc6\u5e93\u5931\u8d25", error);
                }, () -> {
                    directory.setDirectoryStatus(DirectoryNavConstant.UPLOADED.getCode());
                    this.directoryService.updateById((Object)directory);
                });
            }
        });
        thread.start();
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/saveOrUpdateNode"})
    public ApiResponse<DirectoryNode> saveOrUpdateNode(@RequestBody DirectoryNode directory) {
        try {
            return ApiResponse.success((Object)((Object)this.directoryNodeService.saveOrUpdateDirectoryNode(directory)));
        }
        catch (Exception e) {
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteNodes"})
    public ApiResponse<?> deleteNodes(@RequestBody List<Long> nodeIds) {
        return ApiResponse.success((Object)this.directoryNodeService.deleteDirectoryNode(nodeIds));
    }

    @PostMapping(value={"/importData"})
    public ApiResponse<?> importData(MultipartFile file, String extractType, Directory directory) {
        try {
            this.directoryService.checkBeforeImportData(file, directory);
            this.directoryService.saveOrUpdate((Object)directory);
            this.directoryService.importDataFromFile(file, extractType == null ? DirectoryNavConstant.EXTRACT_NONE.getCode() : extractType, directory);
            return ApiResponse.success((String)"\u6b63\u5728\u5bfc\u5165");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)("\u5bfc\u5165\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/exportData"})
    public void exportData(HttpServletResponse response, @RequestBody Directory directory) {
        this.directoryService.exportDataToExcel(response, directory.getDirectoryId());
    }

    @PostMapping(value={"/uploadModel"})
    public ApiResponse<?> uploadModel(@RequestBody Directory directory) {
        try {
            this.directoryService.uploadKnowledgeBase(directory.getDirectoryId());
            return ApiResponse.success();
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u77e5\u8bc6\u5e93\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)("\u4e0a\u4f20\u5931\u8d25: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/navTest"})
    public ApiResponse<List<DirectoryNode>> navTest(Long directoryId, String userQuery, Integer resultCount) {
        try {
            return ApiResponse.success(this.directoryService.navTest(directoryId, userQuery, resultCount));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u822a\u6d4b\u8bd5\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)("\u53d1\u751f\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/nav"})
    public ApiResponse<List<String>> nav(String key, String userQuery, Integer resultCount) {
        try {
            return ApiResponse.success(this.directoryService.nav(key, userQuery, resultCount));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u822a\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)("\u53d1\u751f\u5f02\u5e38: " + e.getMessage()));
        }
    }

    @GetMapping(value={"/checkBeforeUpload"})
    public ApiResponse<List<DirectoryNode>> checkNodeKey(Long directoryId) {
        return ApiResponse.success(this.directoryNodeService.checkBeforeUpload(directoryId));
    }

    @GetMapping(value={"/getLeafNodeList"})
    public ApiResponse<List<DirectoryNode>> getLeafNodeList(Long directoryId) {
        return ApiResponse.success(this.directoryNodeService.getLeafNodeList(directoryId));
    }

    @PostMapping(value={"/updateNodes"})
    public ApiResponse<?> updateNodes(@RequestBody List<DirectoryNode> directoryNodes) {
        return ApiResponse.success((Object)this.directoryNodeService.updateBatchById(directoryNodes));
    }

    @PostMapping(value={"/exportLeafNode"})
    public ApiResponse<String> exportLeafNode(HttpServletResponse response, Long directoryId) {
        try {
            this.directoryNodeService.exportLeafNodeToExcel(response, directoryId);
            return ApiResponse.success((String)"\u5bfc\u51fa\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return ApiResponse.fail((String)("\u5bfc\u51fa\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/extractKeywords"})
    public ApiResponse<?> extractKeywords(Long directoryId, String extractType) {
        this.directoryNodeService.extractKeywords(directoryId, extractType);
        return ApiResponse.success();
    }

    @GetMapping(value={"/getBusinessList"})
    public ApiResponse<List<DirectoryBusiness>> getBusinessList(Long directoryId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DirectoryBusiness::getDirectoryId, (Object)directoryId);
        queryWrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.businessService.list((Wrapper)queryWrapper));
    }

    @PostMapping(value={"/addOrUpdateBusiness"})
    public ApiResponse<?> addThesaurus(@RequestBody List<DirectoryBusiness> directoryBusinessList) {
        this.businessService.saveOrUpdateBatch(directoryBusinessList);
        Long directoryId = directoryBusinessList.get(0).getDirectoryId();
        Directory directory = (Directory)((Object)this.directoryService.getById(directoryId));
        if (!DirectoryNavConstant.CHANGED.getCode().equals(directory.getDirectoryStatus()) && !DirectoryNavConstant.WAIT_UPLOAD.getCode().equals(directory.getDirectoryStatus())) {
            directory.setDirectoryStatus(DirectoryNavConstant.CHANGED.getCode());
            this.directoryService.updateById((Object)directory);
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/deleteBusiness"})
    public ApiResponse<?> deleteThesaurus(@RequestBody List<Long> thesaurusIds) {
        DirectoryBusiness business = (DirectoryBusiness)((Object)this.businessService.getById(thesaurusIds.get(0)));
        this.businessService.removeByIds(thesaurusIds);
        Long directoryId = business.getDirectoryId();
        Directory directory = (Directory)((Object)this.directoryService.getById(directoryId));
        if (!DirectoryNavConstant.CHANGED.getCode().equals(directory.getDirectoryStatus()) && !DirectoryNavConstant.WAIT_UPLOAD.getCode().equals(directory.getDirectoryStatus())) {
            directory.setDirectoryStatus(DirectoryNavConstant.CHANGED.getCode());
            this.directoryService.updateById((Object)directory);
        }
        return ApiResponse.success();
    }

    @PostMapping(value={"/extractNodes"})
    public ApiResponse<List<DirectoryNode>> extractNodes(@RequestBody List<DirectoryNode> nodes) {
        return ApiResponse.success(this.directoryNodeService.extractNodes(nodes));
    }

    @PostMapping(value={"/updateFullNamePath"})
    public ApiResponse<?> updateFullNamePath(@RequestBody Long directoryId) {
        this.directoryNodeService.updateFullNamePathByDirectoryId(directoryId);
        return ApiResponse.success();
    }
}

