/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.datamanager.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.common.QAConstant;
import com.jxdinfo.hussar.ai.datamanager.common.AiUtil;
import com.jxdinfo.hussar.ai.datamanager.dao.QAColumnMapper;
import com.jxdinfo.hussar.ai.datamanager.dao.QATableMapper;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.dto.QATableInfoDTO;
import com.jxdinfo.hussar.ai.datamanager.model.QAColumn;
import com.jxdinfo.hussar.ai.datamanager.model.QADateBaseContent;
import com.jxdinfo.hussar.ai.datamanager.model.QATable;
import com.jxdinfo.hussar.ai.datamanager.query.DataBaseContentExcelQuery;
import com.jxdinfo.hussar.ai.datamanager.service.QAColumnService;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.datamanager.service.QADateBaseContentService;
import com.jxdinfo.hussar.ai.datamanager.service.QATableService;
import com.jxdinfo.hussar.ai.datamanager.vo.CheckColumnVO;
import com.jxdinfo.hussar.ai.datamanager.vo.CheckResult;
import com.jxdinfo.hussar.ai.datamanager.vo.CheckTableVO;
import com.jxdinfo.hussar.ai.datamanager.vo.ColumnVO;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.stereotype.Service;

@Service
public class QATableServiceImpl
extends ServiceImpl<QATableMapper, QATable>
implements QATableService {
    @Resource
    private QATableMapper qaTableMapper;
    @Resource
    private QAColumnMapper columnMapper;
    @Resource
    private QAColumnService columnService;
    @Resource
    private QADateBaseContentService qaDateBaseContentService;
    @Resource
    private QADatasourceService QADatasourceService;

    @Override
    public void saveOrUpdate(QATableInfoDTO qaTableInfoDTO) {
        List<QATable> qatableList = qaTableInfoDTO.getQatableList();
        Long dbcId = qaTableInfoDTO.getQaDateBaseContent().getDbcId();
        LambdaQueryWrapper tableLambdaQueryWrapper = new LambdaQueryWrapper();
        tableLambdaQueryWrapper.eq(QATable::getDbcId, (Object)dbcId);
        List qaTableList = this.list((Wrapper)tableLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)qaTableList)) {
            List ids = qaTableList.stream().map(QATable::getTableId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(QAColumn::getTableId, ids);
            this.columnService.remove((Wrapper)queryWrapper);
            this.removeByIds(ids);
        }
        this.qaDateBaseContentService.saveOrUpdate((Object)qaTableInfoDTO.getQaDateBaseContent());
        this.saveBatch(qatableList);
        ArrayList<QAColumn> columns = new ArrayList<QAColumn>();
        for (QATable table : qatableList) {
            for (QAColumn field : table.getFields()) {
                HussarException.throwByNull((Object)field.getColName(), (String)(table.getTableName() + "\u7684\u5b57\u6bb5\u540d\u79f0\u6709\u7a7a\u503c"));
                HussarException.throwByNull((Object)field.getDataType(), (String)(table.getTableName() + "\u7684\u5b57\u6bb5\u7c7b\u578b\u6709\u7a7a\u503c"));
                field.setTableId(table.getTableId());
                columns.add(field);
            }
        }
        this.columnService.saveBatch(columns);
    }

    @Override
    public void exportCSV(HttpServletResponse response, List<String> ids, Boolean isUpload) {
    }

    @Override
    @HussarDs(value="#datasourceKey")
    public List<QATable> getCusTableInfo(String tableSchema, String dbType, String tableName, String logicTableName, String datasourceKey) {
        String tableSql = this.getTableQuery(tableSchema, dbType, tableName, logicTableName, null);
        return this.qaTableMapper.getTableInfo(tableSql);
    }

    @Override
    @HussarDs(value="#datasourceKey")
    public List<QATable> getCusTableAndColumn(String tableSchema, String dbType, List<QATable> tableInfos, String datasourceKey) {
        String columnSql = this.getTableQuery(tableSchema, dbType, null, null, tableInfos);
        List<ColumnVO> columns = this.qaTableMapper.getColumn(columnSql);
        for (QATable tableInfo : tableInfos) {
            ArrayList<QAColumn> columnList = new ArrayList<QAColumn>();
            for (ColumnVO column : columns) {
                if (!HussarUtils.equals((Object)tableInfo.getTableName(), (Object)column.getTableName())) continue;
                columnList.add(column);
            }
            tableInfo.setFields(columnList);
        }
        return tableInfos;
    }

    private String getTableQuery(String tableSchema, String dbType, String tableName, String tableComment, List<QATable> tableInfos) {
        String resourceName = "/TableQuery.json";
        InputStream inputStream = AiUtil.class.getResourceAsStream(resourceName);
        assert (inputStream != null);
        try {
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            JSONObject dbMap = JSON.parseObject((String)string);
            JSONObject sqlMap = JSON.parseObject((String)String.valueOf(dbMap.get(dbType)));
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)sqlMap), (String)"\u5f53\u524d\u6570\u636e\u5e93\u7c7b\u578b\u672a\u505a\u914d\u7f6e");
            if (HussarUtils.isEmpty(tableInfos)) {
                String tableSql = String.valueOf(sqlMap.get("tableSql"));
                if (HussarUtils.isNotEmpty((Object)tableName)) {
                    tableSql = tableSql + "AND TABLE_NAME LIKE '%" + tableName + "%'";
                }
                if (HussarUtils.isNotEmpty((Object)tableComment)) {
                    tableSql = tableSql + "AND LOGIC_TABLE_NAME LIKE '%" + tableComment + "%'";
                }
                return tableSql.replace("${tableSchema}", tableSchema);
            }
            StringBuilder tableNames = new StringBuilder("(");
            for (QATable info : tableInfos) {
                tableNames.append("'").append(info.getTableName()).append("'").append(",");
            }
            tableNames.deleteCharAt(tableNames.length() - 1);
            tableNames.append(")");
            String columnSql = String.valueOf(sqlMap.get("columnSql"));
            columnSql = columnSql.replace("${tableSchema}", tableSchema);
            return columnSql.replace("${tableName}", tableNames);
        }
        catch (IOException var5) {
            throw new RuntimeException(var5);
        }
    }

    @Override
    public List<QATable> getAiTable(Long dataSourceId, List<String> ids, Long dbcId) {
        return this.qaTableMapper.getAiTable(null, null, dbcId);
    }

    @Override
    public List<QATable> getTableListByDbcId(DataBaseContentExcelQuery query) {
        LambdaQueryWrapper tableWrapper = new LambdaQueryWrapper();
        tableWrapper.eq(QATable::getDbcId, (Object)query.getDbcId());
        List tableList = this.qaTableMapper.selectList((Wrapper)tableWrapper);
        if (tableList.size() == 0) {
            return tableList;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (QATable table : tableList) {
            ids.add(table.getTableId());
        }
        LambdaQueryWrapper columnWrapper = new LambdaQueryWrapper();
        columnWrapper.in(QAColumn::getTableId, ids);
        List columns = this.columnMapper.selectList((Wrapper)columnWrapper);
        Map<Long, List<QAColumn>> columnMap = columns.stream().collect(Collectors.groupingBy(QAColumn::getTableId));
        tableList.forEach(a -> {
            Long aTableId = a.getTableId();
            List bList = (List)columnMap.get(aTableId);
            a.setFields(bList);
        });
        return tableList;
    }

    @Override
    public List<CheckTableVO> checkTableInfo(QATableInfoDTO qaTableInfoDTO) {
        List<CheckTableVO> checkTableVOs = new ArrayList();
        List<QATable> nowTableList = qaTableInfoDTO.getQatableList();
        ArrayList<QATable> qaTables = new ArrayList<QATable>();
        QADateBaseContent qaDateBaseContent = qaTableInfoDTO.getQaDateBaseContent();
        QADataSourceDto dataSourceDto = this.QADatasourceService.getDataSourceById(qaDateBaseContent.getDbcSourceId());
        HussarException.throwByNull((Object)((Object)dataSourceDto), (String)"\u6570\u636e\u6e90\u4e0d\u5b58\u5728");
        List<QATable> tableInfo = ((QATableServiceImpl)AopContext.currentProxy()).getCusTableInfo(dataSourceDto.getInstantName(), dataSourceDto.getDbType(), null, null, dataSourceDto.getConnName());
        for (QATable qaTable : nowTableList) {
            for (QATable table : tableInfo) {
                if (!HussarUtils.equals((Object)table.getTableName(), (Object)qaTable.getTableName())) continue;
                qaTables.add((QATable)((Object)BeanUtil.copy((Object)((Object)table), QATable.class)));
            }
        }
        if (HussarUtils.isEmpty(qaTables)) {
            checkTableVOs = BeanUtil.copyToList(nowTableList, CheckTableVO.class);
            for (CheckTableVO checkTableVO : checkTableVOs) {
                HashSet<CheckResult> checkResults = new HashSet<CheckResult>();
                checkResults.add(new CheckResult(QAConstant.TABLE_NAME_MISMATCH.getStatus()));
                checkTableVO.setCheckResults(checkResults);
            }
            return checkTableVOs;
        }
        List<QATable> realTableList = ((QATableServiceImpl)AopContext.currentProxy()).getCusTableAndColumn(dataSourceDto.getInstantName(), dataSourceDto.getDbType(), qaTables, dataSourceDto.getConnName());
        for (QATable nowTable : nowTableList) {
            CheckTableVO checkTableVO = new CheckTableVO();
            BeanUtil.copy((Object)((Object)nowTable), (Object)((Object)checkTableVO));
            ArrayList<CheckColumnVO> checkColumnVOs = new ArrayList<CheckColumnVO>();
            HashSet<CheckResult> tableCheckResults = new HashSet<CheckResult>();
            for (QATable realTable : realTableList) {
                if (!HussarUtils.equals((Object)realTable.getTableName(), (Object)nowTable.getTableName())) continue;
                CheckResult tableCheckComment = new CheckResult(QAConstant.MATCH_SUCCESS.getStatus());
                tableCheckResults.add(tableCheckComment);
                this.checkColumn(nowTable, realTable, tableCheckResults, checkColumnVOs);
            }
            if (HussarUtils.isEmpty(tableCheckResults)) {
                tableCheckResults.add(new CheckResult(QAConstant.TABLE_NAME_MISMATCH.getStatus()));
            }
            checkTableVO.setCheckColumns(checkColumnVOs);
            checkTableVO.setCheckResults(tableCheckResults);
            checkTableVOs.add(checkTableVO);
        }
        return checkTableVOs;
    }

    @Override
    public String checkTableInfoByDbcId(Long dbcId, Long dsId) {
        QATableInfoDTO qaTableInfoDTO = new QATableInfoDTO();
        QADateBaseContent qaDateBaseContent = (QADateBaseContent)((Object)this.qaDateBaseContentService.getById(dbcId));
        if (HussarUtils.isNotEmpty((Object)dsId)) {
            qaDateBaseContent.setDbcSourceId(dsId);
        }
        List<QATable> aiTable = this.getAiTable(null, null, dbcId);
        qaTableInfoDTO.setQatableList(aiTable);
        qaTableInfoDTO.setQaDateBaseContent(qaDateBaseContent);
        List<CheckTableVO> checkTableVOS = this.checkTableInfo(qaTableInfoDTO);
        for (CheckTableVO checkTableVO : checkTableVOS) {
            for (CheckResult checkResult : checkTableVO.getCheckResults()) {
                if (HussarUtils.equals((Object)QAConstant.MATCH_SUCCESS.getStatus(), (Object)checkResult.getStatus())) continue;
                return QAConstant.TABLE_INFO_MISMATCH.getStatus();
            }
        }
        return QAConstant.MATCH_SUCCESS.getStatus();
    }

    private void checkColumn(QATable nowTable, QATable realTable, Set<CheckResult> tableCheckResults, ArrayList<CheckColumnVO> checkColumnVOs) {
        List<QAColumn> realFields = realTable.getFields();
        List<QAColumn> nowTableFields = nowTable.getFields();
        CheckResult tableCheckColumn = new CheckResult(QAConstant.TABLE_COLUMN_MISMATCH.getStatus());
        for (QAColumn nowTableField : nowTableFields) {
            CheckColumnVO checkColumnVO = new CheckColumnVO();
            BeanUtil.copy((Object)((Object)nowTableField), (Object)((Object)checkColumnVO));
            ArrayList<CheckResult> columnCheckResults = new ArrayList<CheckResult>();
            for (QAColumn realField : realFields) {
                if (!HussarUtils.equals((Object)realField.getColName(), (Object)nowTableField.getColName())) continue;
                CheckResult colCheckResult = new CheckResult(QAConstant.MATCH_SUCCESS.getStatus());
                columnCheckResults.add(colCheckResult);
                if (!HussarUtils.equals((Object)realField.getDataType(), (Object)nowTableField.getDataType())) {
                    columnCheckResults.add(new CheckResult(QAConstant.COLUMN_TYPE_MISMATCH.getStatus(), realField.getDataType(), nowTableField.getDataType()));
                    tableCheckResults.add(tableCheckColumn);
                }
                checkColumnVO.setCheckResults(columnCheckResults);
            }
            if (HussarUtils.isEmpty(columnCheckResults)) {
                columnCheckResults.add(new CheckResult(QAConstant.COLUMN_NAME_MISMATCH.getStatus()));
                tableCheckResults.add(tableCheckColumn);
            }
            checkColumnVO.setCheckResults(columnCheckResults);
            checkColumnVOs.add(checkColumnVO);
        }
    }
}

