/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.modelManagement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.modelManagement.dao.ModelReposityMapper;
import com.jxdinfo.hussar.ai.modelManagement.dto.ModelDto;
import com.jxdinfo.hussar.ai.modelManagement.model.ModelRepository;
import com.jxdinfo.hussar.ai.modelManagement.model.TrainingTask;
import com.jxdinfo.hussar.ai.modelManagement.service.IModelRepositoryService;
import com.jxdinfo.hussar.ai.modelManagement.service.ITrainingTaskService;
import com.jxdinfo.hussar.ai.modelManagement.vo.ModelRepositoryVO;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ModelRepositoryServiceImpl
extends ServiceImpl<ModelReposityMapper, ModelRepository>
implements IModelRepositoryService {
    @Resource
    private ITrainingTaskService trainingTaskService;

    @Override
    public Boolean publish(ModelDto modelDto) {
        HussarException.throwByNull((Object)modelDto, (String)"\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a");
        Long taskId = modelDto.getTaskId();
        HussarException.throwByNull((Object)taskId, (String)"\u8bad\u7ec3\u4efb\u52a1id\u4e3a\u7a7a");
        TrainingTask trainingTask = (TrainingTask)((Object)this.trainingTaskService.getById(taskId));
        HussarException.throwByNull((Object)((Object)trainingTask), (String)"\u8bad\u7ec3\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
        ModelRepository modelRepository = new ModelRepository();
        modelRepository.setMediumModelId(modelDto.getMediumModelId());
        modelRepository.setTaskId(taskId);
        modelRepository.setModelName(modelDto.getModelName());
        modelRepository.setModelParams(JSONObject.toJSONString((Object)modelDto.getModelParams()));
        modelRepository.setBasicModelType(trainingTask.getBasicModelType());
        return this.save((Object)modelRepository);
    }

    @Override
    public IPage<ModelRepositoryVO> listModelRepository(Page<ModelRepository> page, ModelRepository modelRepository) {
        if (HussarUtils.isNotEmpty(page) && HussarUtils.isNotEmpty((Object)((Object)modelRepository))) {
            LambdaQueryWrapper modelRepositoryLambdaQueryWrapper = new LambdaQueryWrapper();
            modelRepositoryLambdaQueryWrapper.like(HussarUtils.isNotEmpty((Object)modelRepository.getModelName()), ModelRepository::getModelName, (Object)modelRepository.getModelName());
            modelRepositoryLambdaQueryWrapper.eq(HussarUtils.isNotEmpty((Object)modelRepository.getBasicModelType()), ModelRepository::getBasicModelType, (Object)modelRepository.getBasicModelType());
            Page modelRepositoryPage = (Page)this.page((IPage)page, (Wrapper)modelRepositoryLambdaQueryWrapper);
            Page modelRepositoryVOPage = new Page();
            BeanUtil.copyProperties((Object)modelRepositoryPage, (Object)modelRepositoryVOPage);
            List records = modelRepositoryPage.getRecords();
            if (HussarUtils.isEmpty((Object)records)) {
                return modelRepositoryVOPage;
            }
            List taskIds = records.stream().map(ModelRepository::getTaskId).collect(Collectors.toList());
            LambdaQueryWrapper trainingTaskLambdaQueryWrapper = new LambdaQueryWrapper();
            trainingTaskLambdaQueryWrapper.in(TrainingTask::getTaskId, taskIds);
            List trainingTasks = this.trainingTaskService.list((Wrapper)trainingTaskLambdaQueryWrapper);
            if (HussarUtils.isEmpty((Object)trainingTasks)) {
                return modelRepositoryVOPage;
            }
            Map<Long, String> taskNameMap = trainingTasks.stream().collect(Collectors.toMap(TrainingTask::getTaskId, TrainingTask::getTaskName));
            List modelRepositoryVOS = BeanUtil.copyToList((Collection)records, ModelRepositoryVO.class);
            for (ModelRepositoryVO modelRepositoryVO : modelRepositoryVOS) {
                modelRepositoryVO.setTaskName(taskNameMap.get(modelRepositoryVO.getTaskId()));
            }
            modelRepositoryVOPage.setRecords(modelRepositoryVOS);
            return modelRepositoryVOPage;
        }
        throw new HussarException("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    @Override
    public ModelRepositoryVO getModelRepositoryById(Long id) {
        ModelRepository modelRepository = (ModelRepository)((Object)this.getById(id));
        ModelRepositoryVO modelRepositoryVO = new ModelRepositoryVO();
        BeanUtil.copyProperties((Object)((Object)modelRepository), (Object)((Object)modelRepositoryVO));
        TrainingTask task = (TrainingTask)((Object)this.trainingTaskService.getById(modelRepository.getModelId()));
        if (HussarUtils.isEmpty((Object)((Object)task))) {
            return modelRepositoryVO;
        }
        modelRepositoryVO.setTaskName(task.getTaskName());
        return modelRepositoryVO;
    }
}

