/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.integration.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.ai.appmanager.dto.AppMangerDTO;
import com.jxdinfo.hussar.ai.appmanager.service.IAppManagerService;
import com.jxdinfo.hussar.ai.datamanager.dto.QADataSourceDto;
import com.jxdinfo.hussar.ai.datamanager.service.QADatasourceService;
import com.jxdinfo.hussar.ai.integration.dto.IgAddDialogueQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgAppInfoDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDelDialogueDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDelDialogueQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDialogueCreateDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgDialogueDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgFeedbackDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgSqlQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgStreamQaDTO;
import com.jxdinfo.hussar.ai.integration.dto.IgUpdateDialogueNameDTO;
import com.jxdinfo.hussar.ai.integration.service.IntegrationService;
import com.jxdinfo.hussar.ai.qa.service.IntelligentInterfaceService;
import com.jxdinfo.hussar.ai.qa.service.IntelligentQuestionService;
import com.jxdinfo.hussar.dialogue.dao.DialogueMapper;
import com.jxdinfo.hussar.dialogue.dao.DialogueQaMapper;
import com.jxdinfo.hussar.dialogue.model.Dialogue;
import com.jxdinfo.hussar.dialogue.model.DialogueQa;
import com.jxdinfo.hussar.dialogue.service.IDialogueService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.scenarioai.scenario.dao.QaFaqMapper;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaFaqModel;
import com.jxdinfo.hussar.scenarioai.scenario.model.QaScenarioModel;
import com.jxdinfo.hussar.scenarioai.scenario.service.IScenarioService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
public class IntegrationServiceImpl
implements IntegrationService {
    private static final Logger log = LoggerFactory.getLogger(IntegrationServiceImpl.class);
    @Autowired
    private IAppManagerService appManagerService;
    @Autowired
    private IDialogueService dialogueService;
    @Autowired
    private DialogueQaMapper dialogueQaMapper;
    @Autowired
    private DialogueMapper dialogueMapper;
    @Autowired
    private QaFaqMapper qaFaqMapper;
    @Autowired
    private IScenarioService scenarioService;
    @Autowired
    private QADatasourceService QADatasourceService;
    @Autowired
    private IntelligentInterfaceService intelligentInterfaceService;
    @Autowired
    private IntelligentQuestionService intelligentQuestionService;

    @Override
    public IgAppInfoDTO getAppInfo(Long systemId) {
        AppMangerDTO simpleAppInfo = this.appManagerService.getSimpleAppInfo(systemId);
        IgAppInfoDTO igAppInfoDTO = new IgAppInfoDTO();
        org.springframework.beans.BeanUtils.copyProperties((Object)simpleAppInfo, (Object)igAppInfoDTO);
        return igAppInfoDTO;
    }

    @Override
    public List<IgDialogueDTO> getDialogues(Long systemId, String userId) {
        HussarException.throwBy((systemId == null ? 1 : 0) != 0, (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((boolean)StringUtils.isEmpty((Object)userId), (String)"\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select(new SFunction[]{Dialogue::getId, Dialogue::getCreateTime, Dialogue::getDialogueName});
        query.eq(Dialogue::getSystemId, (Object)systemId);
        query.eq(Dialogue::getCreateUserId, (Object)userId);
        query.orderByDesc(Dialogue::getCreateTime);
        query.eq(Dialogue::getStatus, (Object)"0");
        query.last(" limit 0, 10 ");
        List list = this.dialogueService.list((Wrapper)query);
        return list.stream().map(v -> {
            IgDialogueDTO igDialogueDTO = new IgDialogueDTO();
            igDialogueDTO.setDialogueName(v.getDialogueName());
            igDialogueDTO.setCreateTime(v.getCreateTime());
            igDialogueDTO.setId(v.getId());
            return igDialogueDTO;
        }).collect(Collectors.toList());
    }

    @Override
    public Long createDialogue(IgDialogueCreateDTO dialogueCreateDTO) {
        dialogueCreateDTO.validateFields();
        Dialogue dialogue = new Dialogue();
        dialogue.setStatus("0");
        dialogue.setSystemId(dialogueCreateDTO.getSystemId());
        dialogue.setDialogueName(dialogueCreateDTO.getDialogueName());
        dialogue.setCreateTime(new Date());
        dialogue.setUpdateTime(dialogue.getCreateTime());
        dialogue.setCreateUserId(dialogueCreateDTO.getUserId());
        dialogue.setUpdateUserId(dialogueCreateDTO.getUserId());
        dialogue.setCreateUserName(dialogueCreateDTO.getUserName());
        dialogue.setUpdateUserName(dialogueCreateDTO.getUserName());
        this.dialogueService.save((Object)dialogue);
        return dialogue.getId();
    }

    @Override
    public IPage<DialogueQa> getDialogueQaList(Page<DialogueQa> page, Long dialogueId, String userId) {
        HussarException.throwByNull((Object)dialogueId, (String)"\u5bf9\u8bddId\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((boolean)StringUtils.isEmpty((Object)userId), (String)"\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DialogueQa::getDialogueId, (Object)dialogueId);
        queryWrapper.eq(DialogueQa::getCreateUserId, (Object)userId);
        queryWrapper.eq(DialogueQa::getDialogueState, (Object)"0");
        queryWrapper.orderByDesc(DialogueQa::getCreateTime);
        return this.dialogueQaMapper.selectPage(page, (Wrapper)queryWrapper);
    }

    @Override
    public IPage<QaFaqModel> getFaqList(Page<QaFaqModel> page, Long scenarioId) {
        HussarException.throwByNull((Object)scenarioId, (String)"\u573a\u666fId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QaFaqModel::getScenarioId, (Object)scenarioId);
        queryWrapper.orderByAsc(QaFaqModel::getQuestionId);
        return this.qaFaqMapper.selectPage(page, (Wrapper)queryWrapper);
    }

    @Override
    public void delDialogueQa(IgDelDialogueQaDTO igDelDialogueQaDTO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(DialogueQa::getId, (Object)igDelDialogueQaDTO.getDialogueQaId());
        wrapper.set(DialogueQa::getUpdateTime, (Object)new Date());
        wrapper.set(DialogueQa::getUpdateUserId, (Object)igDelDialogueQaDTO.getUserId());
        wrapper.set(DialogueQa::getUpdateUserName, (Object)igDelDialogueQaDTO.getUserName());
        wrapper.set(DialogueQa::getDialogueState, (Object)"1");
        this.dialogueQaMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public void delDialogue(IgDelDialogueDTO igDelDialogueDTO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Dialogue::getId, (Object)igDelDialogueDTO.getDialogueId());
        wrapper.set(Dialogue::getUpdateTime, (Object)new Date());
        wrapper.set(Dialogue::getUpdateUserId, (Object)igDelDialogueDTO.getUserId());
        wrapper.set(Dialogue::getUpdateUserName, (Object)igDelDialogueDTO.getUserName());
        wrapper.set(Dialogue::getStatus, (Object)"1");
        this.dialogueMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public void feedback(IgFeedbackDTO igFeedbackDTO) {
        Integer isUseful = igFeedbackDTO.getIsUseful();
        HussarException.throwByNull((Object)isUseful, (String)"\u7528\u6237\u53cd\u9988\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwByNull((Object)igFeedbackDTO.getDialogueQaId(), (String)"\u95ee\u7b54ID\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((isUseful != 1 && isUseful != 2 ? 1 : 0) != 0, (String)"\u7528\u6237\u53cd\u9988\u4e0d\u6b63\u786e");
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(DialogueQa::getId, (Object)igFeedbackDTO.getDialogueQaId());
        wrapper.set(DialogueQa::getUpdateTime, (Object)new Date());
        wrapper.set(DialogueQa::getUpdateUserId, (Object)igFeedbackDTO.getUserId());
        wrapper.set(DialogueQa::getUpdateUserName, (Object)igFeedbackDTO.getUserName());
        wrapper.set(DialogueQa::getIsUseful, (Object)String.valueOf(isUseful));
        this.dialogueQaMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public void updateDialogueName(IgUpdateDialogueNameDTO igUpdateDialogueNameDTO) {
        igUpdateDialogueNameDTO.validateFields();
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(Dialogue::getId, (Object)igUpdateDialogueNameDTO.getDialogueId());
        wrapper.set(Dialogue::getUpdateTime, (Object)new Date());
        wrapper.set(Dialogue::getUpdateUserId, (Object)igUpdateDialogueNameDTO.getUserId());
        wrapper.set(Dialogue::getUpdateUserName, (Object)igUpdateDialogueNameDTO.getUserName());
        wrapper.set(Dialogue::getDialogueName, (Object)igUpdateDialogueNameDTO.getDialogueName());
        this.dialogueMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    public Long addDialogueQa(IgAddDialogueQaDTO igAddDialogueQaDTO) {
        DialogueQa dialogue = new DialogueQa();
        dialogue.setScenarioId(igAddDialogueQaDTO.getScenarioId());
        dialogue.setResponseState("0");
        dialogue.setDialogueState("0");
        dialogue.setCreateTime(new Date());
        dialogue.setUpdateTime(new Date());
        dialogue.setCreateUserName(igAddDialogueQaDTO.getUserName());
        dialogue.setCreateUserId(igAddDialogueQaDTO.getUserId());
        dialogue.setUpdateUserName(igAddDialogueQaDTO.getUserName());
        dialogue.setUpdateUserId(igAddDialogueQaDTO.getUserId());
        dialogue.setDialogueName(igAddDialogueQaDTO.getDialogueName());
        dialogue.setDialogueName(igAddDialogueQaDTO.getDialogueName());
        dialogue.setDialogueId(igAddDialogueQaDTO.getDialogueId());
        dialogue.setQuestions(igAddDialogueQaDTO.getQuestion());
        dialogue.setAnswers(igAddDialogueQaDTO.getAnswer());
        dialogue.setQaType(igAddDialogueQaDTO.getQaType());
        this.dialogueQaMapper.insert((Object)dialogue);
        return dialogue.getId();
    }

    @Override
    public Map<String, Object> inference(IgSqlQaDTO sqlQaDTO) {
        QaScenarioModel detail = this.scenarioService.getDetail(sqlQaDTO.getScenarioId());
        HussarException.throwBy((boolean)HussarUtils.equals((Object)"1", (Object)detail.getDelFlag()), (String)"\u8be5\u5e94\u7528\u4e0d\u53ef\u7528");
        Long dataSourceId = (Long)detail.getDataSourceId().get(0);
        QADataSourceDto dataSourceDto = this.QADatasourceService.getDataSourceById(dataSourceId);
        Page voidPage = new Page((long)sqlQaDTO.getCurrent().intValue(), (long)sqlQaDTO.getSize().intValue());
        Map<String, Object> answer = this.intelligentInterfaceService.getAnswer(sqlQaDTO.getQuery(), null, voidPage, dataSourceDto.getConnName(), detail.getModelUrl(), dataSourceId);
        if (this.intelligentQuestionService.saveQuestion(sqlQaDTO.getQuery(), answer.get("data"), answer.get("sqlResult"))) {
            answer.put("msg", "\u4fdd\u5b58\u6210\u529f");
        } else {
            answer.put("msg", "\u4fdd\u5b58\u5931\u8d25");
        }
        return answer;
    }

    @Override
    public SseEmitter knowledgeBaseChat(IgStreamQaDTO igStreamQaDTO) {
        QaScenarioModel detail = this.scenarioService.getDetail(igStreamQaDTO.getScenarioId());
        String modelUrl = detail.getModelUrl();
        SseEmitter sseEmitter = new SseEmitter();
        try {
            Map describe = BeanUtils.describe((Object)igStreamQaDTO);
            describe.remove("scenarioId");
            describe.remove("systemId");
            describe.remove("userId");
            describe.remove("userName");
            describe.put("knowledge_base_name", String.valueOf(detail.getDataSourceId()));
            this.connect(modelUrl, sseEmitter, describe);
            return sseEmitter;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            throw new HussarException("\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public void connect(String modelUrl, SseEmitter sseEmitter, Map<String, String> igStreamQaDTO) {
        try {
            URL url = new URL(modelUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Accept", "text/event-stream");
            ObjectMapper objectMapper = new ObjectMapper();
            try (OutputStream os = connection.getOutputStream();){
                String s = objectMapper.writeValueAsString(igStreamQaDTO);
                byte[] input = s.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            var8_9 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith("data: ")) continue;
                    String eventData = line.substring(6);
                    sseEmitter.send(SseEmitter.event().name("add").data((Object)eventData));
                }
                sseEmitter.complete();
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new HussarException("\u8bf7\u6c42\u5927\u6a21\u578b\u5f02\u5e38", (Throwable)e);
        }
    }
}

