/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.docKnowledgeBase.controller;

import com.jxdinfo.hussar.ai.docKnowledgeBase.dto.DocKnowledgeDataset;
import com.jxdinfo.hussar.ai.docKnowledgeBase.model.QADocument;
import com.jxdinfo.hussar.ai.docKnowledgeBase.service.IDocKnowledgeService;
import com.jxdinfo.hussar.ai.docKnowledgeBase.vo.DocKnowledgeVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/docKnow"})
public class DocKnowledgeController {
    private static final Logger log = LoggerFactory.getLogger(DocKnowledgeController.class);
    @Autowired
    private IDocKnowledgeService docKnowledgeService;

    @RequestMapping(value={"/get"})
    public ApiResponse<DocKnowledgeVO> selectDocKnowledge(@RequestBody DocKnowledgeDataset dataset) {
        try {
            return ApiResponse.success((Object)this.docKnowledgeService.selectDocKnowledge(dataset));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u6587\u4ef6\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/updStrategy"})
    public ApiResponse<Boolean> updStrategyByDocKnow(@RequestBody QADocument qaDocument) {
        try {
            return ApiResponse.success((Object)this.docKnowledgeService.updStrategyByDocKnow(qaDocument));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5207\u5206\u7b56\u7565\u66f4\u65b0\u5931\u8d25");
        }
    }

    @PostMapping(value={"/uploadDoc"})
    public ApiResponse uploadDoc(DocKnowledgeDataset docKnowledgeDataset, MultipartHttpServletRequest multipartRequest) {
        try {
            return ApiResponse.success((String)this.docKnowledgeService.uploadDoc(docKnowledgeDataset, multipartRequest));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @RequestMapping(value={"/previewPdf"})
    public void previewPdf(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="knowledgeId") Long knowledgeId) {
        this.docKnowledgeService.previewPdf(request, response, knowledgeId);
    }

    @RequestMapping(value={"/del"})
    public ApiResponse<Boolean> deleteDoc(@RequestBody List<Long> ids) {
        try {
            return ApiResponse.success((Object)this.docKnowledgeService.deleteDoc(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
        }
    }
}

