/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ai.directoryNavigation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.ai.directoryNavigation.constant.DirectoryNavConstant;
import com.jxdinfo.hussar.ai.directoryNavigation.dao.DirectoryNodeMapper;
import com.jxdinfo.hussar.ai.directoryNavigation.model.Directory;
import com.jxdinfo.hussar.ai.directoryNavigation.model.DirectoryNode;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryNodeService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.IDirectoryService;
import com.jxdinfo.hussar.ai.directoryNavigation.service.INavModelService;
import com.jxdinfo.hussar.ai.directoryNavigation.util.ExcelUtil;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.platform.core.utils.id.UUID;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class DirectoryNodeServiceImpl
extends ServiceImpl<DirectoryNodeMapper, DirectoryNode>
implements IDirectoryNodeService {
    @Resource
    private DirectoryNodeMapper directoryNodeMapper;
    @Resource
    @Lazy
    private IDirectoryService directoryService;
    @Resource
    private INavModelService modelService;

    @Override
    @HussarTransactional
    public void saveOrUpdateNodeList(List<DirectoryNode> directoryNodeList, Long directoryId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId);
        this.remove((Wrapper)wrapper);
        if (directoryNodeList == null || directoryNodeList.isEmpty()) {
            return;
        }
        this.saveBatch(directoryNodeList);
    }

    @Override
    @HussarTransactional
    public void extractKeywords(Long directoryId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).ne(DirectoryNode::getExplanation, (Object)"")).isNotNull(DirectoryNode::getExplanation);
        List nodes = this.list((Wrapper)queryWrapper);
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        for (int i = 0; i < 500; i += 500) {
            List<DirectoryNode> subNodes = nodes.subList(i, Math.min(i + 500, nodes.size()));
            this.modelService.extractKeywords(subNodes);
            this.directoryNodeMapper.updateNodesBatch(subNodes);
        }
    }

    @Override
    public void buildNodeTreeV2(Directory root, List<DirectoryNode> directoryNodes) {
        if (root == null || directoryNodes == null || directoryNodes.isEmpty()) {
            return;
        }
        HashMap<String, DirectoryNode> directoryNodeMap = new HashMap<String, DirectoryNode>();
        for (DirectoryNode directoryNode : directoryNodes) {
            directoryNodeMap.put(directoryNode.getId(), directoryNode);
        }
        for (DirectoryNode directoryNode : directoryNodes) {
            String parentId = directoryNode.getParentId();
            if ("0".equals(parentId)) {
                if (DirectoryNavConstant.IS_LEAF.getCode().equals(directoryNode.getIsLeaf())) {
                    if (root.getLeafNodes() == null) {
                        root.setLeafNodes(new ArrayList<DirectoryNode>());
                    }
                    root.getLeafNodes().add(directoryNode);
                    continue;
                }
                if (root.getChildren() == null) {
                    root.setChildren(new ArrayList<DirectoryNode>());
                }
                root.getChildren().add(directoryNode);
                continue;
            }
            DirectoryNode parentNode = (DirectoryNode)((Object)directoryNodeMap.get(parentId));
            if (DirectoryNavConstant.IS_LEAF.getCode().equals(directoryNode.getIsLeaf())) {
                if (parentNode.getLeafNodes() == null) {
                    parentNode.setLeafNodes(new ArrayList<DirectoryNode>());
                }
                parentNode.getLeafNodes().add(directoryNode);
                continue;
            }
            if (parentNode.getChildren() == null) {
                parentNode.setChildren(new ArrayList<DirectoryNode>());
            }
            parentNode.getChildren().add(directoryNode);
        }
    }

    @Override
    @HussarTransactional
    @Deprecated
    public DirectoryNode saveOrUpdateDirectoryNode(DirectoryNode directoryNode) {
        DirectoryNode oldNode;
        List children;
        boolean changed = false;
        Map<Object, Object> childrenMap = new HashMap();
        if (directoryNode.getChildren() != null && !directoryNode.getChildren().isEmpty()) {
            directoryNode.setIsLeaf(DirectoryNavConstant.NOT_LEAF.getCode());
        }
        if ((children = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DirectoryNode.class).eq(DirectoryNode::getParentId, (Object)directoryNode.getId())).eq(DirectoryNode::getDirectoryId, (Object)directoryNode.getDirectoryId()))) != null && !children.isEmpty()) {
            childrenMap = children.stream().collect(Collectors.toMap(DirectoryNode::getNodeId, node -> node));
        }
        if ((oldNode = (DirectoryNode)((Object)this.getById(directoryNode.getNodeId()))) == null) {
            throw new HussarException("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (!oldNode.equals((Object)directoryNode)) {
            changed = true;
            this.updateById((Object)directoryNode);
        }
        if (directoryNode.getChildren() != null) {
            int sortOrder = 1;
            for (DirectoryNode childNode : directoryNode.getChildren()) {
                childNode.setSortOrder(sortOrder++);
                childNode.setParentId(directoryNode.getId());
                childNode.setDirectoryId(directoryNode.getDirectoryId());
                if (!childrenMap.containsKey(childNode.getNodeId())) {
                    childNode.setIsLeaf(DirectoryNavConstant.IS_LEAF.getCode());
                    this.save((Object)childNode);
                    changed = true;
                    continue;
                }
                DirectoryNode oldChild = (DirectoryNode)((Object)childrenMap.get(childNode.getNodeId()));
                childrenMap.remove(childNode.getNodeId());
                if (oldChild.equals((Object)childNode)) continue;
                changed = true;
                this.updateById((Object)childNode);
            }
        }
        if (!childrenMap.isEmpty()) {
            this.deleteDirectoryNode(new ArrayList<Object>(childrenMap.keySet()));
            changed = true;
        }
        if (changed) {
            Directory directory = (Directory)((Object)this.directoryService.getById(directoryNode.getDirectoryId()));
            if (!DirectoryNavConstant.CHANGED.getCode().equals(directory.getDirectoryStatus()) && !DirectoryNavConstant.WAIT_UPLOAD.getCode().equals(directory.getDirectoryStatus())) {
                directory.setDirectoryStatus(DirectoryNavConstant.CHANGED.getCode());
                this.directoryService.updateById((Object)directory);
            }
        }
        return directoryNode;
    }

    @Override
    @HussarTransactional
    public void updateFullNamePath(List<DirectoryNode> nodes, String parentFullNamePath) {
        parentFullNamePath = parentFullNamePath == null || parentFullNamePath.isEmpty() ? "" : parentFullNamePath + DirectoryNavConstant.SEPARATOR.getCode();
        for (DirectoryNode node : nodes) {
            node.setFullNamePath(parentFullNamePath + node.getNodeName());
            this.updateById((Object)node);
            if (node.getChildren() == null || node.getChildren().isEmpty()) continue;
            this.updateFullNamePath(node.getChildren(), node.getFullNamePath());
        }
    }

    @Override
    @Deprecated
    public void updateFullNamePathByDirectoryId(Long directoryId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId);
        List nodes = this.list((Wrapper)queryWrapper);
        List<DirectoryNode> rootNodes = this.buildNodeTree(nodes);
        this.updateFullNamePath(rootNodes, "");
    }

    @Override
    @HussarTransactional
    @Deprecated
    public boolean deleteDirectoryNode(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(DirectoryNode::getNodeId, ids);
        List nodes = this.list((Wrapper)queryWrapper);
        if (nodes == null || nodes.isEmpty()) {
            return true;
        }
        List<String> treeIds = nodes.stream().map(DirectoryNode::getId).collect(Collectors.toList());
        return this.deleteNodesByTreeIdsAndDirectoryId(treeIds, ((DirectoryNode)((Object)nodes.get(0))).getDirectoryId());
    }

    @Deprecated
    private boolean deleteNodesByTreeIdsAndDirectoryId(List<String> treeIds, Long directoryId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(DirectoryNode::getId, treeIds);
        queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId);
        LambdaQueryWrapper childrenNodes = new LambdaQueryWrapper();
        childrenNodes.in(DirectoryNode::getParentId, treeIds);
        childrenNodes.eq(DirectoryNode::getDirectoryId, (Object)directoryId);
        List children = this.list((Wrapper)childrenNodes);
        if (children != null && !children.isEmpty()) {
            List<String> childrenTreeIds = children.stream().map(DirectoryNode::getId).collect(Collectors.toList());
            this.deleteNodesByTreeIdsAndDirectoryId(childrenTreeIds, directoryId);
        }
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    @HussarTransactional
    public void saveDirectoryNodeTree(List<DirectoryNode> directoryNodeList, String parentId, String fullNamePath, Set<String> leafNodeKeySet, int startNum) {
        HashSet<String> nodeNameSet = new HashSet<String>();
        fullNamePath = fullNamePath == null || fullNamePath.isEmpty() ? "" : fullNamePath + DirectoryNavConstant.SEPARATOR.getCode();
        for (DirectoryNode directoryNode : directoryNodeList) {
            int num;
            if (nodeNameSet.contains(directoryNode.getNodeName())) {
                num = 1;
                while (true) {
                    if (!nodeNameSet.contains(directoryNode.getNodeName() + "_" + num)) {
                        directoryNode.setNodeName(directoryNode.getNodeName() + "_" + num);
                        break;
                    }
                    ++num;
                }
            }
            directoryNode.setId(UUID.randomUUID().toString());
            directoryNode.setParentId(parentId);
            directoryNode.setSortOrder(startNum++);
            directoryNode.setFullNamePath(fullNamePath + directoryNode.getNodeName());
            if (directoryNode.getChildren() == null || directoryNode.getChildren().isEmpty()) {
                if (leafNodeKeySet.contains(directoryNode.getNodeKey())) {
                    num = 1;
                    while (true) {
                        if (!leafNodeKeySet.contains(directoryNode.getNodeKey() + "_" + num)) {
                            directoryNode.setNodeKey(directoryNode.getNodeKey() + "_" + num);
                            break;
                        }
                        ++num;
                    }
                }
                directoryNode.setIsLeaf(DirectoryNavConstant.IS_LEAF.getCode());
                leafNodeKeySet.add(directoryNode.getNodeKey());
            }
            this.save((Object)directoryNode);
            if (directoryNode.getChildren() != null && !directoryNode.getChildren().isEmpty()) {
                this.saveDirectoryNodeTree(directoryNode.getChildren(), directoryNode.getId(), directoryNode.getFullNamePath(), leafNodeKeySet, 1);
            }
            nodeNameSet.add(directoryNode.getNodeName());
        }
    }

    @Override
    @Deprecated
    public List<DirectoryNode> checkBeforeUpload(Long directoryId) {
        Directory directory = (Directory)((Object)this.directoryService.getById(directoryId));
        if (directory == null) {
            throw new HussarException("\u76ee\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (DirectoryNavConstant.UPLOADING.getCode().equals(directory.getDirectoryStatus())) {
            throw new HussarException("\u76ee\u5f55\u6b63\u5728\u4e0a\u4f20\u4e2d\uff01");
        }
        if (DirectoryNavConstant.DELETED.getCode().equals(directory.getIsDeleted())) {
            throw new HussarException("\u76ee\u5f55\u5df2\u5220\u9664\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).eq(DirectoryNode::getIsLeaf, (Object)DirectoryNavConstant.IS_LEAF.getCode());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Deprecated
    public List<DirectoryNode> getLeafNodeList(Long directoryId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).orderByAsc(DirectoryNode::getSortOrder);
        return this.nodeTreeToLeafNodeList(this.list((Wrapper)queryWrapper));
    }

    @Override
    @Deprecated
    public void exportLeafNodeToExcel(HttpServletResponse response, Long directoryId) {
        List<DirectoryNode> leafNodeList = this.getLeafNodeList(directoryId);
        Directory directory = (Directory)((Object)this.directoryService.getById(directoryId));
        ExcelUtil.exportLeafNodesToExcel(response, directory.getDirectoryName(), leafNodeList);
    }

    @Override
    @HussarTransactional
    @Deprecated
    public void extractKeywords(Long directoryId, String extractType) {
        List nodes;
        if (DirectoryNavConstant.EXTRACT_NONE.getCode().equals(extractType)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(DirectoryNode::getDirectoryId, (Object)directoryId)).ne(DirectoryNode::getExplanation, (Object)"")).isNotNull(DirectoryNode::getExplanation);
        if (DirectoryNavConstant.EXTRACT_ONLY_EMPTY.getCode().equals(extractType)) {
            queryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(DirectoryNode::getThesaurusByExplanation)).or()).eq(DirectoryNode::getThesaurusByExplanation, (Object)"");
            });
        }
        if ((nodes = this.list((Wrapper)queryWrapper)) == null || nodes.isEmpty()) {
            return;
        }
        for (int i = 0; i < 500; i += 500) {
            List<DirectoryNode> subNodes = nodes.subList(i, Math.min(i + 500, nodes.size()));
            this.modelService.extractKeywords(subNodes);
            this.directoryNodeMapper.updateNodesBatch(subNodes);
        }
        Directory directory = (Directory)((Object)this.directoryService.getById(directoryId));
        if (!DirectoryNavConstant.CHANGED.getCode().equals(directory.getDirectoryStatus()) && !DirectoryNavConstant.WAIT_UPLOAD.getCode().equals(directory.getDirectoryStatus())) {
            directory.setDirectoryStatus(DirectoryNavConstant.CHANGED.getCode());
            this.directoryService.updateById((Object)directory);
        }
    }

    @Override
    public List<DirectoryNode> buildNodeTree(List<DirectoryNode> directoryNodeList) {
        if (directoryNodeList == null || directoryNodeList.isEmpty()) {
            return null;
        }
        ArrayList<DirectoryNode> rootNodes = new ArrayList<DirectoryNode>();
        HashMap<String, DirectoryNode> directoryNodeMap = new HashMap<String, DirectoryNode>();
        for (DirectoryNode directoryNode : directoryNodeList) {
            directoryNodeMap.put(directoryNode.getId(), directoryNode);
        }
        for (DirectoryNode directoryNode : directoryNodeList) {
            String parentId = directoryNode.getParentId();
            if ("0".equals(parentId)) {
                rootNodes.add(directoryNode);
                continue;
            }
            DirectoryNode parentNode = (DirectoryNode)((Object)directoryNodeMap.get(parentId));
            List<DirectoryNode> children = parentNode.getChildren();
            if (children == null) {
                children = new ArrayList<DirectoryNode>();
                parentNode.setChildren(children);
            }
            children.add(directoryNode);
        }
        return rootNodes;
    }

    @Override
    public List<DirectoryNode> extractNodes(List<DirectoryNode> nodes) {
        List<DirectoryNode> newNodes = nodes.stream().filter(node -> node.getExplanation() != null && !node.getExplanation().isEmpty()).collect(Collectors.toList());
        if (newNodes.isEmpty()) {
            return newNodes;
        }
        newNodes.forEach(node -> {
            node.setNewKeywords(null);
            node.setChildren(null);
        });
        this.modelService.extractNodesKeywords(newNodes);
        return newNodes;
    }

    @Deprecated
    private List<DirectoryNode> nodeTreeToLeafNodeList(List<DirectoryNode> nodes) {
        ArrayList<DirectoryNode> leafNodes = new ArrayList<DirectoryNode>();
        for (DirectoryNode node : nodes) {
            if (node.getChildren() == null || node.getChildren().isEmpty()) {
                leafNodes.add(node);
                continue;
            }
            leafNodes.addAll(this.nodeTreeToLeafNodeList(node.getChildren()));
        }
        return leafNodes;
    }
}

